/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.transferwebhooks;

import com.adyen.model.transferwebhooks.BankAccountV3;
import com.adyen.model.transferwebhooks.JSON;
import com.adyen.model.transferwebhooks.MerchantData;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.core.JsonProcessingException;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@JsonPropertyOrder(value={"balanceAccountId", "bankAccount", "merchant", "transferInstrumentId"})
public class CounterpartyV3 {
    public static final String JSON_PROPERTY_BALANCE_ACCOUNT_ID = "balanceAccountId";
    private String balanceAccountId;
    public static final String JSON_PROPERTY_BANK_ACCOUNT = "bankAccount";
    private BankAccountV3 bankAccount;
    public static final String JSON_PROPERTY_MERCHANT = "merchant";
    private MerchantData merchant;
    public static final String JSON_PROPERTY_TRANSFER_INSTRUMENT_ID = "transferInstrumentId";
    private String transferInstrumentId;

    public CounterpartyV3 balanceAccountId(String balanceAccountId) {
        this.balanceAccountId = balanceAccountId;
        return this;
    }

    @ApiModelProperty(value="The unique identifier of the [balance account](https://docs.adyen.com/api-explorer/#/balanceplatform/latest/post/balanceAccounts__resParam_id).")
    @JsonProperty(value="balanceAccountId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getBalanceAccountId() {
        return this.balanceAccountId;
    }

    @JsonProperty(value="balanceAccountId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setBalanceAccountId(String balanceAccountId) {
        this.balanceAccountId = balanceAccountId;
    }

    public CounterpartyV3 bankAccount(BankAccountV3 bankAccount) {
        this.bankAccount = bankAccount;
        return this;
    }

    @ApiModelProperty(value="")
    @JsonProperty(value="bankAccount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public BankAccountV3 getBankAccount() {
        return this.bankAccount;
    }

    @JsonProperty(value="bankAccount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setBankAccount(BankAccountV3 bankAccount) {
        this.bankAccount = bankAccount;
    }

    public CounterpartyV3 merchant(MerchantData merchant) {
        this.merchant = merchant;
        return this;
    }

    @ApiModelProperty(value="")
    @JsonProperty(value="merchant")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public MerchantData getMerchant() {
        return this.merchant;
    }

    @JsonProperty(value="merchant")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setMerchant(MerchantData merchant) {
        this.merchant = merchant;
    }

    public CounterpartyV3 transferInstrumentId(String transferInstrumentId) {
        this.transferInstrumentId = transferInstrumentId;
        return this;
    }

    @ApiModelProperty(value="The unique identifier of the [transfer instrument](https://docs.adyen.com/api-explorer/#/legalentity/latest/post/transferInstruments__resParam_id).")
    @JsonProperty(value="transferInstrumentId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getTransferInstrumentId() {
        return this.transferInstrumentId;
    }

    @JsonProperty(value="transferInstrumentId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setTransferInstrumentId(String transferInstrumentId) {
        this.transferInstrumentId = transferInstrumentId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CounterpartyV3 counterpartyV3 = (CounterpartyV3)o;
        return Objects.equals(this.balanceAccountId, counterpartyV3.balanceAccountId) && Objects.equals(this.bankAccount, counterpartyV3.bankAccount) && Objects.equals(this.merchant, counterpartyV3.merchant) && Objects.equals(this.transferInstrumentId, counterpartyV3.transferInstrumentId);
    }

    public int hashCode() {
        return Objects.hash(this.balanceAccountId, this.bankAccount, this.merchant, this.transferInstrumentId);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CounterpartyV3 {\n");
        sb.append("    balanceAccountId: ").append(this.toIndentedString(this.balanceAccountId)).append("\n");
        sb.append("    bankAccount: ").append(this.toIndentedString(this.bankAccount)).append("\n");
        sb.append("    merchant: ").append(this.toIndentedString(this.merchant)).append("\n");
        sb.append("    transferInstrumentId: ").append(this.toIndentedString(this.transferInstrumentId)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static CounterpartyV3 fromJson(String jsonString) throws JsonProcessingException {
        return (CounterpartyV3)JSON.getMapper().readValue(jsonString, CounterpartyV3.class);
    }

    public String toJson() throws JsonProcessingException {
        return JSON.getMapper().writeValueAsString((Object)this);
    }
}

