/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.payout;

import com.adyen.model.payout.JSON;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.core.JsonProcessingException;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@JsonPropertyOrder(value={"cardBin", "cardHolderName", "cardIssuingBank", "cardIssuingCountry", "cardIssuingCurrency", "cardPaymentMethod", "cardSummary", "issuerBin"})
public class ResponseAdditionalDataCard {
    public static final String JSON_PROPERTY_CARD_BIN = "cardBin";
    private String cardBin;
    public static final String JSON_PROPERTY_CARD_HOLDER_NAME = "cardHolderName";
    private String cardHolderName;
    public static final String JSON_PROPERTY_CARD_ISSUING_BANK = "cardIssuingBank";
    private String cardIssuingBank;
    public static final String JSON_PROPERTY_CARD_ISSUING_COUNTRY = "cardIssuingCountry";
    private String cardIssuingCountry;
    public static final String JSON_PROPERTY_CARD_ISSUING_CURRENCY = "cardIssuingCurrency";
    private String cardIssuingCurrency;
    public static final String JSON_PROPERTY_CARD_PAYMENT_METHOD = "cardPaymentMethod";
    private String cardPaymentMethod;
    public static final String JSON_PROPERTY_CARD_SUMMARY = "cardSummary";
    private String cardSummary;
    public static final String JSON_PROPERTY_ISSUER_BIN = "issuerBin";
    private String issuerBin;

    public ResponseAdditionalDataCard cardBin(String cardBin) {
        this.cardBin = cardBin;
        return this;
    }

    @ApiModelProperty(value="The first six digits of the card number.  This is the [Bank Identification Number (BIN)](https://docs.adyen.com/get-started-with-adyen/payment-glossary#bank-identification-number-bin) for card numbers with a six-digit BIN.  Example: 521234")
    @JsonProperty(value="cardBin")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getCardBin() {
        return this.cardBin;
    }

    @JsonProperty(value="cardBin")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCardBin(String cardBin) {
        this.cardBin = cardBin;
    }

    public ResponseAdditionalDataCard cardHolderName(String cardHolderName) {
        this.cardHolderName = cardHolderName;
        return this;
    }

    @ApiModelProperty(value="The cardholder name passed in the payment request.")
    @JsonProperty(value="cardHolderName")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getCardHolderName() {
        return this.cardHolderName;
    }

    @JsonProperty(value="cardHolderName")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCardHolderName(String cardHolderName) {
        this.cardHolderName = cardHolderName;
    }

    public ResponseAdditionalDataCard cardIssuingBank(String cardIssuingBank) {
        this.cardIssuingBank = cardIssuingBank;
        return this;
    }

    @ApiModelProperty(value="The bank or the financial institution granting lines of credit through card association branded payment cards. This information can be included when available.")
    @JsonProperty(value="cardIssuingBank")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getCardIssuingBank() {
        return this.cardIssuingBank;
    }

    @JsonProperty(value="cardIssuingBank")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCardIssuingBank(String cardIssuingBank) {
        this.cardIssuingBank = cardIssuingBank;
    }

    public ResponseAdditionalDataCard cardIssuingCountry(String cardIssuingCountry) {
        this.cardIssuingCountry = cardIssuingCountry;
        return this;
    }

    @ApiModelProperty(value="The country where the card was issued.  Example: US")
    @JsonProperty(value="cardIssuingCountry")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getCardIssuingCountry() {
        return this.cardIssuingCountry;
    }

    @JsonProperty(value="cardIssuingCountry")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCardIssuingCountry(String cardIssuingCountry) {
        this.cardIssuingCountry = cardIssuingCountry;
    }

    public ResponseAdditionalDataCard cardIssuingCurrency(String cardIssuingCurrency) {
        this.cardIssuingCurrency = cardIssuingCurrency;
        return this;
    }

    @ApiModelProperty(value="The currency in which the card is issued, if this information is available. Provided as the currency code or currency number from the ISO-4217 standard.   Example: USD")
    @JsonProperty(value="cardIssuingCurrency")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getCardIssuingCurrency() {
        return this.cardIssuingCurrency;
    }

    @JsonProperty(value="cardIssuingCurrency")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCardIssuingCurrency(String cardIssuingCurrency) {
        this.cardIssuingCurrency = cardIssuingCurrency;
    }

    public ResponseAdditionalDataCard cardPaymentMethod(String cardPaymentMethod) {
        this.cardPaymentMethod = cardPaymentMethod;
        return this;
    }

    @ApiModelProperty(value="The card payment method used for the transaction.  Example: amex")
    @JsonProperty(value="cardPaymentMethod")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getCardPaymentMethod() {
        return this.cardPaymentMethod;
    }

    @JsonProperty(value="cardPaymentMethod")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCardPaymentMethod(String cardPaymentMethod) {
        this.cardPaymentMethod = cardPaymentMethod;
    }

    public ResponseAdditionalDataCard cardSummary(String cardSummary) {
        this.cardSummary = cardSummary;
        return this;
    }

    @ApiModelProperty(value="The last four digits of a card number.  > Returned only in case of a card payment.")
    @JsonProperty(value="cardSummary")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getCardSummary() {
        return this.cardSummary;
    }

    @JsonProperty(value="cardSummary")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCardSummary(String cardSummary) {
        this.cardSummary = cardSummary;
    }

    public ResponseAdditionalDataCard issuerBin(String issuerBin) {
        this.issuerBin = issuerBin;
        return this;
    }

    @ApiModelProperty(value="The first eight digits of the card number. Only returned if the card number is 16 digits or more.  This is the [Bank Identification Number (BIN)](https://docs.adyen.com/get-started-with-adyen/payment-glossary#bank-identification-number-bin) for card numbers with an eight-digit BIN.  Example: 52123423")
    @JsonProperty(value="issuerBin")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getIssuerBin() {
        return this.issuerBin;
    }

    @JsonProperty(value="issuerBin")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setIssuerBin(String issuerBin) {
        this.issuerBin = issuerBin;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ResponseAdditionalDataCard responseAdditionalDataCard = (ResponseAdditionalDataCard)o;
        return Objects.equals(this.cardBin, responseAdditionalDataCard.cardBin) && Objects.equals(this.cardHolderName, responseAdditionalDataCard.cardHolderName) && Objects.equals(this.cardIssuingBank, responseAdditionalDataCard.cardIssuingBank) && Objects.equals(this.cardIssuingCountry, responseAdditionalDataCard.cardIssuingCountry) && Objects.equals(this.cardIssuingCurrency, responseAdditionalDataCard.cardIssuingCurrency) && Objects.equals(this.cardPaymentMethod, responseAdditionalDataCard.cardPaymentMethod) && Objects.equals(this.cardSummary, responseAdditionalDataCard.cardSummary) && Objects.equals(this.issuerBin, responseAdditionalDataCard.issuerBin);
    }

    public int hashCode() {
        return Objects.hash(this.cardBin, this.cardHolderName, this.cardIssuingBank, this.cardIssuingCountry, this.cardIssuingCurrency, this.cardPaymentMethod, this.cardSummary, this.issuerBin);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ResponseAdditionalDataCard {\n");
        sb.append("    cardBin: ").append(this.toIndentedString(this.cardBin)).append("\n");
        sb.append("    cardHolderName: ").append(this.toIndentedString(this.cardHolderName)).append("\n");
        sb.append("    cardIssuingBank: ").append(this.toIndentedString(this.cardIssuingBank)).append("\n");
        sb.append("    cardIssuingCountry: ").append(this.toIndentedString(this.cardIssuingCountry)).append("\n");
        sb.append("    cardIssuingCurrency: ").append(this.toIndentedString(this.cardIssuingCurrency)).append("\n");
        sb.append("    cardPaymentMethod: ").append(this.toIndentedString(this.cardPaymentMethod)).append("\n");
        sb.append("    cardSummary: ").append(this.toIndentedString(this.cardSummary)).append("\n");
        sb.append("    issuerBin: ").append(this.toIndentedString(this.issuerBin)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static ResponseAdditionalDataCard fromJson(String jsonString) throws JsonProcessingException {
        return (ResponseAdditionalDataCard)JSON.getMapper().readValue(jsonString, ResponseAdditionalDataCard.class);
    }

    public String toJson() throws JsonProcessingException {
        return JSON.getMapper().writeValueAsString((Object)this);
    }
}

