/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.httpclient;

import com.adyen.Config;
import com.adyen.constants.ApiConstants;
import com.adyen.httpclient.AdyenResponse;
import com.adyen.httpclient.AdyenResponseHandler;
import com.adyen.httpclient.ClientInterface;
import com.adyen.httpclient.HTTPClientException;
import com.adyen.model.RequestOptions;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.util.Base64;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import org.apache.hc.client5.http.classic.methods.HttpDelete;
import org.apache.hc.client5.http.classic.methods.HttpGet;
import org.apache.hc.client5.http.classic.methods.HttpPatch;
import org.apache.hc.client5.http.classic.methods.HttpPost;
import org.apache.hc.client5.http.classic.methods.HttpUriRequest;
import org.apache.hc.client5.http.classic.methods.HttpUriRequestBase;
import org.apache.hc.client5.http.config.RequestConfig;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.client5.http.impl.classic.HttpClients;
import org.apache.hc.client5.http.impl.io.PoolingHttpClientConnectionManagerBuilder;
import org.apache.hc.client5.http.io.HttpClientConnectionManager;
import org.apache.hc.client5.http.socket.LayeredConnectionSocketFactory;
import org.apache.hc.client5.http.ssl.SSLConnectionSocketFactory;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.HttpHost;
import org.apache.hc.core5.http.io.HttpClientResponseHandler;
import org.apache.hc.core5.http.io.entity.StringEntity;
import org.apache.hc.core5.net.URIBuilder;
import org.apache.hc.core5.ssl.SSLContexts;

public class AdyenHttpClient
implements ClientInterface {
    private static final String CHARSET = "UTF-8";
    private Proxy proxy;

    public Proxy getProxy() {
        return this.proxy;
    }

    public void setProxy(Proxy proxy) {
        this.proxy = proxy;
    }

    @Override
    public String request(String endpoint, String requestBody, Config config) throws IOException, HTTPClientException {
        return this.request(endpoint, requestBody, config, false);
    }

    @Override
    public String request(String endpoint, String requestBody, Config config, boolean isApiKeyRequired) throws IOException, HTTPClientException {
        return this.request(endpoint, requestBody, config, isApiKeyRequired, null);
    }

    @Override
    public String request(String endpoint, String requestBody, Config config, boolean isApiKeyRequired, RequestOptions requestOptions) throws IOException, HTTPClientException {
        return this.request(endpoint, requestBody, config, isApiKeyRequired, requestOptions, ApiConstants.HttpMethod.POST);
    }

    @Override
    public String request(String endpoint, String requestBody, Config config, boolean isApiKeyRequired, RequestOptions requestOptions, ApiConstants.HttpMethod httpMethod) throws IOException, HTTPClientException {
        return this.request(endpoint, requestBody, config, isApiKeyRequired, requestOptions, httpMethod, null);
    }

    @Override
    public String request(String endpoint, String requestBody, Config config, boolean isApiKeyRequired, RequestOptions requestOptions, ApiConstants.HttpMethod httpMethod, Map<String, String> params) throws IOException, HTTPClientException {
        try (CloseableHttpClient httpclient = this.createCloseableHttpClient(config);){
            HttpUriRequestBase httpRequest = this.createRequest(endpoint, requestBody, config, isApiKeyRequired, requestOptions, httpMethod, params);
            AdyenResponse response = (AdyenResponse)httpclient.execute((ClassicHttpRequest)httpRequest, (HttpClientResponseHandler)new AdyenResponseHandler());
            if (response.getStatus() < 200 || response.getStatus() >= 300) {
                throw new HTTPClientException(response.getStatus(), "HTTP Exception", response.getHeaders(), response.getBody());
            }
            String string = response.getBody();
            return string;
        }
    }

    private HttpUriRequestBase createRequest(String endpoint, String requestBody, Config config, boolean isApiKeyRequired, RequestOptions requestOptions, ApiConstants.HttpMethod httpMethod, Map<String, String> params) throws HTTPClientException {
        HttpUriRequestBase httpRequest = this.createHttpRequestBase(this.createUri(endpoint, params), requestBody, httpMethod);
        RequestConfig.Builder builder = RequestConfig.custom();
        if (config.getReadTimeoutMillis() > 0) {
            builder.setResponseTimeout((long)config.getReadTimeoutMillis(), TimeUnit.MILLISECONDS);
        }
        if (config.getConnectionTimeoutMillis() > 0) {
            builder.setConnectTimeout((long)config.getConnectionTimeoutMillis(), TimeUnit.MILLISECONDS);
        }
        if (this.proxy != null && this.proxy.address() instanceof InetSocketAddress) {
            InetSocketAddress inetSocketAddress = (InetSocketAddress)this.proxy.address();
            builder.setProxy(new HttpHost(inetSocketAddress.getHostName(), inetSocketAddress.getPort()));
        }
        httpRequest.setConfig(builder.build());
        this.setAuthentication((HttpUriRequest)httpRequest, isApiKeyRequired, config);
        this.setHeaders(config, requestOptions, httpRequest);
        return httpRequest;
    }

    private void setHeaders(Config config, RequestOptions requestOptions, HttpUriRequestBase httpUriRequest) {
        this.setContentType((HttpUriRequest)httpUriRequest, "application/json");
        httpUriRequest.addHeader("Accept-Charset", (Object)CHARSET);
        httpUriRequest.addHeader("User-Agent", (Object)String.format("%s %s/%s", config.getApplicationName(), "adyen-java-api-library", "27.0.0"));
        httpUriRequest.addHeader("adyen-library-name", (Object)"adyen-java-api-library");
        httpUriRequest.addHeader("adyen-library-version", (Object)"27.0.0");
        if (requestOptions != null) {
            if (requestOptions.getIdempotencyKey() != null) {
                httpUriRequest.addHeader("Idempotency-Key", (Object)requestOptions.getIdempotencyKey());
            }
            if (requestOptions.getRequestedVerificationCodeHeader() != null) {
                httpUriRequest.addHeader("x-requested-verification-code", (Object)requestOptions.getRequestedVerificationCodeHeader());
            }
            if (requestOptions.getAdditionalServiceHeaders() != null) {
                requestOptions.getAdditionalServiceHeaders().forEach((arg_0, arg_1) -> ((HttpUriRequestBase)httpUriRequest).addHeader(arg_0, arg_1));
            }
        }
    }

    private HttpUriRequestBase createHttpRequestBase(URI endpoint, String requestBody, ApiConstants.HttpMethod httpMethod) {
        StringEntity requestEntity = null;
        if (requestBody != null && !requestBody.isEmpty()) {
            requestEntity = new StringEntity(requestBody, Charset.forName(CHARSET));
        }
        switch (httpMethod) {
            case GET: {
                return new HttpGet(endpoint);
            }
            case PATCH: {
                HttpPatch httpPatch = new HttpPatch(endpoint);
                httpPatch.setEntity((HttpEntity)requestEntity);
                return httpPatch;
            }
            case DELETE: {
                return new HttpDelete(endpoint);
            }
        }
        HttpPost httpPost = new HttpPost(endpoint);
        httpPost.setEntity((HttpEntity)requestEntity);
        return httpPost;
    }

    private URI createUri(String endpoint, Map<String, String> params) throws HTTPClientException {
        try {
            URIBuilder uriBuilder = new URIBuilder(endpoint);
            if (params != null && !params.isEmpty()) {
                for (String key : params.keySet()) {
                    uriBuilder.addParameter(key, params.get(key));
                }
            }
            return uriBuilder.build();
        }
        catch (URISyntaxException e) {
            throw new HTTPClientException("Invalid URI", e);
        }
    }

    private CloseableHttpClient createCloseableHttpClient(Config config) {
        SSLContext sslContext = config.getSSLContext();
        if (sslContext == null) {
            sslContext = SSLContexts.createDefault();
        }
        HostnameVerifier hostnameVerifier = config.getHostnameVerifier();
        return this.createHttpClientWithSocketFactory(new SSLConnectionSocketFactory(sslContext, hostnameVerifier));
    }

    private CloseableHttpClient createHttpClientWithSocketFactory(SSLConnectionSocketFactory socketFactory) {
        return HttpClients.custom().setConnectionManager((HttpClientConnectionManager)PoolingHttpClientConnectionManagerBuilder.create().setSSLSocketFactory((LayeredConnectionSocketFactory)socketFactory).build()).build();
    }

    private void setAuthentication(HttpUriRequest httpUriRequest, boolean isApiKeyRequired, Config config) {
        String apiKey = config.getApiKey();
        if (isApiKeyRequired || apiKey != null && !apiKey.isEmpty()) {
            this.setApiKey(httpUriRequest, apiKey);
        } else {
            this.setBasicAuthentication(httpUriRequest, config.getUsername(), config.getPassword());
        }
    }

    private void setContentType(HttpUriRequest httpUriRequest, String contentType) {
        httpUriRequest.addHeader("Content-Type", (Object)contentType);
    }

    private void setApiKey(HttpUriRequest httpUriRequest, String apiKey) {
        if (apiKey != null && !apiKey.isEmpty()) {
            httpUriRequest.addHeader("x-api-key", (Object)apiKey);
        }
    }

    private void setBasicAuthentication(HttpUriRequest httpUriRequest, String username, String password) {
        String authString = username + ":" + password;
        byte[] authEncBytes = Base64.getEncoder().encode(authString.getBytes());
        String authStringEnc = new String(authEncBytes);
        httpUriRequest.addHeader("Authorization", (Object)("Basic " + authStringEnc));
    }
}

