/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.util;

import java.util.Arrays;

public final class MaskUtil {
    private static final char MASK_CHAR = '*';
    private static final int MASK_FIXED_BLOCK_SIZE = 4;
    private static final String MASKED_BLOCK;
    private static final int CARD_NUMBER_UNMASK_LAST_BLOCK_SIZE = 4;

    private MaskUtil() {
    }

    public static String mask(String strToMask) {
        if (strToMask == null || strToMask.isEmpty()) {
            return "";
        }
        return MASKED_BLOCK;
    }

    public static String maskCardNumber(String cardNumber) {
        if (cardNumber == null || cardNumber.isEmpty()) {
            return "";
        }
        String cardNumberOnlyDigits = cardNumber.replaceAll("[^\\d]", "");
        if (cardNumberOnlyDigits.length() < 4) {
            return "";
        }
        char[] maskedChars = cardNumberOnlyDigits.toCharArray();
        Arrays.fill(maskedChars, 0, cardNumberOnlyDigits.length() - 4, '*');
        return new String(maskedChars);
    }

    static {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < 4; ++i) {
            sb.append('*');
        }
        MASKED_BLOCK = sb.toString();
    }
}

