/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.service.transfers;

import com.adyen.Client;
import com.adyen.Service;
import com.adyen.constants.ApiConstants;
import com.adyen.model.RequestOptions;
import com.adyen.model.transfers.FindTransfersResponse;
import com.adyen.model.transfers.ReturnTransferRequest;
import com.adyen.model.transfers.ReturnTransferResponse;
import com.adyen.model.transfers.Transfer;
import com.adyen.model.transfers.TransferData;
import com.adyen.model.transfers.TransferInfo;
import com.adyen.service.exception.ApiException;
import com.adyen.service.resource.Resource;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.util.HashMap;

public class TransfersApi
extends Service {
    public static final String API_VERSION = "4";
    protected String baseURL;

    public TransfersApi(Client client) {
        super(client);
        this.baseURL = this.createBaseURL("https://balanceplatform-api-test.adyen.com/btl/v4");
    }

    public TransfersApi(Client client, String baseURL) {
        super(client);
        this.baseURL = baseURL;
    }

    public FindTransfersResponse getAllTransfers(OffsetDateTime createdSince, OffsetDateTime createdUntil) throws ApiException, IOException {
        return this.getAllTransfers(null, null, null, null, null, null, createdSince, createdUntil, null, null, null);
    }

    public FindTransfersResponse getAllTransfers(String balancePlatform, String accountHolderId, String balanceAccountId, String paymentInstrumentId, String reference, String category, OffsetDateTime createdSince, OffsetDateTime createdUntil, String cursor, Integer limit, RequestOptions requestOptions) throws ApiException, IOException {
        HashMap<String, String> queryParams = new HashMap<String, String>();
        if (balancePlatform != null) {
            queryParams.put("balancePlatform", balancePlatform);
        }
        if (accountHolderId != null) {
            queryParams.put("accountHolderId", accountHolderId);
        }
        if (balanceAccountId != null) {
            queryParams.put("balanceAccountId", balanceAccountId);
        }
        if (paymentInstrumentId != null) {
            queryParams.put("paymentInstrumentId", paymentInstrumentId);
        }
        if (reference != null) {
            queryParams.put("reference", reference);
        }
        if (category != null) {
            queryParams.put("category", category);
        }
        if (createdSince != null) {
            queryParams.put("createdSince", createdSince.toString());
        }
        if (createdUntil != null) {
            queryParams.put("createdUntil", createdUntil.toString());
        }
        if (cursor != null) {
            queryParams.put("cursor", cursor);
        }
        if (limit != null) {
            queryParams.put("limit", limit.toString());
        }
        String requestBody = null;
        Resource resource = new Resource(this, this.baseURL + "/transfers", null);
        String jsonResult = resource.request(requestBody, requestOptions, ApiConstants.HttpMethod.GET, null, queryParams);
        return FindTransfersResponse.fromJson(jsonResult);
    }

    public TransferData getTransfer(String id) throws ApiException, IOException {
        return this.getTransfer(id, null);
    }

    public TransferData getTransfer(String id, RequestOptions requestOptions) throws ApiException, IOException {
        HashMap<String, String> pathParams = new HashMap<String, String>();
        if (id == null) {
            throw new IllegalArgumentException("Please provide the id path parameter");
        }
        pathParams.put("id", id);
        String requestBody = null;
        Resource resource = new Resource(this, this.baseURL + "/transfers/{id}", null);
        String jsonResult = resource.request(requestBody, requestOptions, ApiConstants.HttpMethod.GET, pathParams);
        return TransferData.fromJson(jsonResult);
    }

    public ReturnTransferResponse returnTransfer(String transferId, ReturnTransferRequest returnTransferRequest) throws ApiException, IOException {
        return this.returnTransfer(transferId, returnTransferRequest, null);
    }

    public ReturnTransferResponse returnTransfer(String transferId, ReturnTransferRequest returnTransferRequest, RequestOptions requestOptions) throws ApiException, IOException {
        HashMap<String, String> pathParams = new HashMap<String, String>();
        if (transferId == null) {
            throw new IllegalArgumentException("Please provide the transferId path parameter");
        }
        pathParams.put("transferId", transferId);
        String requestBody = returnTransferRequest.toJson();
        Resource resource = new Resource(this, this.baseURL + "/transfers/{transferId}/returns", null);
        String jsonResult = resource.request(requestBody, requestOptions, ApiConstants.HttpMethod.POST, pathParams);
        return ReturnTransferResponse.fromJson(jsonResult);
    }

    public Transfer transferFunds(TransferInfo transferInfo) throws ApiException, IOException {
        return this.transferFunds(transferInfo, null);
    }

    public Transfer transferFunds(TransferInfo transferInfo, RequestOptions requestOptions) throws ApiException, IOException {
        String requestBody = transferInfo.toJson();
        Resource resource = new Resource(this, this.baseURL + "/transfers", null);
        String jsonResult = resource.request(requestBody, requestOptions, ApiConstants.HttpMethod.POST, null);
        return Transfer.fromJson(jsonResult);
    }
}

