/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.service.balanceplatform;

import com.adyen.Client;
import com.adyen.Service;
import com.adyen.constants.ApiConstants;
import com.adyen.model.RequestOptions;
import com.adyen.model.balanceplatform.BalancePlatform;
import com.adyen.model.balanceplatform.PaginatedAccountHoldersResponse;
import com.adyen.service.exception.ApiException;
import com.adyen.service.resource.Resource;
import java.io.IOException;
import java.util.HashMap;

public class PlatformApi
extends Service {
    public static final String API_VERSION = "2";
    protected String baseURL;

    public PlatformApi(Client client) {
        super(client);
        this.baseURL = this.createBaseURL("https://balanceplatform-api-test.adyen.com/bcl/v2");
    }

    public PlatformApi(Client client, String baseURL) {
        super(client);
        this.baseURL = baseURL;
    }

    public PaginatedAccountHoldersResponse getAllAccountHoldersUnderBalancePlatform(String id) throws ApiException, IOException {
        return this.getAllAccountHoldersUnderBalancePlatform(id, null, null, null);
    }

    public PaginatedAccountHoldersResponse getAllAccountHoldersUnderBalancePlatform(String id, Integer offset, Integer limit, RequestOptions requestOptions) throws ApiException, IOException {
        HashMap<String, String> pathParams = new HashMap<String, String>();
        if (id == null) {
            throw new IllegalArgumentException("Please provide the id path parameter");
        }
        pathParams.put("id", id);
        HashMap<String, String> queryParams = new HashMap<String, String>();
        if (offset != null) {
            queryParams.put("offset", offset.toString());
        }
        if (limit != null) {
            queryParams.put("limit", limit.toString());
        }
        String requestBody = null;
        Resource resource = new Resource(this, this.baseURL + "/balancePlatforms/{id}/accountHolders", null);
        String jsonResult = resource.request(requestBody, requestOptions, ApiConstants.HttpMethod.GET, pathParams, queryParams);
        return PaginatedAccountHoldersResponse.fromJson(jsonResult);
    }

    public BalancePlatform getBalancePlatform(String id) throws ApiException, IOException {
        return this.getBalancePlatform(id, null);
    }

    public BalancePlatform getBalancePlatform(String id, RequestOptions requestOptions) throws ApiException, IOException {
        HashMap<String, String> pathParams = new HashMap<String, String>();
        if (id == null) {
            throw new IllegalArgumentException("Please provide the id path parameter");
        }
        pathParams.put("id", id);
        String requestBody = null;
        Resource resource = new Resource(this, this.baseURL + "/balancePlatforms/{id}", null);
        String jsonResult = resource.request(requestBody, requestOptions, ApiConstants.HttpMethod.GET, pathParams);
        return BalancePlatform.fromJson(jsonResult);
    }
}

