/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.transfers;

import com.adyen.model.transfers.JSON;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.core.JsonProcessingException;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@JsonPropertyOrder(value={"city", "country", "line1", "line2", "postalCode", "stateOrProvince"})
public class Address {
    public static final String JSON_PROPERTY_CITY = "city";
    private String city;
    public static final String JSON_PROPERTY_COUNTRY = "country";
    private String country;
    public static final String JSON_PROPERTY_LINE1 = "line1";
    private String line1;
    public static final String JSON_PROPERTY_LINE2 = "line2";
    private String line2;
    public static final String JSON_PROPERTY_POSTAL_CODE = "postalCode";
    private String postalCode;
    public static final String JSON_PROPERTY_STATE_OR_PROVINCE = "stateOrProvince";
    private String stateOrProvince;

    public Address city(String city) {
        this.city = city;
        return this;
    }

    @ApiModelProperty(value="The name of the city.")
    @JsonProperty(value="city")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getCity() {
        return this.city;
    }

    @JsonProperty(value="city")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCity(String city) {
        this.city = city;
    }

    public Address country(String country) {
        this.country = country;
        return this;
    }

    @ApiModelProperty(required=true, value="The two-character ISO 3166-1 alpha-2 country code. For example, **US**, **NL**, or **GB**.")
    @JsonProperty(value="country")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getCountry() {
        return this.country;
    }

    @JsonProperty(value="country")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCountry(String country) {
        this.country = country;
    }

    public Address line1(String line1) {
        this.line1 = line1;
        return this;
    }

    @ApiModelProperty(value="First line of the street address.")
    @JsonProperty(value="line1")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getLine1() {
        return this.line1;
    }

    @JsonProperty(value="line1")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setLine1(String line1) {
        this.line1 = line1;
    }

    public Address line2(String line2) {
        this.line2 = line2;
        return this;
    }

    @ApiModelProperty(value="Second line of the street address.")
    @JsonProperty(value="line2")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getLine2() {
        return this.line2;
    }

    @JsonProperty(value="line2")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setLine2(String line2) {
        this.line2 = line2;
    }

    public Address postalCode(String postalCode) {
        this.postalCode = postalCode;
        return this;
    }

    @ApiModelProperty(value="The postal code. Maximum length: * 5 digits for an address in the US. * 10 characters for an address in all other countries.")
    @JsonProperty(value="postalCode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getPostalCode() {
        return this.postalCode;
    }

    @JsonProperty(value="postalCode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPostalCode(String postalCode) {
        this.postalCode = postalCode;
    }

    public Address stateOrProvince(String stateOrProvince) {
        this.stateOrProvince = stateOrProvince;
        return this;
    }

    @ApiModelProperty(value="The two-letter ISO 3166-2 state or province code. For example, **CA** in the US or **ON** in Canada. > Required for the US and Canada.")
    @JsonProperty(value="stateOrProvince")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getStateOrProvince() {
        return this.stateOrProvince;
    }

    @JsonProperty(value="stateOrProvince")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setStateOrProvince(String stateOrProvince) {
        this.stateOrProvince = stateOrProvince;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Address address = (Address)o;
        return Objects.equals(this.city, address.city) && Objects.equals(this.country, address.country) && Objects.equals(this.line1, address.line1) && Objects.equals(this.line2, address.line2) && Objects.equals(this.postalCode, address.postalCode) && Objects.equals(this.stateOrProvince, address.stateOrProvince);
    }

    public int hashCode() {
        return Objects.hash(this.city, this.country, this.line1, this.line2, this.postalCode, this.stateOrProvince);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Address {\n");
        sb.append("    city: ").append(this.toIndentedString(this.city)).append("\n");
        sb.append("    country: ").append(this.toIndentedString(this.country)).append("\n");
        sb.append("    line1: ").append(this.toIndentedString(this.line1)).append("\n");
        sb.append("    line2: ").append(this.toIndentedString(this.line2)).append("\n");
        sb.append("    postalCode: ").append(this.toIndentedString(this.postalCode)).append("\n");
        sb.append("    stateOrProvince: ").append(this.toIndentedString(this.stateOrProvince)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static Address fromJson(String jsonString) throws JsonProcessingException {
        return (Address)JSON.getMapper().readValue(jsonString, Address.class);
    }

    public String toJson() throws JsonProcessingException {
        return JSON.getMapper().writeValueAsString((Object)this);
    }
}

