/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.posterminalmanagement;

import com.adyen.model.posterminalmanagement.JSON;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.core.JsonProcessingException;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@JsonPropertyOrder(value={"companyAccount", "merchantAccount", "store"})
public class GetTerminalsUnderAccountRequest {
    public static final String JSON_PROPERTY_COMPANY_ACCOUNT = "companyAccount";
    private String companyAccount;
    public static final String JSON_PROPERTY_MERCHANT_ACCOUNT = "merchantAccount";
    private String merchantAccount;
    public static final String JSON_PROPERTY_STORE = "store";
    private String store;

    public GetTerminalsUnderAccountRequest companyAccount(String companyAccount) {
        this.companyAccount = companyAccount;
        return this;
    }

    @ApiModelProperty(required=true, value="Your company account. If you only specify this parameter, the response includes all terminals at all account levels.")
    @JsonProperty(value="companyAccount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getCompanyAccount() {
        return this.companyAccount;
    }

    @JsonProperty(value="companyAccount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCompanyAccount(String companyAccount) {
        this.companyAccount = companyAccount;
    }

    public GetTerminalsUnderAccountRequest merchantAccount(String merchantAccount) {
        this.merchantAccount = merchantAccount;
        return this;
    }

    @ApiModelProperty(value="The merchant account. This is required if you are retrieving the terminals assigned to a store.If you don't specify a `store` the response includes the terminals assigned to the specified merchant account and the terminals assigned to the stores under this merchant account.")
    @JsonProperty(value="merchantAccount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getMerchantAccount() {
        return this.merchantAccount;
    }

    @JsonProperty(value="merchantAccount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setMerchantAccount(String merchantAccount) {
        this.merchantAccount = merchantAccount;
    }

    public GetTerminalsUnderAccountRequest store(String store) {
        this.store = store;
        return this;
    }

    @ApiModelProperty(value="The store code of the store. With this parameter, the response only includes the terminals assigned to the specified store.")
    @JsonProperty(value="store")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getStore() {
        return this.store;
    }

    @JsonProperty(value="store")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setStore(String store) {
        this.store = store;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GetTerminalsUnderAccountRequest getTerminalsUnderAccountRequest = (GetTerminalsUnderAccountRequest)o;
        return Objects.equals(this.companyAccount, getTerminalsUnderAccountRequest.companyAccount) && Objects.equals(this.merchantAccount, getTerminalsUnderAccountRequest.merchantAccount) && Objects.equals(this.store, getTerminalsUnderAccountRequest.store);
    }

    public int hashCode() {
        return Objects.hash(this.companyAccount, this.merchantAccount, this.store);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class GetTerminalsUnderAccountRequest {\n");
        sb.append("    companyAccount: ").append(this.toIndentedString(this.companyAccount)).append("\n");
        sb.append("    merchantAccount: ").append(this.toIndentedString(this.merchantAccount)).append("\n");
        sb.append("    store: ").append(this.toIndentedString(this.store)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static GetTerminalsUnderAccountRequest fromJson(String jsonString) throws JsonProcessingException {
        return (GetTerminalsUnderAccountRequest)JSON.getMapper().readValue(jsonString, GetTerminalsUnderAccountRequest.class);
    }

    public String toJson() throws JsonProcessingException {
        return JSON.getMapper().writeValueAsString((Object)this);
    }
}

