/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.payment;

import com.adyen.model.payment.JSON;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonProcessingException;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@JsonPropertyOrder(value={"plan", "value"})
public class Installments {
    public static final String JSON_PROPERTY_PLAN = "plan";
    private PlanEnum plan;
    public static final String JSON_PROPERTY_VALUE = "value";
    private Integer value;

    public Installments plan(PlanEnum plan) {
        this.plan = plan;
        return this;
    }

    @ApiModelProperty(value="The installment plan, used for [card installments in Japan](https://docs.adyen.com/payment-methods/cards/credit-card-installments#make-a-payment-japan). By default, this is set to **regular**. Possible values: * **regular** * **revolving** ")
    @JsonProperty(value="plan")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public PlanEnum getPlan() {
        return this.plan;
    }

    @JsonProperty(value="plan")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPlan(PlanEnum plan) {
        this.plan = plan;
    }

    public Installments value(Integer value) {
        this.value = value;
        return this;
    }

    @ApiModelProperty(required=true, value="Defines the number of installments. Its value needs to be greater than zero.  Usually, the maximum allowed number of installments is capped. For example, it may not be possible to split a payment in more than 24 installments. The acquirer sets this upper limit, so its value may vary.")
    @JsonProperty(value="value")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getValue() {
        return this.value;
    }

    @JsonProperty(value="value")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setValue(Integer value) {
        this.value = value;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Installments installments = (Installments)o;
        return Objects.equals((Object)this.plan, (Object)installments.plan) && Objects.equals(this.value, installments.value);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.plan, this.value});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Installments {\n");
        sb.append("    plan: ").append(this.toIndentedString((Object)this.plan)).append("\n");
        sb.append("    value: ").append(this.toIndentedString(this.value)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static Installments fromJson(String jsonString) throws JsonProcessingException {
        return (Installments)JSON.getMapper().readValue(jsonString, Installments.class);
    }

    public String toJson() throws JsonProcessingException {
        return JSON.getMapper().writeValueAsString((Object)this);
    }

    public static enum PlanEnum {
        REGULAR("regular"),
        REVOLVING("revolving");

        private String value;

        private PlanEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static PlanEnum fromValue(String value) {
            for (PlanEnum b : PlanEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

