/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.checkout;

import com.adyen.model.checkout.JSON;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.core.JsonProcessingException;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@JsonPropertyOrder(value={"brand", "type"})
public class ResponsePaymentMethod {
    public static final String JSON_PROPERTY_BRAND = "brand";
    private String brand;
    public static final String JSON_PROPERTY_TYPE = "type";
    private String type;

    public ResponsePaymentMethod brand(String brand) {
        this.brand = brand;
        return this;
    }

    @ApiModelProperty(value="The card brand that the shopper used to pay. Only returned if `paymentMethod.type` is **scheme**.")
    @JsonProperty(value="brand")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getBrand() {
        return this.brand;
    }

    @JsonProperty(value="brand")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setBrand(String brand) {
        this.brand = brand;
    }

    public ResponsePaymentMethod type(String type) {
        this.type = type;
        return this;
    }

    @ApiModelProperty(value="The `paymentMethod.type` value used in the request.")
    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getType() {
        return this.type;
    }

    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setType(String type) {
        this.type = type;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ResponsePaymentMethod responsePaymentMethod = (ResponsePaymentMethod)o;
        return Objects.equals(this.brand, responsePaymentMethod.brand) && Objects.equals(this.type, responsePaymentMethod.type);
    }

    public int hashCode() {
        return Objects.hash(this.brand, this.type);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ResponsePaymentMethod {\n");
        sb.append("    brand: ").append(this.toIndentedString(this.brand)).append("\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static ResponsePaymentMethod fromJson(String jsonString) throws JsonProcessingException {
        return (ResponsePaymentMethod)JSON.getMapper().readValue(jsonString, ResponsePaymentMethod.class);
    }

    public String toJson() throws JsonProcessingException {
        return JSON.getMapper().writeValueAsString((Object)this);
    }
}

