/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.payment;

import com.adyen.model.payment.JSON;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonProcessingException;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@JsonPropertyOrder(value={"threeDSReqPriorAuthData", "threeDSReqPriorAuthMethod", "threeDSReqPriorAuthTimestamp", "threeDSReqPriorRef"})
public class ThreeDSRequestorPriorAuthenticationInfo {
    public static final String JSON_PROPERTY_THREE_D_S_REQ_PRIOR_AUTH_DATA = "threeDSReqPriorAuthData";
    private String threeDSReqPriorAuthData;
    public static final String JSON_PROPERTY_THREE_D_S_REQ_PRIOR_AUTH_METHOD = "threeDSReqPriorAuthMethod";
    private ThreeDSReqPriorAuthMethodEnum threeDSReqPriorAuthMethod;
    public static final String JSON_PROPERTY_THREE_D_S_REQ_PRIOR_AUTH_TIMESTAMP = "threeDSReqPriorAuthTimestamp";
    private String threeDSReqPriorAuthTimestamp;
    public static final String JSON_PROPERTY_THREE_D_S_REQ_PRIOR_REF = "threeDSReqPriorRef";
    private String threeDSReqPriorRef;

    public ThreeDSRequestorPriorAuthenticationInfo threeDSReqPriorAuthData(String threeDSReqPriorAuthData) {
        this.threeDSReqPriorAuthData = threeDSReqPriorAuthData;
        return this;
    }

    @ApiModelProperty(value="Data that documents and supports a specific authentication process. Maximum length: 2048 bytes.")
    @JsonProperty(value="threeDSReqPriorAuthData")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getThreeDSReqPriorAuthData() {
        return this.threeDSReqPriorAuthData;
    }

    @JsonProperty(value="threeDSReqPriorAuthData")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setThreeDSReqPriorAuthData(String threeDSReqPriorAuthData) {
        this.threeDSReqPriorAuthData = threeDSReqPriorAuthData;
    }

    public ThreeDSRequestorPriorAuthenticationInfo threeDSReqPriorAuthMethod(ThreeDSReqPriorAuthMethodEnum threeDSReqPriorAuthMethod) {
        this.threeDSReqPriorAuthMethod = threeDSReqPriorAuthMethod;
        return this;
    }

    @ApiModelProperty(value="Mechanism used by the Cardholder to previously authenticate to the 3DS Requestor. Allowed values: * **01** \u2014 Frictionless authentication occurred by ACS. * **02** \u2014 Cardholder challenge occurred by ACS. * **03** \u2014 AVS verified. * **04** \u2014 Other issuer methods.")
    @JsonProperty(value="threeDSReqPriorAuthMethod")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public ThreeDSReqPriorAuthMethodEnum getThreeDSReqPriorAuthMethod() {
        return this.threeDSReqPriorAuthMethod;
    }

    @JsonProperty(value="threeDSReqPriorAuthMethod")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setThreeDSReqPriorAuthMethod(ThreeDSReqPriorAuthMethodEnum threeDSReqPriorAuthMethod) {
        this.threeDSReqPriorAuthMethod = threeDSReqPriorAuthMethod;
    }

    public ThreeDSRequestorPriorAuthenticationInfo threeDSReqPriorAuthTimestamp(String threeDSReqPriorAuthTimestamp) {
        this.threeDSReqPriorAuthTimestamp = threeDSReqPriorAuthTimestamp;
        return this;
    }

    @ApiModelProperty(value="Date and time in UTC of the prior cardholder authentication. Format: YYYYMMDDHHMM")
    @JsonProperty(value="threeDSReqPriorAuthTimestamp")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getThreeDSReqPriorAuthTimestamp() {
        return this.threeDSReqPriorAuthTimestamp;
    }

    @JsonProperty(value="threeDSReqPriorAuthTimestamp")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setThreeDSReqPriorAuthTimestamp(String threeDSReqPriorAuthTimestamp) {
        this.threeDSReqPriorAuthTimestamp = threeDSReqPriorAuthTimestamp;
    }

    public ThreeDSRequestorPriorAuthenticationInfo threeDSReqPriorRef(String threeDSReqPriorRef) {
        this.threeDSReqPriorRef = threeDSReqPriorRef;
        return this;
    }

    @ApiModelProperty(value="This data element provides additional information to the ACS to determine the best approach for handing a request. This data element contains an ACS Transaction ID for a prior authenticated transaction. For example, the first recurring transaction that was authenticated with the cardholder. Length: 30 characters.")
    @JsonProperty(value="threeDSReqPriorRef")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getThreeDSReqPriorRef() {
        return this.threeDSReqPriorRef;
    }

    @JsonProperty(value="threeDSReqPriorRef")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setThreeDSReqPriorRef(String threeDSReqPriorRef) {
        this.threeDSReqPriorRef = threeDSReqPriorRef;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ThreeDSRequestorPriorAuthenticationInfo threeDSRequestorPriorAuthenticationInfo = (ThreeDSRequestorPriorAuthenticationInfo)o;
        return Objects.equals(this.threeDSReqPriorAuthData, threeDSRequestorPriorAuthenticationInfo.threeDSReqPriorAuthData) && Objects.equals((Object)this.threeDSReqPriorAuthMethod, (Object)threeDSRequestorPriorAuthenticationInfo.threeDSReqPriorAuthMethod) && Objects.equals(this.threeDSReqPriorAuthTimestamp, threeDSRequestorPriorAuthenticationInfo.threeDSReqPriorAuthTimestamp) && Objects.equals(this.threeDSReqPriorRef, threeDSRequestorPriorAuthenticationInfo.threeDSReqPriorRef);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.threeDSReqPriorAuthData, this.threeDSReqPriorAuthMethod, this.threeDSReqPriorAuthTimestamp, this.threeDSReqPriorRef});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ThreeDSRequestorPriorAuthenticationInfo {\n");
        sb.append("    threeDSReqPriorAuthData: ").append(this.toIndentedString(this.threeDSReqPriorAuthData)).append("\n");
        sb.append("    threeDSReqPriorAuthMethod: ").append(this.toIndentedString((Object)this.threeDSReqPriorAuthMethod)).append("\n");
        sb.append("    threeDSReqPriorAuthTimestamp: ").append(this.toIndentedString(this.threeDSReqPriorAuthTimestamp)).append("\n");
        sb.append("    threeDSReqPriorRef: ").append(this.toIndentedString(this.threeDSReqPriorRef)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static ThreeDSRequestorPriorAuthenticationInfo fromJson(String jsonString) throws JsonProcessingException {
        return (ThreeDSRequestorPriorAuthenticationInfo)JSON.getMapper().readValue(jsonString, ThreeDSRequestorPriorAuthenticationInfo.class);
    }

    public String toJson() throws JsonProcessingException {
        return JSON.getMapper().writeValueAsString((Object)this);
    }

    public static enum ThreeDSReqPriorAuthMethodEnum {
        _01("01"),
        _02("02"),
        _03("03"),
        _04("04");

        private String value;

        private ThreeDSReqPriorAuthMethodEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static ThreeDSReqPriorAuthMethodEnum fromValue(String value) {
            for (ThreeDSReqPriorAuthMethodEnum b : ThreeDSReqPriorAuthMethodEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

