/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.marketpayaccount;

import com.adyen.model.marketpayaccount.JSON;
import com.adyen.model.marketpayaccount.ViasAddress;
import com.adyen.model.marketpayaccount.ViasPhoneNumber;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonProcessingException;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@JsonPropertyOrder(value={"address", "fullPhoneNumber", "logo", "merchantAccount", "merchantCategoryCode", "merchantHouseNumber", "phoneNumber", "shopperInteraction", "splitConfigurationUUID", "status", "store", "storeName", "storeReference", "virtualAccount", "webAddress"})
public class StoreDetail {
    public static final String JSON_PROPERTY_ADDRESS = "address";
    private ViasAddress address;
    public static final String JSON_PROPERTY_FULL_PHONE_NUMBER = "fullPhoneNumber";
    private String fullPhoneNumber;
    public static final String JSON_PROPERTY_LOGO = "logo";
    private String logo;
    public static final String JSON_PROPERTY_MERCHANT_ACCOUNT = "merchantAccount";
    private String merchantAccount;
    public static final String JSON_PROPERTY_MERCHANT_CATEGORY_CODE = "merchantCategoryCode";
    private String merchantCategoryCode;
    public static final String JSON_PROPERTY_MERCHANT_HOUSE_NUMBER = "merchantHouseNumber";
    private String merchantHouseNumber;
    public static final String JSON_PROPERTY_PHONE_NUMBER = "phoneNumber";
    private ViasPhoneNumber phoneNumber;
    public static final String JSON_PROPERTY_SHOPPER_INTERACTION = "shopperInteraction";
    private ShopperInteractionEnum shopperInteraction;
    public static final String JSON_PROPERTY_SPLIT_CONFIGURATION_U_U_I_D = "splitConfigurationUUID";
    private String splitConfigurationUUID;
    public static final String JSON_PROPERTY_STATUS = "status";
    private StatusEnum status;
    public static final String JSON_PROPERTY_STORE = "store";
    private String store;
    public static final String JSON_PROPERTY_STORE_NAME = "storeName";
    private String storeName;
    public static final String JSON_PROPERTY_STORE_REFERENCE = "storeReference";
    private String storeReference;
    public static final String JSON_PROPERTY_VIRTUAL_ACCOUNT = "virtualAccount";
    private String virtualAccount;
    public static final String JSON_PROPERTY_WEB_ADDRESS = "webAddress";
    private String webAddress;

    public StoreDetail address(ViasAddress address) {
        this.address = address;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="address")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public ViasAddress getAddress() {
        return this.address;
    }

    @JsonProperty(value="address")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAddress(ViasAddress address) {
        this.address = address;
    }

    public StoreDetail fullPhoneNumber(String fullPhoneNumber) {
        this.fullPhoneNumber = fullPhoneNumber;
        return this;
    }

    @ApiModelProperty(value="The phone number of the store provided as a single string.  It will be handled as a landline phone.  Examples: \"0031 6 11 22 33 44\", \"+316/1122-3344\", \"(0031) 611223344\"")
    @JsonProperty(value="fullPhoneNumber")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getFullPhoneNumber() {
        return this.fullPhoneNumber;
    }

    @JsonProperty(value="fullPhoneNumber")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setFullPhoneNumber(String fullPhoneNumber) {
        this.fullPhoneNumber = fullPhoneNumber;
    }

    public StoreDetail logo(String logo) {
        this.logo = logo;
        return this;
    }

    @ApiModelProperty(value="Store logo for payment method setup.")
    @JsonProperty(value="logo")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getLogo() {
        return this.logo;
    }

    @JsonProperty(value="logo")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setLogo(String logo) {
        this.logo = logo;
    }

    public StoreDetail merchantAccount(String merchantAccount) {
        this.merchantAccount = merchantAccount;
        return this;
    }

    @ApiModelProperty(required=true, value="The merchant account to which the store belongs.")
    @JsonProperty(value="merchantAccount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getMerchantAccount() {
        return this.merchantAccount;
    }

    @JsonProperty(value="merchantAccount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setMerchantAccount(String merchantAccount) {
        this.merchantAccount = merchantAccount;
    }

    public StoreDetail merchantCategoryCode(String merchantCategoryCode) {
        this.merchantCategoryCode = merchantCategoryCode;
        return this;
    }

    @ApiModelProperty(required=true, value="The merchant category code (MCC) that classifies the business of the account holder.")
    @JsonProperty(value="merchantCategoryCode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getMerchantCategoryCode() {
        return this.merchantCategoryCode;
    }

    @JsonProperty(value="merchantCategoryCode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setMerchantCategoryCode(String merchantCategoryCode) {
        this.merchantCategoryCode = merchantCategoryCode;
    }

    public StoreDetail merchantHouseNumber(String merchantHouseNumber) {
        this.merchantHouseNumber = merchantHouseNumber;
        return this;
    }

    @ApiModelProperty(value="Merchant house number for payment method setup.")
    @JsonProperty(value="merchantHouseNumber")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getMerchantHouseNumber() {
        return this.merchantHouseNumber;
    }

    @JsonProperty(value="merchantHouseNumber")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setMerchantHouseNumber(String merchantHouseNumber) {
        this.merchantHouseNumber = merchantHouseNumber;
    }

    public StoreDetail phoneNumber(ViasPhoneNumber phoneNumber) {
        this.phoneNumber = phoneNumber;
        return this;
    }

    @ApiModelProperty(value="")
    @JsonProperty(value="phoneNumber")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public ViasPhoneNumber getPhoneNumber() {
        return this.phoneNumber;
    }

    @JsonProperty(value="phoneNumber")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPhoneNumber(ViasPhoneNumber phoneNumber) {
        this.phoneNumber = phoneNumber;
    }

    public StoreDetail shopperInteraction(ShopperInteractionEnum shopperInteraction) {
        this.shopperInteraction = shopperInteraction;
        return this;
    }

    @ApiModelProperty(value="The sales channel. Possible values: **Ecommerce**, **POS**.")
    @JsonProperty(value="shopperInteraction")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public ShopperInteractionEnum getShopperInteraction() {
        return this.shopperInteraction;
    }

    @JsonProperty(value="shopperInteraction")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setShopperInteraction(ShopperInteractionEnum shopperInteraction) {
        this.shopperInteraction = shopperInteraction;
    }

    public StoreDetail splitConfigurationUUID(String splitConfigurationUUID) {
        this.splitConfigurationUUID = splitConfigurationUUID;
        return this;
    }

    @ApiModelProperty(value="The unique reference for the split configuration, returned when you configure splits in your Customer Area. When this is provided, the `virtualAccount` is also required. Adyen uses the configuration and the `virtualAccount` to split funds between accounts in your platform.")
    @JsonProperty(value="splitConfigurationUUID")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getSplitConfigurationUUID() {
        return this.splitConfigurationUUID;
    }

    @JsonProperty(value="splitConfigurationUUID")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSplitConfigurationUUID(String splitConfigurationUUID) {
        this.splitConfigurationUUID = splitConfigurationUUID;
    }

    public StoreDetail status(StatusEnum status) {
        this.status = status;
        return this;
    }

    @ApiModelProperty(value="The status of the store. Possible values: **Pending**, **Active**, **Inactive**, **InactiveWithModifications**, **Closed**.")
    @JsonProperty(value="status")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public StatusEnum getStatus() {
        return this.status;
    }

    @JsonProperty(value="status")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setStatus(StatusEnum status) {
        this.status = status;
    }

    public StoreDetail store(String store) {
        this.store = store;
        return this;
    }

    @ApiModelProperty(value="Adyen-generated unique alphanumeric identifier (UUID) for the store, returned in the response when you create a store. Required when updating an existing store in an `/updateAccountHolder` request.")
    @JsonProperty(value="store")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getStore() {
        return this.store;
    }

    @JsonProperty(value="store")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setStore(String store) {
        this.store = store;
    }

    public StoreDetail storeName(String storeName) {
        this.storeName = storeName;
        return this;
    }

    @ApiModelProperty(value="The name of the account holder's store. This value is shown in shopper statements.  * Length: Between 3 to 22 characters   * The following characters are *not* supported: **:;}{$#@!|<>%^*+=\\\\**")
    @JsonProperty(value="storeName")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getStoreName() {
        return this.storeName;
    }

    @JsonProperty(value="storeName")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setStoreName(String storeName) {
        this.storeName = storeName;
    }

    public StoreDetail storeReference(String storeReference) {
        this.storeReference = storeReference;
        return this;
    }

    @ApiModelProperty(value="Your unique identifier for the store. The Customer Area also uses this value for the store description.   * Length: Between 3 to 128 characters  * The following characters are *not* supported: **:;}{$#@!|<>%^*+=\\\\**")
    @JsonProperty(value="storeReference")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getStoreReference() {
        return this.storeReference;
    }

    @JsonProperty(value="storeReference")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setStoreReference(String storeReference) {
        this.storeReference = storeReference;
    }

    public StoreDetail virtualAccount(String virtualAccount) {
        this.virtualAccount = virtualAccount;
        return this;
    }

    @ApiModelProperty(value="The account holder's `accountCode` where the split amount will be sent. Required when you provide the `splitConfigurationUUID`.")
    @JsonProperty(value="virtualAccount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getVirtualAccount() {
        return this.virtualAccount;
    }

    @JsonProperty(value="virtualAccount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setVirtualAccount(String virtualAccount) {
        this.virtualAccount = virtualAccount;
    }

    public StoreDetail webAddress(String webAddress) {
        this.webAddress = webAddress;
        return this;
    }

    @ApiModelProperty(value="URL of the ecommerce store.")
    @JsonProperty(value="webAddress")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getWebAddress() {
        return this.webAddress;
    }

    @JsonProperty(value="webAddress")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setWebAddress(String webAddress) {
        this.webAddress = webAddress;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StoreDetail storeDetail = (StoreDetail)o;
        return Objects.equals(this.address, storeDetail.address) && Objects.equals(this.fullPhoneNumber, storeDetail.fullPhoneNumber) && Objects.equals(this.logo, storeDetail.logo) && Objects.equals(this.merchantAccount, storeDetail.merchantAccount) && Objects.equals(this.merchantCategoryCode, storeDetail.merchantCategoryCode) && Objects.equals(this.merchantHouseNumber, storeDetail.merchantHouseNumber) && Objects.equals(this.phoneNumber, storeDetail.phoneNumber) && Objects.equals((Object)this.shopperInteraction, (Object)storeDetail.shopperInteraction) && Objects.equals(this.splitConfigurationUUID, storeDetail.splitConfigurationUUID) && Objects.equals((Object)this.status, (Object)storeDetail.status) && Objects.equals(this.store, storeDetail.store) && Objects.equals(this.storeName, storeDetail.storeName) && Objects.equals(this.storeReference, storeDetail.storeReference) && Objects.equals(this.virtualAccount, storeDetail.virtualAccount) && Objects.equals(this.webAddress, storeDetail.webAddress);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.address, this.fullPhoneNumber, this.logo, this.merchantAccount, this.merchantCategoryCode, this.merchantHouseNumber, this.phoneNumber, this.shopperInteraction, this.splitConfigurationUUID, this.status, this.store, this.storeName, this.storeReference, this.virtualAccount, this.webAddress});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class StoreDetail {\n");
        sb.append("    address: ").append(this.toIndentedString(this.address)).append("\n");
        sb.append("    fullPhoneNumber: ").append(this.toIndentedString(this.fullPhoneNumber)).append("\n");
        sb.append("    logo: ").append(this.toIndentedString(this.logo)).append("\n");
        sb.append("    merchantAccount: ").append(this.toIndentedString(this.merchantAccount)).append("\n");
        sb.append("    merchantCategoryCode: ").append(this.toIndentedString(this.merchantCategoryCode)).append("\n");
        sb.append("    merchantHouseNumber: ").append(this.toIndentedString(this.merchantHouseNumber)).append("\n");
        sb.append("    phoneNumber: ").append(this.toIndentedString(this.phoneNumber)).append("\n");
        sb.append("    shopperInteraction: ").append(this.toIndentedString((Object)this.shopperInteraction)).append("\n");
        sb.append("    splitConfigurationUUID: ").append(this.toIndentedString(this.splitConfigurationUUID)).append("\n");
        sb.append("    status: ").append(this.toIndentedString((Object)this.status)).append("\n");
        sb.append("    store: ").append(this.toIndentedString(this.store)).append("\n");
        sb.append("    storeName: ").append(this.toIndentedString(this.storeName)).append("\n");
        sb.append("    storeReference: ").append(this.toIndentedString(this.storeReference)).append("\n");
        sb.append("    virtualAccount: ").append(this.toIndentedString(this.virtualAccount)).append("\n");
        sb.append("    webAddress: ").append(this.toIndentedString(this.webAddress)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static StoreDetail fromJson(String jsonString) throws JsonProcessingException {
        return (StoreDetail)JSON.getMapper().readValue(jsonString, StoreDetail.class);
    }

    public String toJson() throws JsonProcessingException {
        return JSON.getMapper().writeValueAsString((Object)this);
    }

    public static enum StatusEnum {
        ACTIVE("Active"),
        CLOSED("Closed"),
        INACTIVE("Inactive"),
        INACTIVEWITHMODIFICATIONS("InactiveWithModifications"),
        PENDING("Pending");

        private String value;

        private StatusEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static StatusEnum fromValue(String value) {
            for (StatusEnum b : StatusEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }

    public static enum ShopperInteractionEnum {
        ECOMMERCE("Ecommerce"),
        POS("POS");

        private String value;

        private ShopperInteractionEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static ShopperInteractionEnum fromValue(String value) {
            for (ShopperInteractionEnum b : ShopperInteractionEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

