/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.balanceplatform;

import com.adyen.model.balanceplatform.AdditionalBankIdentification;
import com.adyen.model.balanceplatform.JSON;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonProcessingException;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@JsonPropertyOrder(value={"accountNumber", "additionalBankIdentification", "bic", "formFactor", "type"})
public class NumberAndBicAccountIdentification {
    public static final String JSON_PROPERTY_ACCOUNT_NUMBER = "accountNumber";
    private String accountNumber;
    public static final String JSON_PROPERTY_ADDITIONAL_BANK_IDENTIFICATION = "additionalBankIdentification";
    private AdditionalBankIdentification additionalBankIdentification;
    public static final String JSON_PROPERTY_BIC = "bic";
    private String bic;
    public static final String JSON_PROPERTY_FORM_FACTOR = "formFactor";
    private String formFactor = "physical";
    public static final String JSON_PROPERTY_TYPE = "type";
    private TypeEnum type = TypeEnum.NUMBERANDBIC;

    public NumberAndBicAccountIdentification accountNumber(String accountNumber) {
        this.accountNumber = accountNumber;
        return this;
    }

    @ApiModelProperty(required=true, value="The bank account number, without separators or whitespace. The length and format depends on the bank or country.")
    @JsonProperty(value="accountNumber")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getAccountNumber() {
        return this.accountNumber;
    }

    @JsonProperty(value="accountNumber")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAccountNumber(String accountNumber) {
        this.accountNumber = accountNumber;
    }

    public NumberAndBicAccountIdentification additionalBankIdentification(AdditionalBankIdentification additionalBankIdentification) {
        this.additionalBankIdentification = additionalBankIdentification;
        return this;
    }

    @ApiModelProperty(value="")
    @JsonProperty(value="additionalBankIdentification")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public AdditionalBankIdentification getAdditionalBankIdentification() {
        return this.additionalBankIdentification;
    }

    @JsonProperty(value="additionalBankIdentification")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAdditionalBankIdentification(AdditionalBankIdentification additionalBankIdentification) {
        this.additionalBankIdentification = additionalBankIdentification;
    }

    public NumberAndBicAccountIdentification bic(String bic) {
        this.bic = bic;
        return this;
    }

    @ApiModelProperty(required=true, value="The bank's 8- or 11-character BIC or SWIFT code.")
    @JsonProperty(value="bic")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getBic() {
        return this.bic;
    }

    @JsonProperty(value="bic")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setBic(String bic) {
        this.bic = bic;
    }

    public NumberAndBicAccountIdentification formFactor(String formFactor) {
        this.formFactor = formFactor;
        return this;
    }

    @ApiModelProperty(value="The form factor of the account.  Possible values: **physical**, **virtual**. Default value: **physical**.")
    @JsonProperty(value="formFactor")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getFormFactor() {
        return this.formFactor;
    }

    @JsonProperty(value="formFactor")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setFormFactor(String formFactor) {
        this.formFactor = formFactor;
    }

    public NumberAndBicAccountIdentification type(TypeEnum type) {
        this.type = type;
        return this;
    }

    @ApiModelProperty(required=true, value="**numberAndBic**")
    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public TypeEnum getType() {
        return this.type;
    }

    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setType(TypeEnum type) {
        this.type = type;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NumberAndBicAccountIdentification numberAndBicAccountIdentification = (NumberAndBicAccountIdentification)o;
        return Objects.equals(this.accountNumber, numberAndBicAccountIdentification.accountNumber) && Objects.equals(this.additionalBankIdentification, numberAndBicAccountIdentification.additionalBankIdentification) && Objects.equals(this.bic, numberAndBicAccountIdentification.bic) && Objects.equals(this.formFactor, numberAndBicAccountIdentification.formFactor) && Objects.equals((Object)this.type, (Object)numberAndBicAccountIdentification.type);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.accountNumber, this.additionalBankIdentification, this.bic, this.formFactor, this.type});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class NumberAndBicAccountIdentification {\n");
        sb.append("    accountNumber: ").append(this.toIndentedString(this.accountNumber)).append("\n");
        sb.append("    additionalBankIdentification: ").append(this.toIndentedString(this.additionalBankIdentification)).append("\n");
        sb.append("    bic: ").append(this.toIndentedString(this.bic)).append("\n");
        sb.append("    formFactor: ").append(this.toIndentedString(this.formFactor)).append("\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static NumberAndBicAccountIdentification fromJson(String jsonString) throws JsonProcessingException {
        return (NumberAndBicAccountIdentification)JSON.getMapper().readValue(jsonString, NumberAndBicAccountIdentification.class);
    }

    public String toJson() throws JsonProcessingException {
        return JSON.getMapper().writeValueAsString((Object)this);
    }

    public static enum TypeEnum {
        NUMBERANDBIC("numberAndBic");

        private String value;

        private TypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static TypeEnum fromValue(String value) {
            for (TypeEnum b : TypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

