/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.payment;

import com.adyen.model.payment.AcctInfo;
import com.adyen.model.payment.DeviceRenderOptions;
import com.adyen.model.payment.JSON;
import com.adyen.model.payment.Phone;
import com.adyen.model.payment.SDKEphemPubKey;
import com.adyen.model.payment.ThreeDSRequestorAuthenticationInfo;
import com.adyen.model.payment.ThreeDSRequestorPriorAuthenticationInfo;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonProcessingException;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@JsonPropertyOrder(value={"acctInfo", "acctType", "acquirerBIN", "acquirerMerchantID", "addrMatch", "authenticationOnly", "challengeIndicator", "deviceChannel", "deviceRenderOptions", "homePhone", "mcc", "merchantName", "messageVersion", "mobilePhone", "notificationURL", "payTokenInd", "paymentAuthenticationUseCase", "purchaseInstalData", "recurringExpiry", "recurringFrequency", "sdkAppID", "sdkEncData", "sdkEphemPubKey", "sdkMaxTimeout", "sdkReferenceNumber", "sdkTransID", "sdkVersion", "threeDSCompInd", "threeDSRequestorAuthenticationInd", "threeDSRequestorAuthenticationInfo", "threeDSRequestorChallengeInd", "threeDSRequestorID", "threeDSRequestorName", "threeDSRequestorPriorAuthenticationInfo", "threeDSRequestorURL", "transType", "transactionType", "whiteListStatus", "workPhone"})
public class ThreeDS2RequestData {
    public static final String JSON_PROPERTY_ACCT_INFO = "acctInfo";
    private AcctInfo acctInfo;
    public static final String JSON_PROPERTY_ACCT_TYPE = "acctType";
    private AcctTypeEnum acctType;
    public static final String JSON_PROPERTY_ACQUIRER_B_I_N = "acquirerBIN";
    private String acquirerBIN;
    public static final String JSON_PROPERTY_ACQUIRER_MERCHANT_I_D = "acquirerMerchantID";
    private String acquirerMerchantID;
    public static final String JSON_PROPERTY_ADDR_MATCH = "addrMatch";
    private AddrMatchEnum addrMatch;
    public static final String JSON_PROPERTY_AUTHENTICATION_ONLY = "authenticationOnly";
    private Boolean authenticationOnly = false;
    public static final String JSON_PROPERTY_CHALLENGE_INDICATOR = "challengeIndicator";
    private ChallengeIndicatorEnum challengeIndicator;
    public static final String JSON_PROPERTY_DEVICE_CHANNEL = "deviceChannel";
    private String deviceChannel;
    public static final String JSON_PROPERTY_DEVICE_RENDER_OPTIONS = "deviceRenderOptions";
    private DeviceRenderOptions deviceRenderOptions;
    public static final String JSON_PROPERTY_HOME_PHONE = "homePhone";
    private Phone homePhone;
    public static final String JSON_PROPERTY_MCC = "mcc";
    private String mcc;
    public static final String JSON_PROPERTY_MERCHANT_NAME = "merchantName";
    private String merchantName;
    public static final String JSON_PROPERTY_MESSAGE_VERSION = "messageVersion";
    private String messageVersion;
    public static final String JSON_PROPERTY_MOBILE_PHONE = "mobilePhone";
    private Phone mobilePhone;
    public static final String JSON_PROPERTY_NOTIFICATION_U_R_L = "notificationURL";
    private String notificationURL;
    public static final String JSON_PROPERTY_PAY_TOKEN_IND = "payTokenInd";
    private Boolean payTokenInd;
    public static final String JSON_PROPERTY_PAYMENT_AUTHENTICATION_USE_CASE = "paymentAuthenticationUseCase";
    private String paymentAuthenticationUseCase;
    public static final String JSON_PROPERTY_PURCHASE_INSTAL_DATA = "purchaseInstalData";
    private String purchaseInstalData;
    public static final String JSON_PROPERTY_RECURRING_EXPIRY = "recurringExpiry";
    private String recurringExpiry;
    public static final String JSON_PROPERTY_RECURRING_FREQUENCY = "recurringFrequency";
    private String recurringFrequency;
    public static final String JSON_PROPERTY_SDK_APP_I_D = "sdkAppID";
    private String sdkAppID;
    public static final String JSON_PROPERTY_SDK_ENC_DATA = "sdkEncData";
    private String sdkEncData;
    public static final String JSON_PROPERTY_SDK_EPHEM_PUB_KEY = "sdkEphemPubKey";
    private SDKEphemPubKey sdkEphemPubKey;
    public static final String JSON_PROPERTY_SDK_MAX_TIMEOUT = "sdkMaxTimeout";
    private Integer sdkMaxTimeout = 60;
    public static final String JSON_PROPERTY_SDK_REFERENCE_NUMBER = "sdkReferenceNumber";
    private String sdkReferenceNumber;
    public static final String JSON_PROPERTY_SDK_TRANS_I_D = "sdkTransID";
    private String sdkTransID;
    public static final String JSON_PROPERTY_SDK_VERSION = "sdkVersion";
    private String sdkVersion;
    public static final String JSON_PROPERTY_THREE_D_S_COMP_IND = "threeDSCompInd";
    private String threeDSCompInd;
    public static final String JSON_PROPERTY_THREE_D_S_REQUESTOR_AUTHENTICATION_IND = "threeDSRequestorAuthenticationInd";
    private String threeDSRequestorAuthenticationInd;
    public static final String JSON_PROPERTY_THREE_D_S_REQUESTOR_AUTHENTICATION_INFO = "threeDSRequestorAuthenticationInfo";
    private ThreeDSRequestorAuthenticationInfo threeDSRequestorAuthenticationInfo;
    public static final String JSON_PROPERTY_THREE_D_S_REQUESTOR_CHALLENGE_IND = "threeDSRequestorChallengeInd";
    private ThreeDSRequestorChallengeIndEnum threeDSRequestorChallengeInd;
    public static final String JSON_PROPERTY_THREE_D_S_REQUESTOR_I_D = "threeDSRequestorID";
    private String threeDSRequestorID;
    public static final String JSON_PROPERTY_THREE_D_S_REQUESTOR_NAME = "threeDSRequestorName";
    private String threeDSRequestorName;
    public static final String JSON_PROPERTY_THREE_D_S_REQUESTOR_PRIOR_AUTHENTICATION_INFO = "threeDSRequestorPriorAuthenticationInfo";
    private ThreeDSRequestorPriorAuthenticationInfo threeDSRequestorPriorAuthenticationInfo;
    public static final String JSON_PROPERTY_THREE_D_S_REQUESTOR_U_R_L = "threeDSRequestorURL";
    private String threeDSRequestorURL;
    public static final String JSON_PROPERTY_TRANS_TYPE = "transType";
    private TransTypeEnum transType;
    public static final String JSON_PROPERTY_TRANSACTION_TYPE = "transactionType";
    private TransactionTypeEnum transactionType;
    public static final String JSON_PROPERTY_WHITE_LIST_STATUS = "whiteListStatus";
    private String whiteListStatus;
    public static final String JSON_PROPERTY_WORK_PHONE = "workPhone";
    private Phone workPhone;

    public ThreeDS2RequestData acctInfo(AcctInfo acctInfo) {
        this.acctInfo = acctInfo;
        return this;
    }

    @ApiModelProperty(value="")
    @JsonProperty(value="acctInfo")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public AcctInfo getAcctInfo() {
        return this.acctInfo;
    }

    @JsonProperty(value="acctInfo")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAcctInfo(AcctInfo acctInfo) {
        this.acctInfo = acctInfo;
    }

    public ThreeDS2RequestData acctType(AcctTypeEnum acctType) {
        this.acctType = acctType;
        return this;
    }

    @ApiModelProperty(value="Indicates the type of account. For example, for a multi-account card product. Length: 2 characters. Allowed values: * **01** \u2014 Not applicable * **02** \u2014 Credit * **03** \u2014 Debit")
    @JsonProperty(value="acctType")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public AcctTypeEnum getAcctType() {
        return this.acctType;
    }

    @JsonProperty(value="acctType")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAcctType(AcctTypeEnum acctType) {
        this.acctType = acctType;
    }

    public ThreeDS2RequestData acquirerBIN(String acquirerBIN) {
        this.acquirerBIN = acquirerBIN;
        return this;
    }

    @ApiModelProperty(value="Required for [authentication-only integration](https://docs.adyen.com/online-payments/3d-secure/other-3ds-flows/authentication-only). The acquiring BIN enrolled for 3D Secure 2. This string should match the value that you will use in the authorisation. Use 123456 on the Test platform.")
    @JsonProperty(value="acquirerBIN")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getAcquirerBIN() {
        return this.acquirerBIN;
    }

    @JsonProperty(value="acquirerBIN")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAcquirerBIN(String acquirerBIN) {
        this.acquirerBIN = acquirerBIN;
    }

    public ThreeDS2RequestData acquirerMerchantID(String acquirerMerchantID) {
        this.acquirerMerchantID = acquirerMerchantID;
        return this;
    }

    @ApiModelProperty(value="Required for [authentication-only integration](https://docs.adyen.com/online-payments/3d-secure/other-3ds-flows/authentication-only). The merchantId that is enrolled for 3D Secure 2 by the merchant's acquirer. This string should match the value that you will use in the authorisation. Use 123456 on the Test platform.")
    @JsonProperty(value="acquirerMerchantID")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getAcquirerMerchantID() {
        return this.acquirerMerchantID;
    }

    @JsonProperty(value="acquirerMerchantID")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAcquirerMerchantID(String acquirerMerchantID) {
        this.acquirerMerchantID = acquirerMerchantID;
    }

    public ThreeDS2RequestData addrMatch(AddrMatchEnum addrMatch) {
        this.addrMatch = addrMatch;
        return this;
    }

    @ApiModelProperty(value="Indicates whether the Cardholder Shipping Address and Cardholder Billing Address are the same. Allowed values: * **Y** \u2014 Shipping Address matches Billing Address. * **N** \u2014 Shipping Address does not match Billing Address.")
    @JsonProperty(value="addrMatch")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public AddrMatchEnum getAddrMatch() {
        return this.addrMatch;
    }

    @JsonProperty(value="addrMatch")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAddrMatch(AddrMatchEnum addrMatch) {
        this.addrMatch = addrMatch;
    }

    public ThreeDS2RequestData authenticationOnly(Boolean authenticationOnly) {
        this.authenticationOnly = authenticationOnly;
        return this;
    }

    @Deprecated
    @ApiModelProperty(value="If set to true, you will only perform the [3D Secure 2 authentication](https://docs.adyen.com/online-payments/3d-secure/other-3ds-flows/authentication-only), and not the payment authorisation.")
    @JsonProperty(value="authenticationOnly")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getAuthenticationOnly() {
        return this.authenticationOnly;
    }

    @Deprecated
    @JsonProperty(value="authenticationOnly")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAuthenticationOnly(Boolean authenticationOnly) {
        this.authenticationOnly = authenticationOnly;
    }

    public ThreeDS2RequestData challengeIndicator(ChallengeIndicatorEnum challengeIndicator) {
        this.challengeIndicator = challengeIndicator;
        return this;
    }

    @Deprecated
    @ApiModelProperty(value="Possibility to specify a preference for receiving a challenge from the issuer. Allowed values: * `noPreference` * `requestNoChallenge` * `requestChallenge` * `requestChallengeAsMandate` ")
    @JsonProperty(value="challengeIndicator")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public ChallengeIndicatorEnum getChallengeIndicator() {
        return this.challengeIndicator;
    }

    @Deprecated
    @JsonProperty(value="challengeIndicator")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setChallengeIndicator(ChallengeIndicatorEnum challengeIndicator) {
        this.challengeIndicator = challengeIndicator;
    }

    public ThreeDS2RequestData deviceChannel(String deviceChannel) {
        this.deviceChannel = deviceChannel;
        return this;
    }

    @ApiModelProperty(required=true, value="The environment of the shopper. Allowed values: * `app` * `browser`")
    @JsonProperty(value="deviceChannel")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getDeviceChannel() {
        return this.deviceChannel;
    }

    @JsonProperty(value="deviceChannel")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDeviceChannel(String deviceChannel) {
        this.deviceChannel = deviceChannel;
    }

    public ThreeDS2RequestData deviceRenderOptions(DeviceRenderOptions deviceRenderOptions) {
        this.deviceRenderOptions = deviceRenderOptions;
        return this;
    }

    @ApiModelProperty(value="")
    @JsonProperty(value="deviceRenderOptions")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public DeviceRenderOptions getDeviceRenderOptions() {
        return this.deviceRenderOptions;
    }

    @JsonProperty(value="deviceRenderOptions")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDeviceRenderOptions(DeviceRenderOptions deviceRenderOptions) {
        this.deviceRenderOptions = deviceRenderOptions;
    }

    public ThreeDS2RequestData homePhone(Phone homePhone) {
        this.homePhone = homePhone;
        return this;
    }

    @ApiModelProperty(value="")
    @JsonProperty(value="homePhone")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Phone getHomePhone() {
        return this.homePhone;
    }

    @JsonProperty(value="homePhone")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setHomePhone(Phone homePhone) {
        this.homePhone = homePhone;
    }

    public ThreeDS2RequestData mcc(String mcc) {
        this.mcc = mcc;
        return this;
    }

    @ApiModelProperty(value="Required for merchants that have been enrolled for 3D Secure 2 by another party than Adyen, mostly [authentication-only integrations](https://docs.adyen.com/online-payments/3d-secure/other-3ds-flows/authentication-only). The `mcc` is a four-digit code with which the previously given `acquirerMerchantID` is registered at the scheme.")
    @JsonProperty(value="mcc")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getMcc() {
        return this.mcc;
    }

    @JsonProperty(value="mcc")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setMcc(String mcc) {
        this.mcc = mcc;
    }

    public ThreeDS2RequestData merchantName(String merchantName) {
        this.merchantName = merchantName;
        return this;
    }

    @ApiModelProperty(value="Required for [authentication-only integration](https://docs.adyen.com/online-payments/3d-secure/other-3ds-flows/authentication-only). The merchant name that the issuer presents to the shopper if they get a challenge. We recommend to use the same value that you will use in the authorization. Maximum length is 40 characters. > Optional for a [full 3D Secure 2 integration](https://docs.adyen.com/online-payments/3d-secure/native-3ds2/api-integration). Use this field if you are enrolled for 3D Secure 2 with us and want to override the merchant name already configured on your account.")
    @JsonProperty(value="merchantName")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getMerchantName() {
        return this.merchantName;
    }

    @JsonProperty(value="merchantName")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setMerchantName(String merchantName) {
        this.merchantName = merchantName;
    }

    public ThreeDS2RequestData messageVersion(String messageVersion) {
        this.messageVersion = messageVersion;
        return this;
    }

    @ApiModelProperty(value="The `messageVersion` value indicating the 3D Secure 2 protocol version.")
    @JsonProperty(value="messageVersion")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getMessageVersion() {
        return this.messageVersion;
    }

    @JsonProperty(value="messageVersion")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setMessageVersion(String messageVersion) {
        this.messageVersion = messageVersion;
    }

    public ThreeDS2RequestData mobilePhone(Phone mobilePhone) {
        this.mobilePhone = mobilePhone;
        return this;
    }

    @ApiModelProperty(value="")
    @JsonProperty(value="mobilePhone")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Phone getMobilePhone() {
        return this.mobilePhone;
    }

    @JsonProperty(value="mobilePhone")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setMobilePhone(Phone mobilePhone) {
        this.mobilePhone = mobilePhone;
    }

    public ThreeDS2RequestData notificationURL(String notificationURL) {
        this.notificationURL = notificationURL;
        return this;
    }

    @ApiModelProperty(value="URL to where the issuer should send the `CRes`. Required if you are not using components for `channel` **Web** or if you are using classic integration `deviceChannel` **browser**.")
    @JsonProperty(value="notificationURL")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getNotificationURL() {
        return this.notificationURL;
    }

    @JsonProperty(value="notificationURL")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setNotificationURL(String notificationURL) {
        this.notificationURL = notificationURL;
    }

    public ThreeDS2RequestData payTokenInd(Boolean payTokenInd) {
        this.payTokenInd = payTokenInd;
        return this;
    }

    @ApiModelProperty(value="Value **true** indicates that the transaction was de-tokenised prior to being received by the ACS.")
    @JsonProperty(value="payTokenInd")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getPayTokenInd() {
        return this.payTokenInd;
    }

    @JsonProperty(value="payTokenInd")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPayTokenInd(Boolean payTokenInd) {
        this.payTokenInd = payTokenInd;
    }

    public ThreeDS2RequestData paymentAuthenticationUseCase(String paymentAuthenticationUseCase) {
        this.paymentAuthenticationUseCase = paymentAuthenticationUseCase;
        return this;
    }

    @ApiModelProperty(value="Indicates the type of payment for which an authentication is requested (message extension)")
    @JsonProperty(value="paymentAuthenticationUseCase")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getPaymentAuthenticationUseCase() {
        return this.paymentAuthenticationUseCase;
    }

    @JsonProperty(value="paymentAuthenticationUseCase")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPaymentAuthenticationUseCase(String paymentAuthenticationUseCase) {
        this.paymentAuthenticationUseCase = paymentAuthenticationUseCase;
    }

    public ThreeDS2RequestData purchaseInstalData(String purchaseInstalData) {
        this.purchaseInstalData = purchaseInstalData;
        return this;
    }

    @ApiModelProperty(value="Indicates the maximum number of authorisations permitted for instalment payments. Length: 1\u20133 characters.")
    @JsonProperty(value="purchaseInstalData")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getPurchaseInstalData() {
        return this.purchaseInstalData;
    }

    @JsonProperty(value="purchaseInstalData")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPurchaseInstalData(String purchaseInstalData) {
        this.purchaseInstalData = purchaseInstalData;
    }

    public ThreeDS2RequestData recurringExpiry(String recurringExpiry) {
        this.recurringExpiry = recurringExpiry;
        return this;
    }

    @ApiModelProperty(value="Date after which no further authorisations shall be performed. Format: YYYYMMDD")
    @JsonProperty(value="recurringExpiry")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getRecurringExpiry() {
        return this.recurringExpiry;
    }

    @JsonProperty(value="recurringExpiry")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setRecurringExpiry(String recurringExpiry) {
        this.recurringExpiry = recurringExpiry;
    }

    public ThreeDS2RequestData recurringFrequency(String recurringFrequency) {
        this.recurringFrequency = recurringFrequency;
        return this;
    }

    @ApiModelProperty(value="Indicates the minimum number of days between authorisations. Maximum length: 4 characters.")
    @JsonProperty(value="recurringFrequency")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getRecurringFrequency() {
        return this.recurringFrequency;
    }

    @JsonProperty(value="recurringFrequency")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setRecurringFrequency(String recurringFrequency) {
        this.recurringFrequency = recurringFrequency;
    }

    public ThreeDS2RequestData sdkAppID(String sdkAppID) {
        this.sdkAppID = sdkAppID;
        return this;
    }

    @ApiModelProperty(value="The `sdkAppID` value as received from the 3D Secure 2 SDK. Required for `deviceChannel` set to **app**.")
    @JsonProperty(value="sdkAppID")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getSdkAppID() {
        return this.sdkAppID;
    }

    @JsonProperty(value="sdkAppID")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSdkAppID(String sdkAppID) {
        this.sdkAppID = sdkAppID;
    }

    public ThreeDS2RequestData sdkEncData(String sdkEncData) {
        this.sdkEncData = sdkEncData;
        return this;
    }

    @ApiModelProperty(value="The `sdkEncData` value as received from the 3D Secure 2 SDK. Required for `deviceChannel` set to **app**.")
    @JsonProperty(value="sdkEncData")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getSdkEncData() {
        return this.sdkEncData;
    }

    @JsonProperty(value="sdkEncData")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSdkEncData(String sdkEncData) {
        this.sdkEncData = sdkEncData;
    }

    public ThreeDS2RequestData sdkEphemPubKey(SDKEphemPubKey sdkEphemPubKey) {
        this.sdkEphemPubKey = sdkEphemPubKey;
        return this;
    }

    @ApiModelProperty(value="")
    @JsonProperty(value="sdkEphemPubKey")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public SDKEphemPubKey getSdkEphemPubKey() {
        return this.sdkEphemPubKey;
    }

    @JsonProperty(value="sdkEphemPubKey")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSdkEphemPubKey(SDKEphemPubKey sdkEphemPubKey) {
        this.sdkEphemPubKey = sdkEphemPubKey;
    }

    public ThreeDS2RequestData sdkMaxTimeout(Integer sdkMaxTimeout) {
        this.sdkMaxTimeout = sdkMaxTimeout;
        return this;
    }

    @ApiModelProperty(value="The maximum amount of time in minutes for the 3D Secure 2 authentication process. Optional and only for `deviceChannel` set to **app**. Defaults to **60** minutes.")
    @JsonProperty(value="sdkMaxTimeout")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getSdkMaxTimeout() {
        return this.sdkMaxTimeout;
    }

    @JsonProperty(value="sdkMaxTimeout")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSdkMaxTimeout(Integer sdkMaxTimeout) {
        this.sdkMaxTimeout = sdkMaxTimeout;
    }

    public ThreeDS2RequestData sdkReferenceNumber(String sdkReferenceNumber) {
        this.sdkReferenceNumber = sdkReferenceNumber;
        return this;
    }

    @ApiModelProperty(value="The `sdkReferenceNumber` value as received from the 3D Secure 2 SDK. Only for `deviceChannel` set to **app**.")
    @JsonProperty(value="sdkReferenceNumber")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getSdkReferenceNumber() {
        return this.sdkReferenceNumber;
    }

    @JsonProperty(value="sdkReferenceNumber")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSdkReferenceNumber(String sdkReferenceNumber) {
        this.sdkReferenceNumber = sdkReferenceNumber;
    }

    public ThreeDS2RequestData sdkTransID(String sdkTransID) {
        this.sdkTransID = sdkTransID;
        return this;
    }

    @ApiModelProperty(value="The `sdkTransID` value as received from the 3D Secure 2 SDK. Only for `deviceChannel` set to **app**.")
    @JsonProperty(value="sdkTransID")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getSdkTransID() {
        return this.sdkTransID;
    }

    @JsonProperty(value="sdkTransID")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSdkTransID(String sdkTransID) {
        this.sdkTransID = sdkTransID;
    }

    public ThreeDS2RequestData sdkVersion(String sdkVersion) {
        this.sdkVersion = sdkVersion;
        return this;
    }

    @ApiModelProperty(value="Version of the 3D Secure 2 mobile SDK.  Only for `deviceChannel` set to **app**.")
    @JsonProperty(value="sdkVersion")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getSdkVersion() {
        return this.sdkVersion;
    }

    @JsonProperty(value="sdkVersion")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSdkVersion(String sdkVersion) {
        this.sdkVersion = sdkVersion;
    }

    public ThreeDS2RequestData threeDSCompInd(String threeDSCompInd) {
        this.threeDSCompInd = threeDSCompInd;
        return this;
    }

    @ApiModelProperty(value="Completion indicator for the device fingerprinting.")
    @JsonProperty(value="threeDSCompInd")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getThreeDSCompInd() {
        return this.threeDSCompInd;
    }

    @JsonProperty(value="threeDSCompInd")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setThreeDSCompInd(String threeDSCompInd) {
        this.threeDSCompInd = threeDSCompInd;
    }

    public ThreeDS2RequestData threeDSRequestorAuthenticationInd(String threeDSRequestorAuthenticationInd) {
        this.threeDSRequestorAuthenticationInd = threeDSRequestorAuthenticationInd;
        return this;
    }

    @ApiModelProperty(value="Indicates the type of Authentication request.")
    @JsonProperty(value="threeDSRequestorAuthenticationInd")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getThreeDSRequestorAuthenticationInd() {
        return this.threeDSRequestorAuthenticationInd;
    }

    @JsonProperty(value="threeDSRequestorAuthenticationInd")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setThreeDSRequestorAuthenticationInd(String threeDSRequestorAuthenticationInd) {
        this.threeDSRequestorAuthenticationInd = threeDSRequestorAuthenticationInd;
    }

    public ThreeDS2RequestData threeDSRequestorAuthenticationInfo(ThreeDSRequestorAuthenticationInfo threeDSRequestorAuthenticationInfo) {
        this.threeDSRequestorAuthenticationInfo = threeDSRequestorAuthenticationInfo;
        return this;
    }

    @ApiModelProperty(value="")
    @JsonProperty(value="threeDSRequestorAuthenticationInfo")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public ThreeDSRequestorAuthenticationInfo getThreeDSRequestorAuthenticationInfo() {
        return this.threeDSRequestorAuthenticationInfo;
    }

    @JsonProperty(value="threeDSRequestorAuthenticationInfo")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setThreeDSRequestorAuthenticationInfo(ThreeDSRequestorAuthenticationInfo threeDSRequestorAuthenticationInfo) {
        this.threeDSRequestorAuthenticationInfo = threeDSRequestorAuthenticationInfo;
    }

    public ThreeDS2RequestData threeDSRequestorChallengeInd(ThreeDSRequestorChallengeIndEnum threeDSRequestorChallengeInd) {
        this.threeDSRequestorChallengeInd = threeDSRequestorChallengeInd;
        return this;
    }

    @ApiModelProperty(value="Indicates whether a challenge is requested for this transaction. Possible values: * **01** \u2014 No preference * **02** \u2014 No challenge requested * **03** \u2014 Challenge requested (3DS Requestor preference) * **04** \u2014 Challenge requested (Mandate) * **05** \u2014 No challenge (transactional risk analysis is already performed) * **06** \u2014 Data Only")
    @JsonProperty(value="threeDSRequestorChallengeInd")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public ThreeDSRequestorChallengeIndEnum getThreeDSRequestorChallengeInd() {
        return this.threeDSRequestorChallengeInd;
    }

    @JsonProperty(value="threeDSRequestorChallengeInd")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setThreeDSRequestorChallengeInd(ThreeDSRequestorChallengeIndEnum threeDSRequestorChallengeInd) {
        this.threeDSRequestorChallengeInd = threeDSRequestorChallengeInd;
    }

    public ThreeDS2RequestData threeDSRequestorID(String threeDSRequestorID) {
        this.threeDSRequestorID = threeDSRequestorID;
        return this;
    }

    @ApiModelProperty(value="Required for [authentication-only integration](https://docs.adyen.com/online-payments/3d-secure/other-3ds-flows/authentication-only) for Visa. Unique 3D Secure requestor identifier assigned by the Directory Server when you enrol for 3D Secure 2.")
    @JsonProperty(value="threeDSRequestorID")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getThreeDSRequestorID() {
        return this.threeDSRequestorID;
    }

    @JsonProperty(value="threeDSRequestorID")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setThreeDSRequestorID(String threeDSRequestorID) {
        this.threeDSRequestorID = threeDSRequestorID;
    }

    public ThreeDS2RequestData threeDSRequestorName(String threeDSRequestorName) {
        this.threeDSRequestorName = threeDSRequestorName;
        return this;
    }

    @ApiModelProperty(value="Required for [authentication-only integration](https://docs.adyen.com/online-payments/3d-secure/other-3ds-flows/authentication-only) for Visa. Unique 3D Secure requestor name assigned by the Directory Server when you enrol for 3D Secure 2.")
    @JsonProperty(value="threeDSRequestorName")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getThreeDSRequestorName() {
        return this.threeDSRequestorName;
    }

    @JsonProperty(value="threeDSRequestorName")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setThreeDSRequestorName(String threeDSRequestorName) {
        this.threeDSRequestorName = threeDSRequestorName;
    }

    public ThreeDS2RequestData threeDSRequestorPriorAuthenticationInfo(ThreeDSRequestorPriorAuthenticationInfo threeDSRequestorPriorAuthenticationInfo) {
        this.threeDSRequestorPriorAuthenticationInfo = threeDSRequestorPriorAuthenticationInfo;
        return this;
    }

    @ApiModelProperty(value="")
    @JsonProperty(value="threeDSRequestorPriorAuthenticationInfo")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public ThreeDSRequestorPriorAuthenticationInfo getThreeDSRequestorPriorAuthenticationInfo() {
        return this.threeDSRequestorPriorAuthenticationInfo;
    }

    @JsonProperty(value="threeDSRequestorPriorAuthenticationInfo")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setThreeDSRequestorPriorAuthenticationInfo(ThreeDSRequestorPriorAuthenticationInfo threeDSRequestorPriorAuthenticationInfo) {
        this.threeDSRequestorPriorAuthenticationInfo = threeDSRequestorPriorAuthenticationInfo;
    }

    public ThreeDS2RequestData threeDSRequestorURL(String threeDSRequestorURL) {
        this.threeDSRequestorURL = threeDSRequestorURL;
        return this;
    }

    @ApiModelProperty(value="URL of the (customer service) website that will be shown to the shopper in case of technical errors during the 3D Secure 2 process.")
    @JsonProperty(value="threeDSRequestorURL")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getThreeDSRequestorURL() {
        return this.threeDSRequestorURL;
    }

    @JsonProperty(value="threeDSRequestorURL")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setThreeDSRequestorURL(String threeDSRequestorURL) {
        this.threeDSRequestorURL = threeDSRequestorURL;
    }

    public ThreeDS2RequestData transType(TransTypeEnum transType) {
        this.transType = transType;
        return this;
    }

    @ApiModelProperty(value="Identifies the type of transaction being authenticated. Length: 2 characters. Allowed values: * **01** \u2014 Goods/Service Purchase * **03** \u2014 Check Acceptance * **10** \u2014 Account Funding * **11** \u2014 Quasi-Cash Transaction * **28** \u2014 Prepaid Activation and Load")
    @JsonProperty(value="transType")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public TransTypeEnum getTransType() {
        return this.transType;
    }

    @JsonProperty(value="transType")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setTransType(TransTypeEnum transType) {
        this.transType = transType;
    }

    public ThreeDS2RequestData transactionType(TransactionTypeEnum transactionType) {
        this.transactionType = transactionType;
        return this;
    }

    @ApiModelProperty(value="Identify the type of the transaction being authenticated.")
    @JsonProperty(value="transactionType")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public TransactionTypeEnum getTransactionType() {
        return this.transactionType;
    }

    @JsonProperty(value="transactionType")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setTransactionType(TransactionTypeEnum transactionType) {
        this.transactionType = transactionType;
    }

    public ThreeDS2RequestData whiteListStatus(String whiteListStatus) {
        this.whiteListStatus = whiteListStatus;
        return this;
    }

    @ApiModelProperty(value="The `whiteListStatus` value returned from a previous 3D Secure 2 transaction, only applicable for 3D Secure 2 protocol version 2.2.0.")
    @JsonProperty(value="whiteListStatus")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getWhiteListStatus() {
        return this.whiteListStatus;
    }

    @JsonProperty(value="whiteListStatus")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setWhiteListStatus(String whiteListStatus) {
        this.whiteListStatus = whiteListStatus;
    }

    public ThreeDS2RequestData workPhone(Phone workPhone) {
        this.workPhone = workPhone;
        return this;
    }

    @ApiModelProperty(value="")
    @JsonProperty(value="workPhone")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Phone getWorkPhone() {
        return this.workPhone;
    }

    @JsonProperty(value="workPhone")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setWorkPhone(Phone workPhone) {
        this.workPhone = workPhone;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ThreeDS2RequestData threeDS2RequestData = (ThreeDS2RequestData)o;
        return Objects.equals(this.acctInfo, threeDS2RequestData.acctInfo) && Objects.equals((Object)this.acctType, (Object)threeDS2RequestData.acctType) && Objects.equals(this.acquirerBIN, threeDS2RequestData.acquirerBIN) && Objects.equals(this.acquirerMerchantID, threeDS2RequestData.acquirerMerchantID) && Objects.equals((Object)this.addrMatch, (Object)threeDS2RequestData.addrMatch) && Objects.equals(this.authenticationOnly, threeDS2RequestData.authenticationOnly) && Objects.equals((Object)this.challengeIndicator, (Object)threeDS2RequestData.challengeIndicator) && Objects.equals(this.deviceChannel, threeDS2RequestData.deviceChannel) && Objects.equals(this.deviceRenderOptions, threeDS2RequestData.deviceRenderOptions) && Objects.equals(this.homePhone, threeDS2RequestData.homePhone) && Objects.equals(this.mcc, threeDS2RequestData.mcc) && Objects.equals(this.merchantName, threeDS2RequestData.merchantName) && Objects.equals(this.messageVersion, threeDS2RequestData.messageVersion) && Objects.equals(this.mobilePhone, threeDS2RequestData.mobilePhone) && Objects.equals(this.notificationURL, threeDS2RequestData.notificationURL) && Objects.equals(this.payTokenInd, threeDS2RequestData.payTokenInd) && Objects.equals(this.paymentAuthenticationUseCase, threeDS2RequestData.paymentAuthenticationUseCase) && Objects.equals(this.purchaseInstalData, threeDS2RequestData.purchaseInstalData) && Objects.equals(this.recurringExpiry, threeDS2RequestData.recurringExpiry) && Objects.equals(this.recurringFrequency, threeDS2RequestData.recurringFrequency) && Objects.equals(this.sdkAppID, threeDS2RequestData.sdkAppID) && Objects.equals(this.sdkEncData, threeDS2RequestData.sdkEncData) && Objects.equals(this.sdkEphemPubKey, threeDS2RequestData.sdkEphemPubKey) && Objects.equals(this.sdkMaxTimeout, threeDS2RequestData.sdkMaxTimeout) && Objects.equals(this.sdkReferenceNumber, threeDS2RequestData.sdkReferenceNumber) && Objects.equals(this.sdkTransID, threeDS2RequestData.sdkTransID) && Objects.equals(this.sdkVersion, threeDS2RequestData.sdkVersion) && Objects.equals(this.threeDSCompInd, threeDS2RequestData.threeDSCompInd) && Objects.equals(this.threeDSRequestorAuthenticationInd, threeDS2RequestData.threeDSRequestorAuthenticationInd) && Objects.equals(this.threeDSRequestorAuthenticationInfo, threeDS2RequestData.threeDSRequestorAuthenticationInfo) && Objects.equals((Object)this.threeDSRequestorChallengeInd, (Object)threeDS2RequestData.threeDSRequestorChallengeInd) && Objects.equals(this.threeDSRequestorID, threeDS2RequestData.threeDSRequestorID) && Objects.equals(this.threeDSRequestorName, threeDS2RequestData.threeDSRequestorName) && Objects.equals(this.threeDSRequestorPriorAuthenticationInfo, threeDS2RequestData.threeDSRequestorPriorAuthenticationInfo) && Objects.equals(this.threeDSRequestorURL, threeDS2RequestData.threeDSRequestorURL) && Objects.equals((Object)this.transType, (Object)threeDS2RequestData.transType) && Objects.equals((Object)this.transactionType, (Object)threeDS2RequestData.transactionType) && Objects.equals(this.whiteListStatus, threeDS2RequestData.whiteListStatus) && Objects.equals(this.workPhone, threeDS2RequestData.workPhone);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.acctInfo, this.acctType, this.acquirerBIN, this.acquirerMerchantID, this.addrMatch, this.authenticationOnly, this.challengeIndicator, this.deviceChannel, this.deviceRenderOptions, this.homePhone, this.mcc, this.merchantName, this.messageVersion, this.mobilePhone, this.notificationURL, this.payTokenInd, this.paymentAuthenticationUseCase, this.purchaseInstalData, this.recurringExpiry, this.recurringFrequency, this.sdkAppID, this.sdkEncData, this.sdkEphemPubKey, this.sdkMaxTimeout, this.sdkReferenceNumber, this.sdkTransID, this.sdkVersion, this.threeDSCompInd, this.threeDSRequestorAuthenticationInd, this.threeDSRequestorAuthenticationInfo, this.threeDSRequestorChallengeInd, this.threeDSRequestorID, this.threeDSRequestorName, this.threeDSRequestorPriorAuthenticationInfo, this.threeDSRequestorURL, this.transType, this.transactionType, this.whiteListStatus, this.workPhone});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ThreeDS2RequestData {\n");
        sb.append("    acctInfo: ").append(this.toIndentedString(this.acctInfo)).append("\n");
        sb.append("    acctType: ").append(this.toIndentedString((Object)this.acctType)).append("\n");
        sb.append("    acquirerBIN: ").append(this.toIndentedString(this.acquirerBIN)).append("\n");
        sb.append("    acquirerMerchantID: ").append(this.toIndentedString(this.acquirerMerchantID)).append("\n");
        sb.append("    addrMatch: ").append(this.toIndentedString((Object)this.addrMatch)).append("\n");
        sb.append("    authenticationOnly: ").append(this.toIndentedString(this.authenticationOnly)).append("\n");
        sb.append("    challengeIndicator: ").append(this.toIndentedString((Object)this.challengeIndicator)).append("\n");
        sb.append("    deviceChannel: ").append(this.toIndentedString(this.deviceChannel)).append("\n");
        sb.append("    deviceRenderOptions: ").append(this.toIndentedString(this.deviceRenderOptions)).append("\n");
        sb.append("    homePhone: ").append(this.toIndentedString(this.homePhone)).append("\n");
        sb.append("    mcc: ").append(this.toIndentedString(this.mcc)).append("\n");
        sb.append("    merchantName: ").append(this.toIndentedString(this.merchantName)).append("\n");
        sb.append("    messageVersion: ").append(this.toIndentedString(this.messageVersion)).append("\n");
        sb.append("    mobilePhone: ").append(this.toIndentedString(this.mobilePhone)).append("\n");
        sb.append("    notificationURL: ").append(this.toIndentedString(this.notificationURL)).append("\n");
        sb.append("    payTokenInd: ").append(this.toIndentedString(this.payTokenInd)).append("\n");
        sb.append("    paymentAuthenticationUseCase: ").append(this.toIndentedString(this.paymentAuthenticationUseCase)).append("\n");
        sb.append("    purchaseInstalData: ").append(this.toIndentedString(this.purchaseInstalData)).append("\n");
        sb.append("    recurringExpiry: ").append(this.toIndentedString(this.recurringExpiry)).append("\n");
        sb.append("    recurringFrequency: ").append(this.toIndentedString(this.recurringFrequency)).append("\n");
        sb.append("    sdkAppID: ").append(this.toIndentedString(this.sdkAppID)).append("\n");
        sb.append("    sdkEncData: ").append(this.toIndentedString(this.sdkEncData)).append("\n");
        sb.append("    sdkEphemPubKey: ").append(this.toIndentedString(this.sdkEphemPubKey)).append("\n");
        sb.append("    sdkMaxTimeout: ").append(this.toIndentedString(this.sdkMaxTimeout)).append("\n");
        sb.append("    sdkReferenceNumber: ").append(this.toIndentedString(this.sdkReferenceNumber)).append("\n");
        sb.append("    sdkTransID: ").append(this.toIndentedString(this.sdkTransID)).append("\n");
        sb.append("    sdkVersion: ").append(this.toIndentedString(this.sdkVersion)).append("\n");
        sb.append("    threeDSCompInd: ").append(this.toIndentedString(this.threeDSCompInd)).append("\n");
        sb.append("    threeDSRequestorAuthenticationInd: ").append(this.toIndentedString(this.threeDSRequestorAuthenticationInd)).append("\n");
        sb.append("    threeDSRequestorAuthenticationInfo: ").append(this.toIndentedString(this.threeDSRequestorAuthenticationInfo)).append("\n");
        sb.append("    threeDSRequestorChallengeInd: ").append(this.toIndentedString((Object)this.threeDSRequestorChallengeInd)).append("\n");
        sb.append("    threeDSRequestorID: ").append(this.toIndentedString(this.threeDSRequestorID)).append("\n");
        sb.append("    threeDSRequestorName: ").append(this.toIndentedString(this.threeDSRequestorName)).append("\n");
        sb.append("    threeDSRequestorPriorAuthenticationInfo: ").append(this.toIndentedString(this.threeDSRequestorPriorAuthenticationInfo)).append("\n");
        sb.append("    threeDSRequestorURL: ").append(this.toIndentedString(this.threeDSRequestorURL)).append("\n");
        sb.append("    transType: ").append(this.toIndentedString((Object)this.transType)).append("\n");
        sb.append("    transactionType: ").append(this.toIndentedString((Object)this.transactionType)).append("\n");
        sb.append("    whiteListStatus: ").append(this.toIndentedString(this.whiteListStatus)).append("\n");
        sb.append("    workPhone: ").append(this.toIndentedString(this.workPhone)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static ThreeDS2RequestData fromJson(String jsonString) throws JsonProcessingException {
        return (ThreeDS2RequestData)JSON.getMapper().readValue(jsonString, ThreeDS2RequestData.class);
    }

    public String toJson() throws JsonProcessingException {
        return JSON.getMapper().writeValueAsString((Object)this);
    }

    public static enum TransactionTypeEnum {
        GOODSORSERVICEPURCHASE("goodsOrServicePurchase"),
        CHECKACCEPTANCE("checkAcceptance"),
        ACCOUNTFUNDING("accountFunding"),
        QUASICASHTRANSACTION("quasiCashTransaction"),
        PREPAIDACTIVATIONANDLOAD("prepaidActivationAndLoad");

        private String value;

        private TransactionTypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static TransactionTypeEnum fromValue(String value) {
            for (TransactionTypeEnum b : TransactionTypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }

    public static enum TransTypeEnum {
        _01("01"),
        _03("03"),
        _10("10"),
        _11("11"),
        _28("28");

        private String value;

        private TransTypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static TransTypeEnum fromValue(String value) {
            for (TransTypeEnum b : TransTypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }

    public static enum ThreeDSRequestorChallengeIndEnum {
        _01("01"),
        _02("02"),
        _03("03"),
        _04("04"),
        _05("05"),
        _06("06");

        private String value;

        private ThreeDSRequestorChallengeIndEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static ThreeDSRequestorChallengeIndEnum fromValue(String value) {
            for (ThreeDSRequestorChallengeIndEnum b : ThreeDSRequestorChallengeIndEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }

    public static enum ChallengeIndicatorEnum {
        NOPREFERENCE("noPreference"),
        REQUESTNOCHALLENGE("requestNoChallenge"),
        REQUESTCHALLENGE("requestChallenge"),
        REQUESTCHALLENGEASMANDATE("requestChallengeAsMandate");

        private String value;

        private ChallengeIndicatorEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static ChallengeIndicatorEnum fromValue(String value) {
            for (ChallengeIndicatorEnum b : ChallengeIndicatorEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }

    public static enum AddrMatchEnum {
        Y("Y"),
        N("N");

        private String value;

        private AddrMatchEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static AddrMatchEnum fromValue(String value) {
            for (AddrMatchEnum b : AddrMatchEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }

    public static enum AcctTypeEnum {
        _01("01"),
        _02("02"),
        _03("03");

        private String value;

        private AcctTypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static AcctTypeEnum fromValue(String value) {
            for (AcctTypeEnum b : AcctTypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

