/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.management;

import com.adyen.model.management.JSON;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonProcessingException;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@JsonPropertyOrder(value={"iccid", "status"})
public class TerminalConnectivityCellular {
    public static final String JSON_PROPERTY_ICCID = "iccid";
    private String iccid;
    public static final String JSON_PROPERTY_STATUS = "status";
    private StatusEnum status;

    public TerminalConnectivityCellular iccid(String iccid) {
        this.iccid = iccid;
        return this;
    }

    @ApiModelProperty(value="The integrated circuit card identifier (ICCID) of the SIM card in the terminal.")
    @JsonProperty(value="iccid")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getIccid() {
        return this.iccid;
    }

    @JsonProperty(value="iccid")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setIccid(String iccid) {
        this.iccid = iccid;
    }

    public TerminalConnectivityCellular status(StatusEnum status) {
        this.status = status;
        return this;
    }

    @ApiModelProperty(value="On a terminal that supports 3G or 4G connectivity, indicates the status of the SIM card in the terminal.")
    @JsonProperty(value="status")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public StatusEnum getStatus() {
        return this.status;
    }

    @JsonProperty(value="status")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setStatus(StatusEnum status) {
        this.status = status;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TerminalConnectivityCellular terminalConnectivityCellular = (TerminalConnectivityCellular)o;
        return Objects.equals(this.iccid, terminalConnectivityCellular.iccid) && Objects.equals((Object)this.status, (Object)terminalConnectivityCellular.status);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.iccid, this.status});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class TerminalConnectivityCellular {\n");
        sb.append("    iccid: ").append(this.toIndentedString(this.iccid)).append("\n");
        sb.append("    status: ").append(this.toIndentedString((Object)this.status)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static TerminalConnectivityCellular fromJson(String jsonString) throws JsonProcessingException {
        return (TerminalConnectivityCellular)JSON.getMapper().readValue(jsonString, TerminalConnectivityCellular.class);
    }

    public String toJson() throws JsonProcessingException {
        return JSON.getMapper().writeValueAsString((Object)this);
    }

    public static enum StatusEnum {
        ACTIVATED("activated"),
        DEACTIVATED("deactivated"),
        DEPRECATED("deprecated"),
        INVENTORY("inventory"),
        READYFORACTIVATION("readyForActivation");

        private String value;

        private StatusEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static StatusEnum fromValue(String value) {
            for (StatusEnum b : StatusEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

