/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.checkout;

import com.adyen.model.checkout.DetailsRequestAuthenticationData;
import com.adyen.model.checkout.JSON;
import com.adyen.model.checkout.PaymentCompletionDetails;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.core.JsonProcessingException;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@JsonPropertyOrder(value={"authenticationData", "details", "paymentData", "threeDSAuthenticationOnly"})
public class PaymentDetailsRequest {
    public static final String JSON_PROPERTY_AUTHENTICATION_DATA = "authenticationData";
    private DetailsRequestAuthenticationData authenticationData;
    public static final String JSON_PROPERTY_DETAILS = "details";
    private PaymentCompletionDetails details;
    public static final String JSON_PROPERTY_PAYMENT_DATA = "paymentData";
    private String paymentData;
    public static final String JSON_PROPERTY_THREE_D_S_AUTHENTICATION_ONLY = "threeDSAuthenticationOnly";
    private Boolean threeDSAuthenticationOnly;

    public PaymentDetailsRequest authenticationData(DetailsRequestAuthenticationData authenticationData) {
        this.authenticationData = authenticationData;
        return this;
    }

    @ApiModelProperty(value="")
    @JsonProperty(value="authenticationData")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public DetailsRequestAuthenticationData getAuthenticationData() {
        return this.authenticationData;
    }

    @JsonProperty(value="authenticationData")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAuthenticationData(DetailsRequestAuthenticationData authenticationData) {
        this.authenticationData = authenticationData;
    }

    public PaymentDetailsRequest details(PaymentCompletionDetails details) {
        this.details = details;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="details")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public PaymentCompletionDetails getDetails() {
        return this.details;
    }

    @JsonProperty(value="details")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDetails(PaymentCompletionDetails details) {
        this.details = details;
    }

    public PaymentDetailsRequest paymentData(String paymentData) {
        this.paymentData = paymentData;
        return this;
    }

    @ApiModelProperty(value="Encoded payment data. For [authorizing a payment after using 3D Secure 2 Authentication-only](https://docs.adyen.com/online-payments/3d-secure/other-3ds-flows/authentication-only/#authorise-the-payment-with-adyen):  If you received `resultCode`: **AuthenticationNotRequired** in the `/payments` response, use the `threeDSPaymentData` from the same response.  If you received `resultCode`: **AuthenticationFinished** in the `/payments` response, use the `action.paymentData` from the same response.")
    @JsonProperty(value="paymentData")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getPaymentData() {
        return this.paymentData;
    }

    @JsonProperty(value="paymentData")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPaymentData(String paymentData) {
        this.paymentData = paymentData;
    }

    public PaymentDetailsRequest threeDSAuthenticationOnly(Boolean threeDSAuthenticationOnly) {
        this.threeDSAuthenticationOnly = threeDSAuthenticationOnly;
        return this;
    }

    @Deprecated
    @ApiModelProperty(value="Change the `authenticationOnly` indicator originally set in the `/payments` request. Only needs to be set if you want to modify the value set previously.")
    @JsonProperty(value="threeDSAuthenticationOnly")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getThreeDSAuthenticationOnly() {
        return this.threeDSAuthenticationOnly;
    }

    @Deprecated
    @JsonProperty(value="threeDSAuthenticationOnly")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setThreeDSAuthenticationOnly(Boolean threeDSAuthenticationOnly) {
        this.threeDSAuthenticationOnly = threeDSAuthenticationOnly;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PaymentDetailsRequest paymentDetailsRequest = (PaymentDetailsRequest)o;
        return Objects.equals(this.authenticationData, paymentDetailsRequest.authenticationData) && Objects.equals(this.details, paymentDetailsRequest.details) && Objects.equals(this.paymentData, paymentDetailsRequest.paymentData) && Objects.equals(this.threeDSAuthenticationOnly, paymentDetailsRequest.threeDSAuthenticationOnly);
    }

    public int hashCode() {
        return Objects.hash(this.authenticationData, this.details, this.paymentData, this.threeDSAuthenticationOnly);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PaymentDetailsRequest {\n");
        sb.append("    authenticationData: ").append(this.toIndentedString(this.authenticationData)).append("\n");
        sb.append("    details: ").append(this.toIndentedString(this.details)).append("\n");
        sb.append("    paymentData: ").append(this.toIndentedString(this.paymentData)).append("\n");
        sb.append("    threeDSAuthenticationOnly: ").append(this.toIndentedString(this.threeDSAuthenticationOnly)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static PaymentDetailsRequest fromJson(String jsonString) throws JsonProcessingException {
        return (PaymentDetailsRequest)JSON.getMapper().readValue(jsonString, PaymentDetailsRequest.class);
    }

    public String toJson() throws JsonProcessingException {
        return JSON.getMapper().writeValueAsString((Object)this);
    }
}

