/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.legalentitymanagement;

import com.adyen.model.legalentitymanagement.JSON;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.core.JsonProcessingException;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@JsonPropertyOrder(value={"allowed", "id", "requested", "verificationStatus"})
public class SupportingEntityCapability {
    public static final String JSON_PROPERTY_ALLOWED = "allowed";
    private Boolean allowed;
    public static final String JSON_PROPERTY_ID = "id";
    private String id;
    public static final String JSON_PROPERTY_REQUESTED = "requested";
    private Boolean requested;
    public static final String JSON_PROPERTY_VERIFICATION_STATUS = "verificationStatus";
    private String verificationStatus;

    public SupportingEntityCapability allowed(Boolean allowed) {
        this.allowed = allowed;
        return this;
    }

    @ApiModelProperty(value="Indicates whether the capability is allowed for the supporting entity.  If a capability is allowed for a supporting entity but not for the parent legal entity, this means the legal entity has other supporting entities that failed verification.  **You can use the allowed supporting entity** regardless of the verification status of other supporting entities.")
    @JsonProperty(value="allowed")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getAllowed() {
        return this.allowed;
    }

    @JsonProperty(value="allowed")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAllowed(Boolean allowed) {
        this.allowed = allowed;
    }

    public SupportingEntityCapability id(String id) {
        this.id = id;
        return this;
    }

    @ApiModelProperty(value="Supporting entity reference ")
    @JsonProperty(value="id")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getId() {
        return this.id;
    }

    @JsonProperty(value="id")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setId(String id) {
        this.id = id;
    }

    public SupportingEntityCapability requested(Boolean requested) {
        this.requested = requested;
        return this;
    }

    @ApiModelProperty(value="Indicates whether the supporting entity capability is requested. ")
    @JsonProperty(value="requested")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getRequested() {
        return this.requested;
    }

    @JsonProperty(value="requested")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setRequested(Boolean requested) {
        this.requested = requested;
    }

    public SupportingEntityCapability verificationStatus(String verificationStatus) {
        this.verificationStatus = verificationStatus;
        return this;
    }

    @ApiModelProperty(value="The status of the verification checks for the capability of the supporting entity.  Possible values:  * **pending**: Adyen is running the verification.  * **invalid**: The verification failed. Check if the `errors` array contains more information.  * **valid**: The verification has been successfully completed.  * **rejected**: Adyen has verified the information, but found reasons to not allow the capability. ")
    @JsonProperty(value="verificationStatus")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getVerificationStatus() {
        return this.verificationStatus;
    }

    @JsonProperty(value="verificationStatus")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setVerificationStatus(String verificationStatus) {
        this.verificationStatus = verificationStatus;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SupportingEntityCapability supportingEntityCapability = (SupportingEntityCapability)o;
        return Objects.equals(this.allowed, supportingEntityCapability.allowed) && Objects.equals(this.id, supportingEntityCapability.id) && Objects.equals(this.requested, supportingEntityCapability.requested) && Objects.equals(this.verificationStatus, supportingEntityCapability.verificationStatus);
    }

    public int hashCode() {
        return Objects.hash(this.allowed, this.id, this.requested, this.verificationStatus);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SupportingEntityCapability {\n");
        sb.append("    allowed: ").append(this.toIndentedString(this.allowed)).append("\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    requested: ").append(this.toIndentedString(this.requested)).append("\n");
        sb.append("    verificationStatus: ").append(this.toIndentedString(this.verificationStatus)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static SupportingEntityCapability fromJson(String jsonString) throws JsonProcessingException {
        return (SupportingEntityCapability)JSON.getMapper().readValue(jsonString, SupportingEntityCapability.class);
    }

    public String toJson() throws JsonProcessingException {
        return JSON.getMapper().writeValueAsString((Object)this);
    }
}

