/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.service.checkout;

import com.adyen.Client;
import com.adyen.Service;
import com.adyen.constants.ApiConstants;
import com.adyen.model.RequestOptions;
import com.adyen.model.checkout.PaymentLinkRequest;
import com.adyen.model.checkout.PaymentLinkResponse;
import com.adyen.model.checkout.UpdatePaymentLinkRequest;
import com.adyen.service.exception.ApiException;
import com.adyen.service.resource.Resource;
import java.io.IOException;
import java.util.HashMap;

public class PaymentLinksApi
extends Service {
    public static final String API_VERSION = "71";
    protected String baseURL;

    public PaymentLinksApi(Client client) {
        super(client);
        this.baseURL = this.createBaseURL("https://checkout-test.adyen.com/v71");
    }

    public PaymentLinksApi(Client client, String baseURL) {
        super(client);
        this.baseURL = baseURL;
    }

    public PaymentLinkResponse getPaymentLink(String linkId) throws ApiException, IOException {
        return this.getPaymentLink(linkId, null);
    }

    public PaymentLinkResponse getPaymentLink(String linkId, RequestOptions requestOptions) throws ApiException, IOException {
        HashMap<String, String> pathParams = new HashMap<String, String>();
        if (linkId == null) {
            throw new IllegalArgumentException("Please provide the linkId path parameter");
        }
        pathParams.put("linkId", linkId);
        String requestBody = null;
        Resource resource = new Resource(this, this.baseURL + "/paymentLinks/{linkId}", null);
        String jsonResult = resource.request(requestBody, requestOptions, ApiConstants.HttpMethod.GET, pathParams);
        return PaymentLinkResponse.fromJson(jsonResult);
    }

    public PaymentLinkResponse updatePaymentLink(String linkId, UpdatePaymentLinkRequest updatePaymentLinkRequest) throws ApiException, IOException {
        return this.updatePaymentLink(linkId, updatePaymentLinkRequest, null);
    }

    public PaymentLinkResponse updatePaymentLink(String linkId, UpdatePaymentLinkRequest updatePaymentLinkRequest, RequestOptions requestOptions) throws ApiException, IOException {
        HashMap<String, String> pathParams = new HashMap<String, String>();
        if (linkId == null) {
            throw new IllegalArgumentException("Please provide the linkId path parameter");
        }
        pathParams.put("linkId", linkId);
        String requestBody = updatePaymentLinkRequest.toJson();
        Resource resource = new Resource(this, this.baseURL + "/paymentLinks/{linkId}", null);
        String jsonResult = resource.request(requestBody, requestOptions, ApiConstants.HttpMethod.PATCH, pathParams);
        return PaymentLinkResponse.fromJson(jsonResult);
    }

    public PaymentLinkResponse paymentLinks(PaymentLinkRequest paymentLinkRequest) throws ApiException, IOException {
        return this.paymentLinks(paymentLinkRequest, null);
    }

    public PaymentLinkResponse paymentLinks(PaymentLinkRequest paymentLinkRequest, RequestOptions requestOptions) throws ApiException, IOException {
        String requestBody = paymentLinkRequest.toJson();
        Resource resource = new Resource(this, this.baseURL + "/paymentLinks", null);
        String jsonResult = resource.request(requestBody, requestOptions, ApiConstants.HttpMethod.POST, null);
        return PaymentLinkResponse.fromJson(jsonResult);
    }
}

