/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.transferwebhooks;

import com.adyen.model.transferwebhooks.JSON;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonProcessingException;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@JsonPropertyOrder(value={"direction", "id", "reference", "status", "type"})
public class Modification {
    public static final String JSON_PROPERTY_DIRECTION = "direction";
    private String direction;
    public static final String JSON_PROPERTY_ID = "id";
    private String id;
    public static final String JSON_PROPERTY_REFERENCE = "reference";
    private String reference;
    public static final String JSON_PROPERTY_STATUS = "status";
    private StatusEnum status;
    public static final String JSON_PROPERTY_TYPE = "type";
    private String type;

    public Modification direction(String direction) {
        this.direction = direction;
        return this;
    }

    @ApiModelProperty(value="The direction of the money movement.")
    @JsonProperty(value="direction")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getDirection() {
        return this.direction;
    }

    @JsonProperty(value="direction")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDirection(String direction) {
        this.direction = direction;
    }

    public Modification id(String id) {
        this.id = id;
        return this;
    }

    @ApiModelProperty(value="Our reference for the modification.")
    @JsonProperty(value="id")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getId() {
        return this.id;
    }

    @JsonProperty(value="id")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setId(String id) {
        this.id = id;
    }

    public Modification reference(String reference) {
        this.reference = reference;
        return this;
    }

    @ApiModelProperty(value="Your reference for the modification, used internally within your platform.")
    @JsonProperty(value="reference")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getReference() {
        return this.reference;
    }

    @JsonProperty(value="reference")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setReference(String reference) {
        this.reference = reference;
    }

    public Modification status(StatusEnum status) {
        this.status = status;
        return this;
    }

    @ApiModelProperty(value="The status of the transfer event.")
    @JsonProperty(value="status")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public StatusEnum getStatus() {
        return this.status;
    }

    @JsonProperty(value="status")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setStatus(StatusEnum status) {
        this.status = status;
    }

    public Modification type(String type) {
        this.type = type;
        return this;
    }

    @ApiModelProperty(value="The type of transfer modification.")
    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getType() {
        return this.type;
    }

    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setType(String type) {
        this.type = type;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Modification modification = (Modification)o;
        return Objects.equals(this.direction, modification.direction) && Objects.equals(this.id, modification.id) && Objects.equals(this.reference, modification.reference) && Objects.equals((Object)this.status, (Object)modification.status) && Objects.equals(this.type, modification.type);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.direction, this.id, this.reference, this.status, this.type});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Modification {\n");
        sb.append("    direction: ").append(this.toIndentedString(this.direction)).append("\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    reference: ").append(this.toIndentedString(this.reference)).append("\n");
        sb.append("    status: ").append(this.toIndentedString((Object)this.status)).append("\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static Modification fromJson(String jsonString) throws JsonProcessingException {
        return (Modification)JSON.getMapper().readValue(jsonString, Modification.class);
    }

    public String toJson() throws JsonProcessingException {
        return JSON.getMapper().writeValueAsString((Object)this);
    }

    public static enum StatusEnum {
        APPROVALPENDING("approvalPending"),
        ATMWITHDRAWAL("atmWithdrawal"),
        ATMWITHDRAWALREVERSALPENDING("atmWithdrawalReversalPending"),
        ATMWITHDRAWALREVERSED("atmWithdrawalReversed"),
        AUTHADJUSTMENTAUTHORISED("authAdjustmentAuthorised"),
        AUTHADJUSTMENTERROR("authAdjustmentError"),
        AUTHADJUSTMENTREFUSED("authAdjustmentRefused"),
        AUTHORISED("authorised"),
        BANKTRANSFER("bankTransfer"),
        BANKTRANSFERPENDING("bankTransferPending"),
        BOOKED("booked"),
        BOOKINGPENDING("bookingPending"),
        CANCELLED("cancelled"),
        CAPTUREPENDING("capturePending"),
        CAPTUREREVERSALPENDING("captureReversalPending"),
        CAPTUREREVERSED("captureReversed"),
        CAPTURED("captured"),
        CAPTUREDEXTERNALLY("capturedExternally"),
        CHARGEBACK("chargeback"),
        CHARGEBACKEXTERNALLY("chargebackExternally"),
        CHARGEBACKPENDING("chargebackPending"),
        CHARGEBACKREVERSALPENDING("chargebackReversalPending"),
        CHARGEBACKREVERSED("chargebackReversed"),
        CREDITED("credited"),
        DEPOSITCORRECTION("depositCorrection"),
        DEPOSITCORRECTIONPENDING("depositCorrectionPending"),
        DISPUTE("dispute"),
        DISPUTECLOSED("disputeClosed"),
        DISPUTEEXPIRED("disputeExpired"),
        DISPUTENEEDSREVIEW("disputeNeedsReview"),
        ERROR("error"),
        EXPIRED("expired"),
        FAILED("failed"),
        FEE("fee"),
        FEEPENDING("feePending"),
        INTERNALTRANSFER("internalTransfer"),
        INTERNALTRANSFERPENDING("internalTransferPending"),
        INVOICEDEDUCTION("invoiceDeduction"),
        INVOICEDEDUCTIONPENDING("invoiceDeductionPending"),
        MANUALCORRECTIONPENDING("manualCorrectionPending"),
        MANUALLYCORRECTED("manuallyCorrected"),
        MATCHEDSTATEMENT("matchedStatement"),
        MATCHEDSTATEMENTPENDING("matchedStatementPending"),
        MERCHANTPAYIN("merchantPayin"),
        MERCHANTPAYINPENDING("merchantPayinPending"),
        MERCHANTPAYINREVERSED("merchantPayinReversed"),
        MERCHANTPAYINREVERSEDPENDING("merchantPayinReversedPending"),
        MISCCOST("miscCost"),
        MISCCOSTPENDING("miscCostPending"),
        PAYMENTCOST("paymentCost"),
        PAYMENTCOSTPENDING("paymentCostPending"),
        RECEIVED("received"),
        REFUNDPENDING("refundPending"),
        REFUNDREVERSALPENDING("refundReversalPending"),
        REFUNDREVERSED("refundReversed"),
        REFUNDED("refunded"),
        REFUNDEDEXTERNALLY("refundedExternally"),
        REFUSED("refused"),
        RESERVEADJUSTMENT("reserveAdjustment"),
        RESERVEADJUSTMENTPENDING("reserveAdjustmentPending"),
        RETURNED("returned"),
        SECONDCHARGEBACK("secondChargeback"),
        SECONDCHARGEBACKPENDING("secondChargebackPending"),
        UNDEFINED("undefined");

        private String value;

        private StatusEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static StatusEnum fromValue(String value) {
            for (StatusEnum b : StatusEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

