/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.management;

import com.adyen.model.management.JSON;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.core.JsonProcessingException;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@JsonPropertyOrder(value={"amount", "currencyCode", "percentage"})
public class Currency {
    public static final String JSON_PROPERTY_AMOUNT = "amount";
    private Integer amount;
    public static final String JSON_PROPERTY_CURRENCY_CODE = "currencyCode";
    private String currencyCode;
    public static final String JSON_PROPERTY_PERCENTAGE = "percentage";
    private Double percentage;

    public Currency amount(Integer amount) {
        this.amount = amount;
        return this;
    }

    @ApiModelProperty(value="Surcharge amount per transaction, in [minor units](https://docs.adyen.com/development-resources/currency-codes).")
    @JsonProperty(value="amount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getAmount() {
        return this.amount;
    }

    @JsonProperty(value="amount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAmount(Integer amount) {
        this.amount = amount;
    }

    public Currency currencyCode(String currencyCode) {
        this.currencyCode = currencyCode;
        return this;
    }

    @ApiModelProperty(required=true, value="Three-character [ISO currency code](https://docs.adyen.com/development-resources/currency-codes). For example, **AUD**.")
    @JsonProperty(value="currencyCode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getCurrencyCode() {
        return this.currencyCode;
    }

    @JsonProperty(value="currencyCode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCurrencyCode(String currencyCode) {
        this.currencyCode = currencyCode;
    }

    public Currency percentage(Double percentage) {
        this.percentage = percentage;
        return this;
    }

    @ApiModelProperty(value="Surcharge percentage per transaction. The maximum number of decimal places is two. For example, **1%** or **2.27%**.")
    @JsonProperty(value="percentage")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Double getPercentage() {
        return this.percentage;
    }

    @JsonProperty(value="percentage")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPercentage(Double percentage) {
        this.percentage = percentage;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Currency currency = (Currency)o;
        return Objects.equals(this.amount, currency.amount) && Objects.equals(this.currencyCode, currency.currencyCode) && Objects.equals(this.percentage, currency.percentage);
    }

    public int hashCode() {
        return Objects.hash(this.amount, this.currencyCode, this.percentage);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Currency {\n");
        sb.append("    amount: ").append(this.toIndentedString(this.amount)).append("\n");
        sb.append("    currencyCode: ").append(this.toIndentedString(this.currencyCode)).append("\n");
        sb.append("    percentage: ").append(this.toIndentedString(this.percentage)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static Currency fromJson(String jsonString) throws JsonProcessingException {
        return (Currency)JSON.getMapper().readValue(jsonString, Currency.class);
    }

    public String toJson() throws JsonProcessingException {
        return JSON.getMapper().writeValueAsString((Object)this);
    }
}

