/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.checkout;

import com.adyen.model.checkout.JSON;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonProcessingException;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@JsonPropertyOrder(value={"threeDSReqAuthData", "threeDSReqAuthMethod", "threeDSReqAuthTimestamp"})
public class ThreeDSRequestorAuthenticationInfo {
    public static final String JSON_PROPERTY_THREE_D_S_REQ_AUTH_DATA = "threeDSReqAuthData";
    private String threeDSReqAuthData;
    public static final String JSON_PROPERTY_THREE_D_S_REQ_AUTH_METHOD = "threeDSReqAuthMethod";
    private ThreeDSReqAuthMethodEnum threeDSReqAuthMethod;
    public static final String JSON_PROPERTY_THREE_D_S_REQ_AUTH_TIMESTAMP = "threeDSReqAuthTimestamp";
    private String threeDSReqAuthTimestamp;

    public ThreeDSRequestorAuthenticationInfo threeDSReqAuthData(String threeDSReqAuthData) {
        this.threeDSReqAuthData = threeDSReqAuthData;
        return this;
    }

    @ApiModelProperty(value="Data that documents and supports a specific authentication process. Maximum length: 2048 bytes.")
    @JsonProperty(value="threeDSReqAuthData")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getThreeDSReqAuthData() {
        return this.threeDSReqAuthData;
    }

    @JsonProperty(value="threeDSReqAuthData")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setThreeDSReqAuthData(String threeDSReqAuthData) {
        this.threeDSReqAuthData = threeDSReqAuthData;
    }

    public ThreeDSRequestorAuthenticationInfo threeDSReqAuthMethod(ThreeDSReqAuthMethodEnum threeDSReqAuthMethod) {
        this.threeDSReqAuthMethod = threeDSReqAuthMethod;
        return this;
    }

    @ApiModelProperty(value="Mechanism used by the Cardholder to authenticate to the 3DS Requestor. Allowed values: * **01** \u2014 No 3DS Requestor authentication occurred (for example, cardholder \u201clogged in\u201d as guest). * **02** \u2014 Login to the cardholder account at the 3DS Requestor system using 3DS Requestor\u2019s own credentials. * **03** \u2014 Login to the cardholder account at the 3DS Requestor system using federated ID. * **04** \u2014 Login to the cardholder account at the 3DS Requestor system using issuer credentials. * **05** \u2014 Login to the cardholder account at the 3DS Requestor system using third-party authentication. * **06** \u2014 Login to the cardholder account at the 3DS Requestor system using FIDO Authenticator.")
    @JsonProperty(value="threeDSReqAuthMethod")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public ThreeDSReqAuthMethodEnum getThreeDSReqAuthMethod() {
        return this.threeDSReqAuthMethod;
    }

    @JsonProperty(value="threeDSReqAuthMethod")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setThreeDSReqAuthMethod(ThreeDSReqAuthMethodEnum threeDSReqAuthMethod) {
        this.threeDSReqAuthMethod = threeDSReqAuthMethod;
    }

    public ThreeDSRequestorAuthenticationInfo threeDSReqAuthTimestamp(String threeDSReqAuthTimestamp) {
        this.threeDSReqAuthTimestamp = threeDSReqAuthTimestamp;
        return this;
    }

    @ApiModelProperty(value="Date and time in UTC of the cardholder authentication. Format: YYYYMMDDHHMM")
    @JsonProperty(value="threeDSReqAuthTimestamp")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getThreeDSReqAuthTimestamp() {
        return this.threeDSReqAuthTimestamp;
    }

    @JsonProperty(value="threeDSReqAuthTimestamp")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setThreeDSReqAuthTimestamp(String threeDSReqAuthTimestamp) {
        this.threeDSReqAuthTimestamp = threeDSReqAuthTimestamp;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ThreeDSRequestorAuthenticationInfo threeDSRequestorAuthenticationInfo = (ThreeDSRequestorAuthenticationInfo)o;
        return Objects.equals(this.threeDSReqAuthData, threeDSRequestorAuthenticationInfo.threeDSReqAuthData) && Objects.equals((Object)this.threeDSReqAuthMethod, (Object)threeDSRequestorAuthenticationInfo.threeDSReqAuthMethod) && Objects.equals(this.threeDSReqAuthTimestamp, threeDSRequestorAuthenticationInfo.threeDSReqAuthTimestamp);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.threeDSReqAuthData, this.threeDSReqAuthMethod, this.threeDSReqAuthTimestamp});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ThreeDSRequestorAuthenticationInfo {\n");
        sb.append("    threeDSReqAuthData: ").append(this.toIndentedString(this.threeDSReqAuthData)).append("\n");
        sb.append("    threeDSReqAuthMethod: ").append(this.toIndentedString((Object)this.threeDSReqAuthMethod)).append("\n");
        sb.append("    threeDSReqAuthTimestamp: ").append(this.toIndentedString(this.threeDSReqAuthTimestamp)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static ThreeDSRequestorAuthenticationInfo fromJson(String jsonString) throws JsonProcessingException {
        return (ThreeDSRequestorAuthenticationInfo)JSON.getMapper().readValue(jsonString, ThreeDSRequestorAuthenticationInfo.class);
    }

    public String toJson() throws JsonProcessingException {
        return JSON.getMapper().writeValueAsString((Object)this);
    }

    public static enum ThreeDSReqAuthMethodEnum {
        _01("01"),
        _02("02"),
        _03("03"),
        _04("04"),
        _05("05"),
        _06("06");

        private String value;

        private ThreeDSReqAuthMethodEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static ThreeDSReqAuthMethodEnum fromValue(String value) {
            for (ThreeDSReqAuthMethodEnum b : ThreeDSReqAuthMethodEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

