/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.checkout;

import com.adyen.model.checkout.JSON;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonProcessingException;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@JsonPropertyOrder(value={"billingAddress", "deliveryAddress", "personalDetails"})
public class ShopperInput {
    public static final String JSON_PROPERTY_BILLING_ADDRESS = "billingAddress";
    private BillingAddressEnum billingAddress;
    public static final String JSON_PROPERTY_DELIVERY_ADDRESS = "deliveryAddress";
    private DeliveryAddressEnum deliveryAddress;
    public static final String JSON_PROPERTY_PERSONAL_DETAILS = "personalDetails";
    private PersonalDetailsEnum personalDetails;

    public ShopperInput billingAddress(BillingAddressEnum billingAddress) {
        this.billingAddress = billingAddress;
        return this;
    }

    @ApiModelProperty(value="Specifies visibility of billing address fields.  Permitted values: * editable * hidden * readOnly")
    @JsonProperty(value="billingAddress")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public BillingAddressEnum getBillingAddress() {
        return this.billingAddress;
    }

    @JsonProperty(value="billingAddress")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setBillingAddress(BillingAddressEnum billingAddress) {
        this.billingAddress = billingAddress;
    }

    public ShopperInput deliveryAddress(DeliveryAddressEnum deliveryAddress) {
        this.deliveryAddress = deliveryAddress;
        return this;
    }

    @ApiModelProperty(value="Specifies visibility of delivery address fields.  Permitted values: * editable * hidden * readOnly")
    @JsonProperty(value="deliveryAddress")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public DeliveryAddressEnum getDeliveryAddress() {
        return this.deliveryAddress;
    }

    @JsonProperty(value="deliveryAddress")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDeliveryAddress(DeliveryAddressEnum deliveryAddress) {
        this.deliveryAddress = deliveryAddress;
    }

    public ShopperInput personalDetails(PersonalDetailsEnum personalDetails) {
        this.personalDetails = personalDetails;
        return this;
    }

    @ApiModelProperty(value="Specifies visibility of personal details.  Permitted values: * editable * hidden * readOnly")
    @JsonProperty(value="personalDetails")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public PersonalDetailsEnum getPersonalDetails() {
        return this.personalDetails;
    }

    @JsonProperty(value="personalDetails")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPersonalDetails(PersonalDetailsEnum personalDetails) {
        this.personalDetails = personalDetails;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ShopperInput shopperInput = (ShopperInput)o;
        return Objects.equals((Object)this.billingAddress, (Object)shopperInput.billingAddress) && Objects.equals((Object)this.deliveryAddress, (Object)shopperInput.deliveryAddress) && Objects.equals((Object)this.personalDetails, (Object)shopperInput.personalDetails);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.billingAddress, this.deliveryAddress, this.personalDetails});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ShopperInput {\n");
        sb.append("    billingAddress: ").append(this.toIndentedString((Object)this.billingAddress)).append("\n");
        sb.append("    deliveryAddress: ").append(this.toIndentedString((Object)this.deliveryAddress)).append("\n");
        sb.append("    personalDetails: ").append(this.toIndentedString((Object)this.personalDetails)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static ShopperInput fromJson(String jsonString) throws JsonProcessingException {
        return (ShopperInput)JSON.getMapper().readValue(jsonString, ShopperInput.class);
    }

    public String toJson() throws JsonProcessingException {
        return JSON.getMapper().writeValueAsString((Object)this);
    }

    public static enum PersonalDetailsEnum {
        EDITABLE("editable"),
        HIDDEN("hidden"),
        READONLY("readOnly");

        private String value;

        private PersonalDetailsEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static PersonalDetailsEnum fromValue(String value) {
            for (PersonalDetailsEnum b : PersonalDetailsEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }

    public static enum DeliveryAddressEnum {
        EDITABLE("editable"),
        HIDDEN("hidden"),
        READONLY("readOnly");

        private String value;

        private DeliveryAddressEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static DeliveryAddressEnum fromValue(String value) {
            for (DeliveryAddressEnum b : DeliveryAddressEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }

    public static enum BillingAddressEnum {
        EDITABLE("editable"),
        HIDDEN("hidden"),
        READONLY("readOnly");

        private String value;

        private BillingAddressEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static BillingAddressEnum fromValue(String value) {
            for (BillingAddressEnum b : BillingAddressEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

