/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.service.transfers;

import com.adyen.Client;
import com.adyen.Service;
import com.adyen.constants.ApiConstants;
import com.adyen.model.RequestOptions;
import com.adyen.model.transfers.ReturnTransferRequest;
import com.adyen.model.transfers.ReturnTransferResponse;
import com.adyen.model.transfers.Transfer;
import com.adyen.model.transfers.TransferInfo;
import com.adyen.service.exception.ApiException;
import com.adyen.service.resource.Resource;
import java.io.IOException;
import java.util.HashMap;

public class TransfersApi
extends Service {
    public static final String API_VERSION = "4";
    protected String baseURL;

    public TransfersApi(Client client) {
        super(client);
        this.baseURL = this.createBaseURL("https://balanceplatform-api-test.adyen.com/btl/v4");
    }

    public TransfersApi(Client client, String baseURL) {
        super(client);
        this.baseURL = baseURL;
    }

    public Transfer transferFunds(TransferInfo transferInfo) throws ApiException, IOException {
        return this.transferFunds(transferInfo, null);
    }

    public Transfer transferFunds(TransferInfo transferInfo, RequestOptions requestOptions) throws ApiException, IOException {
        String requestBody = transferInfo.toJson();
        Resource resource = new Resource(this, this.baseURL + "/transfers", null);
        String jsonResult = resource.request(requestBody, requestOptions, ApiConstants.HttpMethod.POST, null);
        return Transfer.fromJson(jsonResult);
    }

    public ReturnTransferResponse returnTransfer(String id, ReturnTransferRequest returnTransferRequest) throws ApiException, IOException {
        return this.returnTransfer(id, returnTransferRequest, null);
    }

    public ReturnTransferResponse returnTransfer(String id, ReturnTransferRequest returnTransferRequest, RequestOptions requestOptions) throws ApiException, IOException {
        HashMap<String, String> pathParams = new HashMap<String, String>();
        if (id == null) {
            throw new IllegalArgumentException("Please provide the id path parameter");
        }
        pathParams.put("id", id);
        String requestBody = returnTransferRequest.toJson();
        Resource resource = new Resource(this, this.baseURL + "/transfers/{id}/returns", null);
        String jsonResult = resource.request(requestBody, requestOptions, ApiConstants.HttpMethod.POST, pathParams);
        return ReturnTransferResponse.fromJson(jsonResult);
    }
}

