/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.payment;

import com.adyen.model.payment.JSON;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonProcessingException;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@JsonPropertyOrder(value={"amount", "amountRule", "billingAttemptsRule", "billingDay", "endsAt", "frequency", "remarks", "startsAt"})
public class Mandate {
    public static final String JSON_PROPERTY_AMOUNT = "amount";
    private String amount;
    public static final String JSON_PROPERTY_AMOUNT_RULE = "amountRule";
    private AmountRuleEnum amountRule;
    public static final String JSON_PROPERTY_BILLING_ATTEMPTS_RULE = "billingAttemptsRule";
    private BillingAttemptsRuleEnum billingAttemptsRule;
    public static final String JSON_PROPERTY_BILLING_DAY = "billingDay";
    private String billingDay;
    public static final String JSON_PROPERTY_ENDS_AT = "endsAt";
    private String endsAt;
    public static final String JSON_PROPERTY_FREQUENCY = "frequency";
    private FrequencyEnum frequency;
    public static final String JSON_PROPERTY_REMARKS = "remarks";
    private String remarks;
    public static final String JSON_PROPERTY_STARTS_AT = "startsAt";
    private String startsAt;

    public Mandate amount(String amount) {
        this.amount = amount;
        return this;
    }

    @ApiModelProperty(required=true, value="The billing amount (in minor units) of the recurring transactions.")
    @JsonProperty(value="amount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getAmount() {
        return this.amount;
    }

    @JsonProperty(value="amount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAmount(String amount) {
        this.amount = amount;
    }

    public Mandate amountRule(AmountRuleEnum amountRule) {
        this.amountRule = amountRule;
        return this;
    }

    @ApiModelProperty(value="The limitation rule of the billing amount.  Possible values:  * **max**: The transaction amount can not exceed the `amount`.   * **exact**: The transaction amount should be the same as the `amount`.  ")
    @JsonProperty(value="amountRule")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public AmountRuleEnum getAmountRule() {
        return this.amountRule;
    }

    @JsonProperty(value="amountRule")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAmountRule(AmountRuleEnum amountRule) {
        this.amountRule = amountRule;
    }

    public Mandate billingAttemptsRule(BillingAttemptsRuleEnum billingAttemptsRule) {
        this.billingAttemptsRule = billingAttemptsRule;
        return this;
    }

    @ApiModelProperty(value="The rule to specify the period, within which the recurring debit can happen, relative to the mandate recurring date.  Possible values:   * **on**: On a specific date.   * **before**:  Before and on a specific date.   * **after**: On and after a specific date.  ")
    @JsonProperty(value="billingAttemptsRule")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public BillingAttemptsRuleEnum getBillingAttemptsRule() {
        return this.billingAttemptsRule;
    }

    @JsonProperty(value="billingAttemptsRule")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setBillingAttemptsRule(BillingAttemptsRuleEnum billingAttemptsRule) {
        this.billingAttemptsRule = billingAttemptsRule;
    }

    public Mandate billingDay(String billingDay) {
        this.billingDay = billingDay;
        return this;
    }

    @ApiModelProperty(value="The number of the day, on which the recurring debit can happen. Should be within the same calendar month as the mandate recurring date.  Possible values: 1-31 based on the `frequency`.")
    @JsonProperty(value="billingDay")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getBillingDay() {
        return this.billingDay;
    }

    @JsonProperty(value="billingDay")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setBillingDay(String billingDay) {
        this.billingDay = billingDay;
    }

    public Mandate endsAt(String endsAt) {
        this.endsAt = endsAt;
        return this;
    }

    @ApiModelProperty(required=true, value="End date of the billing plan, in YYYY-MM-DD format.")
    @JsonProperty(value="endsAt")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getEndsAt() {
        return this.endsAt;
    }

    @JsonProperty(value="endsAt")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setEndsAt(String endsAt) {
        this.endsAt = endsAt;
    }

    public Mandate frequency(FrequencyEnum frequency) {
        this.frequency = frequency;
        return this;
    }

    @ApiModelProperty(required=true, value="The frequency with which a shopper should be charged.  Possible values: **daily**, **weekly**, **biWeekly**, **monthly**, **quarterly**, **halfYearly**, **yearly**.")
    @JsonProperty(value="frequency")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public FrequencyEnum getFrequency() {
        return this.frequency;
    }

    @JsonProperty(value="frequency")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setFrequency(FrequencyEnum frequency) {
        this.frequency = frequency;
    }

    public Mandate remarks(String remarks) {
        this.remarks = remarks;
        return this;
    }

    @ApiModelProperty(value="The message shown by UPI to the shopper on the approval screen.")
    @JsonProperty(value="remarks")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getRemarks() {
        return this.remarks;
    }

    @JsonProperty(value="remarks")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setRemarks(String remarks) {
        this.remarks = remarks;
    }

    public Mandate startsAt(String startsAt) {
        this.startsAt = startsAt;
        return this;
    }

    @ApiModelProperty(value="Start date of the billing plan, in YYYY-MM-DD format. By default, the transaction date.")
    @JsonProperty(value="startsAt")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getStartsAt() {
        return this.startsAt;
    }

    @JsonProperty(value="startsAt")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setStartsAt(String startsAt) {
        this.startsAt = startsAt;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Mandate mandate = (Mandate)o;
        return Objects.equals(this.amount, mandate.amount) && Objects.equals((Object)this.amountRule, (Object)mandate.amountRule) && Objects.equals((Object)this.billingAttemptsRule, (Object)mandate.billingAttemptsRule) && Objects.equals(this.billingDay, mandate.billingDay) && Objects.equals(this.endsAt, mandate.endsAt) && Objects.equals((Object)this.frequency, (Object)mandate.frequency) && Objects.equals(this.remarks, mandate.remarks) && Objects.equals(this.startsAt, mandate.startsAt);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.amount, this.amountRule, this.billingAttemptsRule, this.billingDay, this.endsAt, this.frequency, this.remarks, this.startsAt});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Mandate {\n");
        sb.append("    amount: ").append(this.toIndentedString(this.amount)).append("\n");
        sb.append("    amountRule: ").append(this.toIndentedString((Object)this.amountRule)).append("\n");
        sb.append("    billingAttemptsRule: ").append(this.toIndentedString((Object)this.billingAttemptsRule)).append("\n");
        sb.append("    billingDay: ").append(this.toIndentedString(this.billingDay)).append("\n");
        sb.append("    endsAt: ").append(this.toIndentedString(this.endsAt)).append("\n");
        sb.append("    frequency: ").append(this.toIndentedString((Object)this.frequency)).append("\n");
        sb.append("    remarks: ").append(this.toIndentedString(this.remarks)).append("\n");
        sb.append("    startsAt: ").append(this.toIndentedString(this.startsAt)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static Mandate fromJson(String jsonString) throws JsonProcessingException {
        return (Mandate)JSON.getMapper().readValue(jsonString, Mandate.class);
    }

    public String toJson() throws JsonProcessingException {
        return JSON.getMapper().writeValueAsString((Object)this);
    }

    public static enum FrequencyEnum {
        ADHOC("adhoc"),
        DAILY("daily"),
        WEEKLY("weekly"),
        BIWEEKLY("biWeekly"),
        MONTHLY("monthly"),
        QUARTERLY("quarterly"),
        HALFYEARLY("halfYearly"),
        YEARLY("yearly");

        private String value;

        private FrequencyEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static FrequencyEnum fromValue(String value) {
            for (FrequencyEnum b : FrequencyEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }

    public static enum BillingAttemptsRuleEnum {
        ON("on"),
        BEFORE("before"),
        AFTER("after");

        private String value;

        private BillingAttemptsRuleEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static BillingAttemptsRuleEnum fromValue(String value) {
            for (BillingAttemptsRuleEnum b : BillingAttemptsRuleEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }

    public static enum AmountRuleEnum {
        MAX("max"),
        EXACT("exact");

        private String value;

        private AmountRuleEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static AmountRuleEnum fromValue(String value) {
            for (AmountRuleEnum b : AmountRuleEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

