/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.legalentitymanagement;

import com.adyen.model.legalentitymanagement.BankAccountInfoAccountIdentification;
import com.adyen.model.legalentitymanagement.JSON;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.core.JsonProcessingException;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@JsonPropertyOrder(value={"accountIdentification", "accountType", "bankName", "countryCode", "trustedSource"})
public class BankAccountInfo {
    public static final String JSON_PROPERTY_ACCOUNT_IDENTIFICATION = "accountIdentification";
    private BankAccountInfoAccountIdentification accountIdentification;
    public static final String JSON_PROPERTY_ACCOUNT_TYPE = "accountType";
    private String accountType;
    public static final String JSON_PROPERTY_BANK_NAME = "bankName";
    private String bankName;
    public static final String JSON_PROPERTY_COUNTRY_CODE = "countryCode";
    private String countryCode;
    public static final String JSON_PROPERTY_TRUSTED_SOURCE = "trustedSource";
    private Boolean trustedSource;

    public BankAccountInfo accountIdentification(BankAccountInfoAccountIdentification accountIdentification) {
        this.accountIdentification = accountIdentification;
        return this;
    }

    @ApiModelProperty(value="")
    @JsonProperty(value="accountIdentification")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public BankAccountInfoAccountIdentification getAccountIdentification() {
        return this.accountIdentification;
    }

    @JsonProperty(value="accountIdentification")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAccountIdentification(BankAccountInfoAccountIdentification accountIdentification) {
        this.accountIdentification = accountIdentification;
    }

    public BankAccountInfo accountType(String accountType) {
        this.accountType = accountType;
        return this;
    }

    @Deprecated
    @ApiModelProperty(value="The type of bank account.")
    @JsonProperty(value="accountType")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getAccountType() {
        return this.accountType;
    }

    @Deprecated
    @JsonProperty(value="accountType")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAccountType(String accountType) {
        this.accountType = accountType;
    }

    public BankAccountInfo bankName(String bankName) {
        this.bankName = bankName;
        return this;
    }

    @ApiModelProperty(value="The name of the banking institution where the bank account is held.")
    @JsonProperty(value="bankName")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getBankName() {
        return this.bankName;
    }

    @JsonProperty(value="bankName")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setBankName(String bankName) {
        this.bankName = bankName;
    }

    public BankAccountInfo countryCode(String countryCode) {
        this.countryCode = countryCode;
        return this;
    }

    @ApiModelProperty(value="The two-character [ISO 3166-1 alpha-2](https://en.wikipedia.org/wiki/ISO_3166-1_alpha-2) country code where the bank account is registered. For example, **NL**.")
    @JsonProperty(value="countryCode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getCountryCode() {
        return this.countryCode;
    }

    @JsonProperty(value="countryCode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCountryCode(String countryCode) {
        this.countryCode = countryCode;
    }

    public BankAccountInfo trustedSource(Boolean trustedSource) {
        this.trustedSource = trustedSource;
        return this;
    }

    @ApiModelProperty(value="Identifies if the bank account was created through [instant bank verification](https://docs.adyen.com/release-notes/platforms-and-financial-products#releaseNote=2023-05-08-hosted-onboarding).")
    @JsonProperty(value="trustedSource")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getTrustedSource() {
        return this.trustedSource;
    }

    @JsonProperty(value="trustedSource")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setTrustedSource(Boolean trustedSource) {
        this.trustedSource = trustedSource;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BankAccountInfo bankAccountInfo = (BankAccountInfo)o;
        return Objects.equals(this.accountIdentification, bankAccountInfo.accountIdentification) && Objects.equals(this.accountType, bankAccountInfo.accountType) && Objects.equals(this.bankName, bankAccountInfo.bankName) && Objects.equals(this.countryCode, bankAccountInfo.countryCode) && Objects.equals(this.trustedSource, bankAccountInfo.trustedSource);
    }

    public int hashCode() {
        return Objects.hash(this.accountIdentification, this.accountType, this.bankName, this.countryCode, this.trustedSource);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class BankAccountInfo {\n");
        sb.append("    accountIdentification: ").append(this.toIndentedString(this.accountIdentification)).append("\n");
        sb.append("    accountType: ").append(this.toIndentedString(this.accountType)).append("\n");
        sb.append("    bankName: ").append(this.toIndentedString(this.bankName)).append("\n");
        sb.append("    countryCode: ").append(this.toIndentedString(this.countryCode)).append("\n");
        sb.append("    trustedSource: ").append(this.toIndentedString(this.trustedSource)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static BankAccountInfo fromJson(String jsonString) throws JsonProcessingException {
        return (BankAccountInfo)JSON.getMapper().readValue(jsonString, BankAccountInfo.class);
    }

    public String toJson() throws JsonProcessingException {
        return JSON.getMapper().writeValueAsString((Object)this);
    }
}

