/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.management;

import com.adyen.model.management.AdditionalCommission;
import com.adyen.model.management.Commission;
import com.adyen.model.management.JSON;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonProcessingException;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@JsonPropertyOrder(value={"additionalCommission", "chargeback", "commission", "paymentFee", "remainder", "splitLogicId", "surcharge", "tip"})
public class UpdateSplitConfigurationLogicRequest {
    public static final String JSON_PROPERTY_ADDITIONAL_COMMISSION = "additionalCommission";
    private AdditionalCommission additionalCommission;
    public static final String JSON_PROPERTY_CHARGEBACK = "chargeback";
    private ChargebackEnum chargeback;
    public static final String JSON_PROPERTY_COMMISSION = "commission";
    private Commission commission;
    public static final String JSON_PROPERTY_PAYMENT_FEE = "paymentFee";
    private PaymentFeeEnum paymentFee;
    public static final String JSON_PROPERTY_REMAINDER = "remainder";
    private RemainderEnum remainder;
    public static final String JSON_PROPERTY_SPLIT_LOGIC_ID = "splitLogicId";
    private String splitLogicId;
    public static final String JSON_PROPERTY_SURCHARGE = "surcharge";
    private SurchargeEnum surcharge;
    public static final String JSON_PROPERTY_TIP = "tip";
    private TipEnum tip;

    public UpdateSplitConfigurationLogicRequest additionalCommission(AdditionalCommission additionalCommission) {
        this.additionalCommission = additionalCommission;
        return this;
    }

    @ApiModelProperty(value="")
    @JsonProperty(value="additionalCommission")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public AdditionalCommission getAdditionalCommission() {
        return this.additionalCommission;
    }

    @JsonProperty(value="additionalCommission")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAdditionalCommission(AdditionalCommission additionalCommission) {
        this.additionalCommission = additionalCommission;
    }

    public UpdateSplitConfigurationLogicRequest chargeback(ChargebackEnum chargeback) {
        this.chargeback = chargeback;
        return this;
    }

    @ApiModelProperty(value="Specifies the logic to apply when booking the chargeback amount.  Possible values: **deductFromLiableAccount**, **deductFromOneBalanceAccount**, **deductAccordingToSplitRatio**.")
    @JsonProperty(value="chargeback")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public ChargebackEnum getChargeback() {
        return this.chargeback;
    }

    @JsonProperty(value="chargeback")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setChargeback(ChargebackEnum chargeback) {
        this.chargeback = chargeback;
    }

    public UpdateSplitConfigurationLogicRequest commission(Commission commission) {
        this.commission = commission;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="commission")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Commission getCommission() {
        return this.commission;
    }

    @JsonProperty(value="commission")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCommission(Commission commission) {
        this.commission = commission;
    }

    public UpdateSplitConfigurationLogicRequest paymentFee(PaymentFeeEnum paymentFee) {
        this.paymentFee = paymentFee;
        return this;
    }

    @ApiModelProperty(required=true, value="Specifies the logic to apply when booking the transaction fees.  Possible values: **deductFromLiableAccount**, **deductFromOneBalanceAccount**.")
    @JsonProperty(value="paymentFee")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public PaymentFeeEnum getPaymentFee() {
        return this.paymentFee;
    }

    @JsonProperty(value="paymentFee")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPaymentFee(PaymentFeeEnum paymentFee) {
        this.paymentFee = paymentFee;
    }

    public UpdateSplitConfigurationLogicRequest remainder(RemainderEnum remainder) {
        this.remainder = remainder;
        return this;
    }

    @ApiModelProperty(value="Specifies the logic to apply when booking the amount left over after currency conversion.  Possible values: **addToLiableAccount**, **addToOneBalanceAccount**.")
    @JsonProperty(value="remainder")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public RemainderEnum getRemainder() {
        return this.remainder;
    }

    @JsonProperty(value="remainder")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setRemainder(RemainderEnum remainder) {
        this.remainder = remainder;
    }

    public UpdateSplitConfigurationLogicRequest splitLogicId(String splitLogicId) {
        this.splitLogicId = splitLogicId;
        return this;
    }

    @ApiModelProperty(value="Unique identifier of the split logic that is applied when the split configuration conditions are met.")
    @JsonProperty(value="splitLogicId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getSplitLogicId() {
        return this.splitLogicId;
    }

    @JsonProperty(value="splitLogicId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSplitLogicId(String splitLogicId) {
        this.splitLogicId = splitLogicId;
    }

    public UpdateSplitConfigurationLogicRequest surcharge(SurchargeEnum surcharge) {
        this.surcharge = surcharge;
        return this;
    }

    @ApiModelProperty(value="Specifies the logic to apply when booking the surcharge amount.  Possible values: **addToLiableAccount**, **addToOneBalanceAccount**")
    @JsonProperty(value="surcharge")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public SurchargeEnum getSurcharge() {
        return this.surcharge;
    }

    @JsonProperty(value="surcharge")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSurcharge(SurchargeEnum surcharge) {
        this.surcharge = surcharge;
    }

    public UpdateSplitConfigurationLogicRequest tip(TipEnum tip) {
        this.tip = tip;
        return this;
    }

    @ApiModelProperty(value="Specifies the logic to apply when booking tips (gratuity).  Possible values: **addToLiableAccount**, **addToOneBalanceAccount**.")
    @JsonProperty(value="tip")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public TipEnum getTip() {
        return this.tip;
    }

    @JsonProperty(value="tip")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setTip(TipEnum tip) {
        this.tip = tip;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UpdateSplitConfigurationLogicRequest updateSplitConfigurationLogicRequest = (UpdateSplitConfigurationLogicRequest)o;
        return Objects.equals(this.additionalCommission, updateSplitConfigurationLogicRequest.additionalCommission) && Objects.equals((Object)this.chargeback, (Object)updateSplitConfigurationLogicRequest.chargeback) && Objects.equals(this.commission, updateSplitConfigurationLogicRequest.commission) && Objects.equals((Object)this.paymentFee, (Object)updateSplitConfigurationLogicRequest.paymentFee) && Objects.equals((Object)this.remainder, (Object)updateSplitConfigurationLogicRequest.remainder) && Objects.equals(this.splitLogicId, updateSplitConfigurationLogicRequest.splitLogicId) && Objects.equals((Object)this.surcharge, (Object)updateSplitConfigurationLogicRequest.surcharge) && Objects.equals((Object)this.tip, (Object)updateSplitConfigurationLogicRequest.tip);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.additionalCommission, this.chargeback, this.commission, this.paymentFee, this.remainder, this.splitLogicId, this.surcharge, this.tip});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class UpdateSplitConfigurationLogicRequest {\n");
        sb.append("    additionalCommission: ").append(this.toIndentedString(this.additionalCommission)).append("\n");
        sb.append("    chargeback: ").append(this.toIndentedString((Object)this.chargeback)).append("\n");
        sb.append("    commission: ").append(this.toIndentedString(this.commission)).append("\n");
        sb.append("    paymentFee: ").append(this.toIndentedString((Object)this.paymentFee)).append("\n");
        sb.append("    remainder: ").append(this.toIndentedString((Object)this.remainder)).append("\n");
        sb.append("    splitLogicId: ").append(this.toIndentedString(this.splitLogicId)).append("\n");
        sb.append("    surcharge: ").append(this.toIndentedString((Object)this.surcharge)).append("\n");
        sb.append("    tip: ").append(this.toIndentedString((Object)this.tip)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static UpdateSplitConfigurationLogicRequest fromJson(String jsonString) throws JsonProcessingException {
        return (UpdateSplitConfigurationLogicRequest)JSON.getMapper().readValue(jsonString, UpdateSplitConfigurationLogicRequest.class);
    }

    public String toJson() throws JsonProcessingException {
        return JSON.getMapper().writeValueAsString((Object)this);
    }

    public static enum TipEnum {
        ADDTOLIABLEACCOUNT("addToLiableAccount"),
        ADDTOONEBALANCEACCOUNT("addToOneBalanceAccount");

        private String value;

        private TipEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static TipEnum fromValue(String value) {
            for (TipEnum b : TipEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }

    public static enum SurchargeEnum {
        ADDTOLIABLEACCOUNT("addToLiableAccount"),
        ADDTOONEBALANCEACCOUNT("addToOneBalanceAccount");

        private String value;

        private SurchargeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static SurchargeEnum fromValue(String value) {
            for (SurchargeEnum b : SurchargeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }

    public static enum RemainderEnum {
        ADDTOLIABLEACCOUNT("addToLiableAccount"),
        ADDTOONEBALANCEACCOUNT("addToOneBalanceAccount");

        private String value;

        private RemainderEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static RemainderEnum fromValue(String value) {
            for (RemainderEnum b : RemainderEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }

    public static enum PaymentFeeEnum {
        DEDUCTFROMLIABLEACCOUNT("deductFromLiableAccount"),
        DEDUCTFROMONEBALANCEACCOUNT("deductFromOneBalanceAccount");

        private String value;

        private PaymentFeeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static PaymentFeeEnum fromValue(String value) {
            for (PaymentFeeEnum b : PaymentFeeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }

    public static enum ChargebackEnum {
        DEDUCTFROMLIABLEACCOUNT("deductFromLiableAccount"),
        DEDUCTFROMONEBALANCEACCOUNT("deductFromOneBalanceAccount"),
        DEDUCTACCORDINGTOSPLITRATIO("deductAccordingToSplitRatio");

        private String value;

        private ChargebackEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static ChargebackEnum fromValue(String value) {
            for (ChargebackEnum b : ChargebackEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

