/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.management;

import com.adyen.model.management.JSON;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonProcessingException;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@JsonPropertyOrder(value={"authenticationMethod", "enablePayAtTable"})
public class PayAtTable {
    public static final String JSON_PROPERTY_AUTHENTICATION_METHOD = "authenticationMethod";
    private AuthenticationMethodEnum authenticationMethod;
    public static final String JSON_PROPERTY_ENABLE_PAY_AT_TABLE = "enablePayAtTable";
    private Boolean enablePayAtTable;

    public PayAtTable authenticationMethod(AuthenticationMethodEnum authenticationMethod) {
        this.authenticationMethod = authenticationMethod;
        return this;
    }

    @ApiModelProperty(value="Allowed authentication methods: Magswipe, Manual Entry.")
    @JsonProperty(value="authenticationMethod")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public AuthenticationMethodEnum getAuthenticationMethod() {
        return this.authenticationMethod;
    }

    @JsonProperty(value="authenticationMethod")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAuthenticationMethod(AuthenticationMethodEnum authenticationMethod) {
        this.authenticationMethod = authenticationMethod;
    }

    public PayAtTable enablePayAtTable(Boolean enablePayAtTable) {
        this.enablePayAtTable = enablePayAtTable;
        return this;
    }

    @ApiModelProperty(value="Enable Pay at table.")
    @JsonProperty(value="enablePayAtTable")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getEnablePayAtTable() {
        return this.enablePayAtTable;
    }

    @JsonProperty(value="enablePayAtTable")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setEnablePayAtTable(Boolean enablePayAtTable) {
        this.enablePayAtTable = enablePayAtTable;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PayAtTable payAtTable = (PayAtTable)o;
        return Objects.equals((Object)this.authenticationMethod, (Object)payAtTable.authenticationMethod) && Objects.equals(this.enablePayAtTable, payAtTable.enablePayAtTable);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.authenticationMethod, this.enablePayAtTable});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PayAtTable {\n");
        sb.append("    authenticationMethod: ").append(this.toIndentedString((Object)this.authenticationMethod)).append("\n");
        sb.append("    enablePayAtTable: ").append(this.toIndentedString(this.enablePayAtTable)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static PayAtTable fromJson(String jsonString) throws JsonProcessingException {
        return (PayAtTable)JSON.getMapper().readValue(jsonString, PayAtTable.class);
    }

    public String toJson() throws JsonProcessingException {
        return JSON.getMapper().writeValueAsString((Object)this);
    }

    public static enum AuthenticationMethodEnum {
        MAGSWIPE("MAGSWIPE"),
        MKE("MKE");

        private String value;

        private AuthenticationMethodEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static AuthenticationMethodEnum fromValue(String value) {
            for (AuthenticationMethodEnum b : AuthenticationMethodEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

