/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.legalentitymanagement;

import com.adyen.model.legalentitymanagement.JSON;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonProcessingException;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@JsonPropertyOrder(value={"associatorId", "entityType", "jobTitle", "legalEntityId", "name", "type"})
public class LegalEntityAssociation {
    public static final String JSON_PROPERTY_ASSOCIATOR_ID = "associatorId";
    private String associatorId;
    public static final String JSON_PROPERTY_ENTITY_TYPE = "entityType";
    private String entityType;
    public static final String JSON_PROPERTY_JOB_TITLE = "jobTitle";
    private String jobTitle;
    public static final String JSON_PROPERTY_LEGAL_ENTITY_ID = "legalEntityId";
    private String legalEntityId;
    public static final String JSON_PROPERTY_NAME = "name";
    private String name;
    public static final String JSON_PROPERTY_TYPE = "type";
    private TypeEnum type;

    public LegalEntityAssociation associatorId(String associatorId) {
        this.associatorId = associatorId;
        return this;
    }

    @ApiModelProperty(value="The unique identifier of another legal entity with which the `legalEntityId` is associated. When the `legalEntityId` is associated to legal entities other than the current one, the response returns all the associations.")
    @JsonProperty(value="associatorId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getAssociatorId() {
        return this.associatorId;
    }

    @JsonProperty(value="associatorId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAssociatorId(String associatorId) {
        this.associatorId = associatorId;
    }

    public LegalEntityAssociation entityType(String entityType) {
        this.entityType = entityType;
        return this;
    }

    @ApiModelProperty(value="The legal entity type of associated legal entity.  For example, **organization**, **soleProprietorship** or **individual**.")
    @JsonProperty(value="entityType")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getEntityType() {
        return this.entityType;
    }

    @JsonProperty(value="entityType")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setEntityType(String entityType) {
        this.entityType = entityType;
    }

    public LegalEntityAssociation jobTitle(String jobTitle) {
        this.jobTitle = jobTitle;
        return this;
    }

    @ApiModelProperty(value="The individual's job title if the `type` is **uboThroughControl** or **signatory**.")
    @JsonProperty(value="jobTitle")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getJobTitle() {
        return this.jobTitle;
    }

    @JsonProperty(value="jobTitle")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setJobTitle(String jobTitle) {
        this.jobTitle = jobTitle;
    }

    public LegalEntityAssociation legalEntityId(String legalEntityId) {
        this.legalEntityId = legalEntityId;
        return this;
    }

    @ApiModelProperty(required=true, value="The unique identifier of the associated [legal entity](https://docs.adyen.com/api-explorer/legalentity/latest/post/legalEntities#responses-200-id).")
    @JsonProperty(value="legalEntityId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getLegalEntityId() {
        return this.legalEntityId;
    }

    @JsonProperty(value="legalEntityId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setLegalEntityId(String legalEntityId) {
        this.legalEntityId = legalEntityId;
    }

    public LegalEntityAssociation name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(value="The name of the associated [legal entity](https://docs.adyen.com/api-explorer/legalentity/latest/post/legalEntities#responses-200-id).  - For **individual**, `name.firstName` and `name.lastName`. - For **organization**, `legalName`. - For **soleProprietorship**, `name`.")
    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setName(String name) {
        this.name = name;
    }

    public LegalEntityAssociation type(TypeEnum type) {
        this.type = type;
        return this;
    }

    @ApiModelProperty(required=true, value="Defines the relationship of the legal entity to the current legal entity.  Possible values for organizations: **uboThroughOwnership**, **uboThroughControl**, **director**, **signatory**, or **ultimateParentCompany**.  Possible values for sole proprietorships: **soleProprietorship**.")
    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public TypeEnum getType() {
        return this.type;
    }

    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setType(TypeEnum type) {
        this.type = type;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LegalEntityAssociation legalEntityAssociation = (LegalEntityAssociation)o;
        return Objects.equals(this.associatorId, legalEntityAssociation.associatorId) && Objects.equals(this.entityType, legalEntityAssociation.entityType) && Objects.equals(this.jobTitle, legalEntityAssociation.jobTitle) && Objects.equals(this.legalEntityId, legalEntityAssociation.legalEntityId) && Objects.equals(this.name, legalEntityAssociation.name) && Objects.equals((Object)this.type, (Object)legalEntityAssociation.type);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.associatorId, this.entityType, this.jobTitle, this.legalEntityId, this.name, this.type});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class LegalEntityAssociation {\n");
        sb.append("    associatorId: ").append(this.toIndentedString(this.associatorId)).append("\n");
        sb.append("    entityType: ").append(this.toIndentedString(this.entityType)).append("\n");
        sb.append("    jobTitle: ").append(this.toIndentedString(this.jobTitle)).append("\n");
        sb.append("    legalEntityId: ").append(this.toIndentedString(this.legalEntityId)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static LegalEntityAssociation fromJson(String jsonString) throws JsonProcessingException {
        return (LegalEntityAssociation)JSON.getMapper().readValue(jsonString, LegalEntityAssociation.class);
    }

    public String toJson() throws JsonProcessingException {
        return JSON.getMapper().writeValueAsString((Object)this);
    }

    public static enum TypeEnum {
        PCISIGNATORY("pciSignatory"),
        SIGNATORY("signatory"),
        SOLEPROPRIETORSHIP("soleProprietorship"),
        UBOTHROUGHCONTROL("uboThroughControl"),
        UBOTHROUGHOWNERSHIP("uboThroughOwnership"),
        ULTIMATEPARENTCOMPANY("ultimateParentCompany");

        private String value;

        private TypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static TypeEnum fromValue(String value) {
            for (TypeEnum b : TypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

