/*
 * Management API
 *
 * The version of the OpenAPI document: 1
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package com.adyen.service.management;

import com.adyen.Client;
import com.adyen.Service;
import com.adyen.constants.ApiConstants;
import com.adyen.model.management.CreateMerchantWebhookRequest;
import com.adyen.model.management.GenerateHmacKeyResponse;
import com.adyen.model.management.ListWebhooksResponse;
import com.adyen.model.management.RestServiceError;
import com.adyen.model.management.TestWebhookRequest;
import com.adyen.model.management.TestWebhookResponse;
import com.adyen.model.management.UpdateMerchantWebhookRequest;
import com.adyen.model.management.Webhook;
import com.adyen.model.RequestOptions;
import com.adyen.service.exception.ApiException;
import com.adyen.service.resource.Resource;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public class WebhooksMerchantLevelApi extends Service {

    public static final String API_VERSION = "1";

    protected String baseURL;

    /**
    * Webhooks - merchant level constructor in {@link com.adyen.service.management package}.
    * @param client {@link Client } (required)
    */
    public WebhooksMerchantLevelApi(Client client) {
        super(client);
        this.baseURL = createBaseURL("https://management-test.adyen.com/v1");
    }

    /**
    * Webhooks - merchant level constructor in {@link com.adyen.service.management package}.
    * Please use this constructor only if you would like to pass along your own url for routing or testing purposes. The latest API version is defined in this class as a constant.
    * @param client {@link Client } (required)
    * @param baseURL {@link String } (required)
    */
    public WebhooksMerchantLevelApi(Client client, String baseURL) {
        super(client);
        this.baseURL = baseURL;
    }

    /**
    * Remove a webhook
    *
    * @param merchantId {@link String } The unique identifier of the merchant account. (required)
    * @param webhookId {@link String } Unique identifier of the webhook configuration. (required)
    * @throws ApiException if fails to make API call
    */
    public void removeWebhook(String merchantId, String webhookId) throws ApiException, IOException {
        removeWebhook(merchantId, webhookId, null);
    }

    /**
    * Remove a webhook
    *
    * @param merchantId {@link String } The unique identifier of the merchant account. (required)
    * @param webhookId {@link String } Unique identifier of the webhook configuration. (required)
    * @param requestOptions {@link RequestOptions } Object to store additional data such as idempotency-keys (optional)
    * @throws ApiException if fails to make API call
    */
    public void removeWebhook(String merchantId, String webhookId, RequestOptions requestOptions) throws ApiException, IOException {
        //Add path params
        Map<String, String> pathParams = new HashMap<>();
        if (merchantId == null) {
            throw new IllegalArgumentException("Please provide the merchantId path parameter");
        }
        pathParams.put("merchantId", merchantId);
        if (webhookId == null) {
            throw new IllegalArgumentException("Please provide the webhookId path parameter");
        }
        pathParams.put("webhookId", webhookId);

        String requestBody = null;
        Resource resource = new Resource(this, this.baseURL + "/merchants/{merchantId}/webhooks/{webhookId}", null);
        resource.request(requestBody, requestOptions, ApiConstants.HttpMethod.DELETE, pathParams);
    }

    /**
    * List all webhooks
    *
    * @param merchantId {@link String } The unique identifier of the merchant account. (required)
    * @return {@link ListWebhooksResponse }
    * @throws ApiException if fails to make API call
    */
    public ListWebhooksResponse listAllWebhooks(String merchantId) throws ApiException, IOException {
        return listAllWebhooks(merchantId, null,  null,  null);
    }

    /**
    * List all webhooks
    *
    * @param merchantId {@link String } The unique identifier of the merchant account. (required)
    * @param pageNumber {@link Integer } Query: The number of the page to fetch. (optional)
    * @param pageSize {@link Integer } Query: The number of items to have on a page, maximum 100. The default is 10 items on a page. (optional)
    * @param requestOptions {@link RequestOptions } Object to store additional data such as idempotency-keys (optional)
    * @return {@link ListWebhooksResponse }
    * @throws ApiException if fails to make API call
    */
    public ListWebhooksResponse listAllWebhooks(String merchantId, Integer pageNumber, Integer pageSize, RequestOptions requestOptions) throws ApiException, IOException {
        //Add path params
        Map<String, String> pathParams = new HashMap<>();
        if (merchantId == null) {
            throw new IllegalArgumentException("Please provide the merchantId path parameter");
        }
        pathParams.put("merchantId", merchantId);
        //Add query params
        Map<String, String> queryParams = new HashMap<>();
        if (pageNumber != null) {
        queryParams.put("pageNumber", pageNumber.toString());
        }
        if (pageSize != null) {
        queryParams.put("pageSize", pageSize.toString());
        }

        String requestBody = null;
        Resource resource = new Resource(this, this.baseURL + "/merchants/{merchantId}/webhooks", null);
        String jsonResult = resource.request(requestBody, requestOptions, ApiConstants.HttpMethod.GET, pathParams, queryParams);
        return ListWebhooksResponse.fromJson(jsonResult);
    }

    /**
    * Get a webhook
    *
    * @param merchantId {@link String } The unique identifier of the merchant account. (required)
    * @param webhookId {@link String } Unique identifier of the webhook configuration. (required)
    * @return {@link Webhook }
    * @throws ApiException if fails to make API call
    */
    public Webhook getWebhook(String merchantId, String webhookId) throws ApiException, IOException {
        return getWebhook(merchantId, webhookId, null);
    }

    /**
    * Get a webhook
    *
    * @param merchantId {@link String } The unique identifier of the merchant account. (required)
    * @param webhookId {@link String } Unique identifier of the webhook configuration. (required)
    * @param requestOptions {@link RequestOptions } Object to store additional data such as idempotency-keys (optional)
    * @return {@link Webhook }
    * @throws ApiException if fails to make API call
    */
    public Webhook getWebhook(String merchantId, String webhookId, RequestOptions requestOptions) throws ApiException, IOException {
        //Add path params
        Map<String, String> pathParams = new HashMap<>();
        if (merchantId == null) {
            throw new IllegalArgumentException("Please provide the merchantId path parameter");
        }
        pathParams.put("merchantId", merchantId);
        if (webhookId == null) {
            throw new IllegalArgumentException("Please provide the webhookId path parameter");
        }
        pathParams.put("webhookId", webhookId);

        String requestBody = null;
        Resource resource = new Resource(this, this.baseURL + "/merchants/{merchantId}/webhooks/{webhookId}", null);
        String jsonResult = resource.request(requestBody, requestOptions, ApiConstants.HttpMethod.GET, pathParams);
        return Webhook.fromJson(jsonResult);
    }

    /**
    * Update a webhook
    *
    * @param merchantId {@link String } The unique identifier of the merchant account. (required)
    * @param webhookId {@link String } Unique identifier of the webhook configuration. (required)
    * @param updateMerchantWebhookRequest {@link UpdateMerchantWebhookRequest }  (required)
    * @return {@link Webhook }
    * @throws ApiException if fails to make API call
    */
    public Webhook updateWebhook(String merchantId, String webhookId, UpdateMerchantWebhookRequest updateMerchantWebhookRequest) throws ApiException, IOException {
        return updateWebhook(merchantId, webhookId, updateMerchantWebhookRequest, null);
    }

    /**
    * Update a webhook
    *
    * @param merchantId {@link String } The unique identifier of the merchant account. (required)
    * @param webhookId {@link String } Unique identifier of the webhook configuration. (required)
    * @param updateMerchantWebhookRequest {@link UpdateMerchantWebhookRequest }  (required)
    * @param requestOptions {@link RequestOptions } Object to store additional data such as idempotency-keys (optional)
    * @return {@link Webhook }
    * @throws ApiException if fails to make API call
    */
    public Webhook updateWebhook(String merchantId, String webhookId, UpdateMerchantWebhookRequest updateMerchantWebhookRequest, RequestOptions requestOptions) throws ApiException, IOException {
        //Add path params
        Map<String, String> pathParams = new HashMap<>();
        if (merchantId == null) {
            throw new IllegalArgumentException("Please provide the merchantId path parameter");
        }
        pathParams.put("merchantId", merchantId);
        if (webhookId == null) {
            throw new IllegalArgumentException("Please provide the webhookId path parameter");
        }
        pathParams.put("webhookId", webhookId);

        String requestBody = updateMerchantWebhookRequest.toJson();
        Resource resource = new Resource(this, this.baseURL + "/merchants/{merchantId}/webhooks/{webhookId}", null);
        String jsonResult = resource.request(requestBody, requestOptions, ApiConstants.HttpMethod.PATCH, pathParams);
        return Webhook.fromJson(jsonResult);
    }

    /**
    * Set up a webhook
    *
    * @param merchantId {@link String } The unique identifier of the merchant account. (required)
    * @param createMerchantWebhookRequest {@link CreateMerchantWebhookRequest }  (required)
    * @return {@link Webhook }
    * @throws ApiException if fails to make API call
    */
    public Webhook setUpWebhook(String merchantId, CreateMerchantWebhookRequest createMerchantWebhookRequest) throws ApiException, IOException {
        return setUpWebhook(merchantId, createMerchantWebhookRequest, null);
    }

    /**
    * Set up a webhook
    *
    * @param merchantId {@link String } The unique identifier of the merchant account. (required)
    * @param createMerchantWebhookRequest {@link CreateMerchantWebhookRequest }  (required)
    * @param requestOptions {@link RequestOptions } Object to store additional data such as idempotency-keys (optional)
    * @return {@link Webhook }
    * @throws ApiException if fails to make API call
    */
    public Webhook setUpWebhook(String merchantId, CreateMerchantWebhookRequest createMerchantWebhookRequest, RequestOptions requestOptions) throws ApiException, IOException {
        //Add path params
        Map<String, String> pathParams = new HashMap<>();
        if (merchantId == null) {
            throw new IllegalArgumentException("Please provide the merchantId path parameter");
        }
        pathParams.put("merchantId", merchantId);

        String requestBody = createMerchantWebhookRequest.toJson();
        Resource resource = new Resource(this, this.baseURL + "/merchants/{merchantId}/webhooks", null);
        String jsonResult = resource.request(requestBody, requestOptions, ApiConstants.HttpMethod.POST, pathParams);
        return Webhook.fromJson(jsonResult);
    }

    /**
    * Generate an HMAC key
    *
    * @param merchantId {@link String } The unique identifier of the merchant account. (required)
    * @param webhookId {@link String }  (required)
    * @return {@link GenerateHmacKeyResponse }
    * @throws ApiException if fails to make API call
    */
    public GenerateHmacKeyResponse generateHmacKey(String merchantId, String webhookId) throws ApiException, IOException {
        return generateHmacKey(merchantId, webhookId, null);
    }

    /**
    * Generate an HMAC key
    *
    * @param merchantId {@link String } The unique identifier of the merchant account. (required)
    * @param webhookId {@link String }  (required)
    * @param requestOptions {@link RequestOptions } Object to store additional data such as idempotency-keys (optional)
    * @return {@link GenerateHmacKeyResponse }
    * @throws ApiException if fails to make API call
    */
    public GenerateHmacKeyResponse generateHmacKey(String merchantId, String webhookId, RequestOptions requestOptions) throws ApiException, IOException {
        //Add path params
        Map<String, String> pathParams = new HashMap<>();
        if (merchantId == null) {
            throw new IllegalArgumentException("Please provide the merchantId path parameter");
        }
        pathParams.put("merchantId", merchantId);
        if (webhookId == null) {
            throw new IllegalArgumentException("Please provide the webhookId path parameter");
        }
        pathParams.put("webhookId", webhookId);

        String requestBody = null;
        Resource resource = new Resource(this, this.baseURL + "/merchants/{merchantId}/webhooks/{webhookId}/generateHmac", null);
        String jsonResult = resource.request(requestBody, requestOptions, ApiConstants.HttpMethod.POST, pathParams);
        return GenerateHmacKeyResponse.fromJson(jsonResult);
    }

    /**
    * Test a webhook
    *
    * @param merchantId {@link String } The unique identifier of the merchant account. (required)
    * @param webhookId {@link String } Unique identifier of the webhook configuration. (required)
    * @param testWebhookRequest {@link TestWebhookRequest }  (required)
    * @return {@link TestWebhookResponse }
    * @throws ApiException if fails to make API call
    */
    public TestWebhookResponse testWebhook(String merchantId, String webhookId, TestWebhookRequest testWebhookRequest) throws ApiException, IOException {
        return testWebhook(merchantId, webhookId, testWebhookRequest, null);
    }

    /**
    * Test a webhook
    *
    * @param merchantId {@link String } The unique identifier of the merchant account. (required)
    * @param webhookId {@link String } Unique identifier of the webhook configuration. (required)
    * @param testWebhookRequest {@link TestWebhookRequest }  (required)
    * @param requestOptions {@link RequestOptions } Object to store additional data such as idempotency-keys (optional)
    * @return {@link TestWebhookResponse }
    * @throws ApiException if fails to make API call
    */
    public TestWebhookResponse testWebhook(String merchantId, String webhookId, TestWebhookRequest testWebhookRequest, RequestOptions requestOptions) throws ApiException, IOException {
        //Add path params
        Map<String, String> pathParams = new HashMap<>();
        if (merchantId == null) {
            throw new IllegalArgumentException("Please provide the merchantId path parameter");
        }
        pathParams.put("merchantId", merchantId);
        if (webhookId == null) {
            throw new IllegalArgumentException("Please provide the webhookId path parameter");
        }
        pathParams.put("webhookId", webhookId);

        String requestBody = testWebhookRequest.toJson();
        Resource resource = new Resource(this, this.baseURL + "/merchants/{merchantId}/webhooks/{webhookId}/test", null);
        String jsonResult = resource.request(requestBody, requestOptions, ApiConstants.HttpMethod.POST, pathParams);
        return TestWebhookResponse.fromJson(jsonResult);
    }
}
