/*
 * Configuration API
 *
 * The version of the OpenAPI document: 2
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package com.adyen.service.balanceplatform;

import com.adyen.Client;
import com.adyen.Service;
import com.adyen.constants.ApiConstants;
import com.adyen.model.balanceplatform.PaymentInstrumentGroup;
import com.adyen.model.balanceplatform.PaymentInstrumentGroupInfo;
import com.adyen.model.balanceplatform.RestServiceError;
import com.adyen.model.balanceplatform.TransactionRulesResponse;
import com.adyen.model.RequestOptions;
import com.adyen.service.exception.ApiException;
import com.adyen.service.resource.Resource;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public class PaymentInstrumentGroupsApi extends Service {

    public static final String API_VERSION = "2";

    protected String baseURL;

    /**
    * Payment instrument groups constructor in {@link com.adyen.service.balanceplatform package}.
    * @param client {@link Client } (required)
    */
    public PaymentInstrumentGroupsApi(Client client) {
        super(client);
        this.baseURL = createBaseURL("https://balanceplatform-api-test.adyen.com/bcl/v2");
    }

    /**
    * Payment instrument groups constructor in {@link com.adyen.service.balanceplatform package}.
    * Please use this constructor only if you would like to pass along your own url for routing or testing purposes. The latest API version is defined in this class as a constant.
    * @param client {@link Client } (required)
    * @param baseURL {@link String } (required)
    */
    public PaymentInstrumentGroupsApi(Client client, String baseURL) {
        super(client);
        this.baseURL = baseURL;
    }

    /**
    * Get a payment instrument group
    *
    * @param id {@link String } The unique identifier of the payment instrument group. (required)
    * @return {@link PaymentInstrumentGroup }
    * @throws ApiException if fails to make API call
    */
    public PaymentInstrumentGroup getPaymentInstrumentGroup(String id) throws ApiException, IOException {
        return getPaymentInstrumentGroup(id, null);
    }

    /**
    * Get a payment instrument group
    *
    * @param id {@link String } The unique identifier of the payment instrument group. (required)
    * @param requestOptions {@link RequestOptions } Object to store additional data such as idempotency-keys (optional)
    * @return {@link PaymentInstrumentGroup }
    * @throws ApiException if fails to make API call
    */
    public PaymentInstrumentGroup getPaymentInstrumentGroup(String id, RequestOptions requestOptions) throws ApiException, IOException {
        //Add path params
        Map<String, String> pathParams = new HashMap<>();
        if (id == null) {
            throw new IllegalArgumentException("Please provide the id path parameter");
        }
        pathParams.put("id", id);

        String requestBody = null;
        Resource resource = new Resource(this, this.baseURL + "/paymentInstrumentGroups/{id}", null);
        String jsonResult = resource.request(requestBody, requestOptions, ApiConstants.HttpMethod.GET, pathParams);
        return PaymentInstrumentGroup.fromJson(jsonResult);
    }

    /**
    * Get all transaction rules for a payment instrument group
    *
    * @param id {@link String } The unique identifier of the payment instrument group. (required)
    * @return {@link TransactionRulesResponse }
    * @throws ApiException if fails to make API call
    */
    public TransactionRulesResponse getAllTransactionRulesForPaymentInstrumentGroup(String id) throws ApiException, IOException {
        return getAllTransactionRulesForPaymentInstrumentGroup(id, null);
    }

    /**
    * Get all transaction rules for a payment instrument group
    *
    * @param id {@link String } The unique identifier of the payment instrument group. (required)
    * @param requestOptions {@link RequestOptions } Object to store additional data such as idempotency-keys (optional)
    * @return {@link TransactionRulesResponse }
    * @throws ApiException if fails to make API call
    */
    public TransactionRulesResponse getAllTransactionRulesForPaymentInstrumentGroup(String id, RequestOptions requestOptions) throws ApiException, IOException {
        //Add path params
        Map<String, String> pathParams = new HashMap<>();
        if (id == null) {
            throw new IllegalArgumentException("Please provide the id path parameter");
        }
        pathParams.put("id", id);

        String requestBody = null;
        Resource resource = new Resource(this, this.baseURL + "/paymentInstrumentGroups/{id}/transactionRules", null);
        String jsonResult = resource.request(requestBody, requestOptions, ApiConstants.HttpMethod.GET, pathParams);
        return TransactionRulesResponse.fromJson(jsonResult);
    }

    /**
    * Create a payment instrument group
    *
    * @param paymentInstrumentGroupInfo {@link PaymentInstrumentGroupInfo }  (required)
    * @return {@link PaymentInstrumentGroup }
    * @throws ApiException if fails to make API call
    */
    public PaymentInstrumentGroup createPaymentInstrumentGroup(PaymentInstrumentGroupInfo paymentInstrumentGroupInfo) throws ApiException, IOException {
        return createPaymentInstrumentGroup(paymentInstrumentGroupInfo, null);
    }

    /**
    * Create a payment instrument group
    *
    * @param paymentInstrumentGroupInfo {@link PaymentInstrumentGroupInfo }  (required)
    * @param requestOptions {@link RequestOptions } Object to store additional data such as idempotency-keys (optional)
    * @return {@link PaymentInstrumentGroup }
    * @throws ApiException if fails to make API call
    */
    public PaymentInstrumentGroup createPaymentInstrumentGroup(PaymentInstrumentGroupInfo paymentInstrumentGroupInfo, RequestOptions requestOptions) throws ApiException, IOException {

        String requestBody = paymentInstrumentGroupInfo.toJson();
        Resource resource = new Resource(this, this.baseURL + "/paymentInstrumentGroups", null);
        String jsonResult = resource.request(requestBody, requestOptions, ApiConstants.HttpMethod.POST, null);
        return PaymentInstrumentGroup.fromJson(jsonResult);
    }
}
