/*
 * Disputes API
 * You can use the [Disputes API](https://docs.adyen.com/risk-management/disputes-api) to automate the dispute handling process so that you can respond to disputes and chargebacks as soon as they are initiated. The Disputes API lets you retrieve defense reasons, supply and delete defense documents, and accept or defend disputes.  ## Authentication Each request to the Disputes API must be signed with an API key. For this, obtain an API Key from your Customer Area, as described in [How to get the API key](https://docs.adyen.com/development-resources/api-credentials#generate-api-key). Then set this key to the `X-API-Key` header value, for example:  ``` curl -H \"Content-Type: application/json\" \\ -H \"X-API-Key: Your_API_key\" \\ ... ``` Note that when going live, you need to generate new web service user credentials to access the [live endpoints](https://docs.adyen.com/development-resources/live-endpoints).  ## Versioning Disputes API supports [versioning](https://docs.adyen.com/development-resources/versioning) using a version suffix in the endpoint URL. This suffix has the following format: \"vXX\", where XX is the version number.  For example: ``` https://ca-test.adyen.com/ca/services/DisputeService/v30/defendDispute ```
 *
 * The version of the OpenAPI document: 30
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package com.adyen.service;

import com.adyen.Client;
import com.adyen.Service;
import com.adyen.constants.ApiConstants;
import com.adyen.model.disputes.AcceptDisputeRequest;
import com.adyen.model.disputes.AcceptDisputeResponse;
import com.adyen.model.disputes.DefendDisputeRequest;
import com.adyen.model.disputes.DefendDisputeResponse;
import com.adyen.model.disputes.DefenseReasonsRequest;
import com.adyen.model.disputes.DefenseReasonsResponse;
import com.adyen.model.disputes.DeleteDefenseDocumentRequest;
import com.adyen.model.disputes.DeleteDefenseDocumentResponse;
import com.adyen.model.disputes.DownloadDefenseDocumentRequest;
import com.adyen.model.disputes.DownloadDefenseDocumentResponse;
import com.adyen.model.disputes.ServiceError;
import com.adyen.model.disputes.SupplyDefenseDocumentRequest;
import com.adyen.model.disputes.SupplyDefenseDocumentResponse;
import com.adyen.model.RequestOptions;
import com.adyen.service.exception.ApiException;
import com.adyen.service.resource.Resource;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public class DisputesApi extends Service {

    public static final String API_VERSION = "30";

    protected String baseURL;

    /**
    * General constructor in {@link com.adyen.service package}.
    * @param client {@link Client }  (required)
    */
    public DisputesApi(Client client) {
        super(client);
        this.baseURL = createBaseURL("https://ca-test.adyen.com/ca/services/DisputeService/v30");
    }

    /**
    * General constructor in {@link com.adyen.service package}.
    * Please use this constructor only if you would like to pass along your own url for routing or testing purposes. The latest API version is defined in this class as a constant.
    * @param client {@link Client }  (required)
    * @param baseURL {@link String }  (required)
    */
    public DisputesApi(Client client, String baseURL) {
        super(client);
        this.baseURL = baseURL;
    }

    /**
    * Accept a dispute
    *
    * @param acceptDisputeRequest {@link AcceptDisputeRequest }  (required)
    * @return {@link AcceptDisputeResponse }
    * @throws ApiException if fails to make API call
    */
    public AcceptDisputeResponse acceptDispute(AcceptDisputeRequest acceptDisputeRequest) throws ApiException, IOException {
        return acceptDispute(acceptDisputeRequest, null);
    }

    /**
    * Accept a dispute
    *
    * @param acceptDisputeRequest {@link AcceptDisputeRequest }  (required)
    * @param requestOptions {@link RequestOptions } Object to store additional data such as idempotency-keys (optional)
    * @return {@link AcceptDisputeResponse }
    * @throws ApiException if fails to make API call
    */
    public AcceptDisputeResponse acceptDispute(AcceptDisputeRequest acceptDisputeRequest, RequestOptions requestOptions) throws ApiException, IOException {

        String requestBody = acceptDisputeRequest.toJson();
        Resource resource = new Resource(this, this.baseURL + "/acceptDispute", null);
        String jsonResult = resource.request(requestBody, requestOptions, ApiConstants.HttpMethod.POST, null);
        return AcceptDisputeResponse.fromJson(jsonResult);
    }

    /**
    * Defend a dispute
    *
    * @param defendDisputeRequest {@link DefendDisputeRequest }  (required)
    * @return {@link DefendDisputeResponse }
    * @throws ApiException if fails to make API call
    */
    public DefendDisputeResponse defendDispute(DefendDisputeRequest defendDisputeRequest) throws ApiException, IOException {
        return defendDispute(defendDisputeRequest, null);
    }

    /**
    * Defend a dispute
    *
    * @param defendDisputeRequest {@link DefendDisputeRequest }  (required)
    * @param requestOptions {@link RequestOptions } Object to store additional data such as idempotency-keys (optional)
    * @return {@link DefendDisputeResponse }
    * @throws ApiException if fails to make API call
    */
    public DefendDisputeResponse defendDispute(DefendDisputeRequest defendDisputeRequest, RequestOptions requestOptions) throws ApiException, IOException {

        String requestBody = defendDisputeRequest.toJson();
        Resource resource = new Resource(this, this.baseURL + "/defendDispute", null);
        String jsonResult = resource.request(requestBody, requestOptions, ApiConstants.HttpMethod.POST, null);
        return DefendDisputeResponse.fromJson(jsonResult);
    }

    /**
    * Delete a defense document
    *
    * @param deleteDefenseDocumentRequest {@link DeleteDefenseDocumentRequest }  (required)
    * @return {@link DeleteDefenseDocumentResponse }
    * @throws ApiException if fails to make API call
    */
    public DeleteDefenseDocumentResponse deleteDisputeDefenseDocument(DeleteDefenseDocumentRequest deleteDefenseDocumentRequest) throws ApiException, IOException {
        return deleteDisputeDefenseDocument(deleteDefenseDocumentRequest, null);
    }

    /**
    * Delete a defense document
    *
    * @param deleteDefenseDocumentRequest {@link DeleteDefenseDocumentRequest }  (required)
    * @param requestOptions {@link RequestOptions } Object to store additional data such as idempotency-keys (optional)
    * @return {@link DeleteDefenseDocumentResponse }
    * @throws ApiException if fails to make API call
    */
    public DeleteDefenseDocumentResponse deleteDisputeDefenseDocument(DeleteDefenseDocumentRequest deleteDefenseDocumentRequest, RequestOptions requestOptions) throws ApiException, IOException {

        String requestBody = deleteDefenseDocumentRequest.toJson();
        Resource resource = new Resource(this, this.baseURL + "/deleteDisputeDefenseDocument", null);
        String jsonResult = resource.request(requestBody, requestOptions, ApiConstants.HttpMethod.POST, null);
        return DeleteDefenseDocumentResponse.fromJson(jsonResult);
    }

    /**
    * Download a defense document
    *
    * @param downloadDefenseDocumentRequest {@link DownloadDefenseDocumentRequest }  (required)
    * @return {@link DownloadDefenseDocumentResponse }
    * @throws ApiException if fails to make API call
    */
    public DownloadDefenseDocumentResponse downloadDisputeDefenseDocument(DownloadDefenseDocumentRequest downloadDefenseDocumentRequest) throws ApiException, IOException {
        return downloadDisputeDefenseDocument(downloadDefenseDocumentRequest, null);
    }

    /**
    * Download a defense document
    *
    * @param downloadDefenseDocumentRequest {@link DownloadDefenseDocumentRequest }  (required)
    * @param requestOptions {@link RequestOptions } Object to store additional data such as idempotency-keys (optional)
    * @return {@link DownloadDefenseDocumentResponse }
    * @throws ApiException if fails to make API call
    */
    public DownloadDefenseDocumentResponse downloadDisputeDefenseDocument(DownloadDefenseDocumentRequest downloadDefenseDocumentRequest, RequestOptions requestOptions) throws ApiException, IOException {

        String requestBody = downloadDefenseDocumentRequest.toJson();
        Resource resource = new Resource(this, this.baseURL + "/downloadDisputeDefenseDocument", null);
        String jsonResult = resource.request(requestBody, requestOptions, ApiConstants.HttpMethod.POST, null);
        return DownloadDefenseDocumentResponse.fromJson(jsonResult);
    }

    /**
    * Get applicable defense reasons
    *
    * @param defenseReasonsRequest {@link DefenseReasonsRequest }  (required)
    * @return {@link DefenseReasonsResponse }
    * @throws ApiException if fails to make API call
    */
    public DefenseReasonsResponse retrieveApplicableDefenseReasons(DefenseReasonsRequest defenseReasonsRequest) throws ApiException, IOException {
        return retrieveApplicableDefenseReasons(defenseReasonsRequest, null);
    }

    /**
    * Get applicable defense reasons
    *
    * @param defenseReasonsRequest {@link DefenseReasonsRequest }  (required)
    * @param requestOptions {@link RequestOptions } Object to store additional data such as idempotency-keys (optional)
    * @return {@link DefenseReasonsResponse }
    * @throws ApiException if fails to make API call
    */
    public DefenseReasonsResponse retrieveApplicableDefenseReasons(DefenseReasonsRequest defenseReasonsRequest, RequestOptions requestOptions) throws ApiException, IOException {

        String requestBody = defenseReasonsRequest.toJson();
        Resource resource = new Resource(this, this.baseURL + "/retrieveApplicableDefenseReasons", null);
        String jsonResult = resource.request(requestBody, requestOptions, ApiConstants.HttpMethod.POST, null);
        return DefenseReasonsResponse.fromJson(jsonResult);
    }

    /**
    * Supply a defense document
    *
    * @param supplyDefenseDocumentRequest {@link SupplyDefenseDocumentRequest }  (required)
    * @return {@link SupplyDefenseDocumentResponse }
    * @throws ApiException if fails to make API call
    */
    public SupplyDefenseDocumentResponse supplyDefenseDocument(SupplyDefenseDocumentRequest supplyDefenseDocumentRequest) throws ApiException, IOException {
        return supplyDefenseDocument(supplyDefenseDocumentRequest, null);
    }

    /**
    * Supply a defense document
    *
    * @param supplyDefenseDocumentRequest {@link SupplyDefenseDocumentRequest }  (required)
    * @param requestOptions {@link RequestOptions } Object to store additional data such as idempotency-keys (optional)
    * @return {@link SupplyDefenseDocumentResponse }
    * @throws ApiException if fails to make API call
    */
    public SupplyDefenseDocumentResponse supplyDefenseDocument(SupplyDefenseDocumentRequest supplyDefenseDocumentRequest, RequestOptions requestOptions) throws ApiException, IOException {

        String requestBody = supplyDefenseDocumentRequest.toJson();
        Resource resource = new Resource(this, this.baseURL + "/supplyDefenseDocument", null);
        String jsonResult = resource.request(requestBody, requestOptions, ApiConstants.HttpMethod.POST, null);
        return SupplyDefenseDocumentResponse.fromJson(jsonResult);
    }
}
