/*
 * Transfer webhooks
 *
 * The version of the OpenAPI document: 3
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package com.adyen.model.transferwebhooks;

import java.util.Objects;
import java.util.Arrays;
import java.util.Map;
import java.util.HashMap;
import com.adyen.model.transferwebhooks.TransactionEventViolation;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.core.JsonProcessingException;


/**
 * TransactionRulesResult
 */
@JsonPropertyOrder({
  TransactionRulesResult.JSON_PROPERTY_ADVICE,
  TransactionRulesResult.JSON_PROPERTY_ALL_RULES_PASSED,
  TransactionRulesResult.JSON_PROPERTY_FAILED_TRANSACTION_RULES,
  TransactionRulesResult.JSON_PROPERTY_SCORE
})

public class TransactionRulesResult {
  public static final String JSON_PROPERTY_ADVICE = "advice";
  private String advice;

  public static final String JSON_PROPERTY_ALL_RULES_PASSED = "allRulesPassed";
  private Boolean allRulesPassed;

  public static final String JSON_PROPERTY_FAILED_TRANSACTION_RULES = "failedTransactionRules";
  private List<TransactionEventViolation> failedTransactionRules = null;

  public static final String JSON_PROPERTY_SCORE = "score";
  private Integer score;

  public TransactionRulesResult() { 
  }

  public TransactionRulesResult advice(String advice) {
    this.advice = advice;
    return this;
  }

   /**
   * The advice given by the Risk analysis.
   * @return advice
  **/
  @ApiModelProperty(value = "The advice given by the Risk analysis.")
  @JsonProperty(JSON_PROPERTY_ADVICE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getAdvice() {
    return advice;
  }


  @JsonProperty(JSON_PROPERTY_ADVICE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAdvice(String advice) {
    this.advice = advice;
  }


  public TransactionRulesResult allRulesPassed(Boolean allRulesPassed) {
    this.allRulesPassed = allRulesPassed;
    return this;
  }

   /**
   * Indicates whether the transaction passed the evaluation for all transaction rules.
   * @return allRulesPassed
  **/
  @ApiModelProperty(value = "Indicates whether the transaction passed the evaluation for all transaction rules.")
  @JsonProperty(JSON_PROPERTY_ALL_RULES_PASSED)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getAllRulesPassed() {
    return allRulesPassed;
  }


  @JsonProperty(JSON_PROPERTY_ALL_RULES_PASSED)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAllRulesPassed(Boolean allRulesPassed) {
    this.allRulesPassed = allRulesPassed;
  }


  public TransactionRulesResult failedTransactionRules(List<TransactionEventViolation> failedTransactionRules) {
    this.failedTransactionRules = failedTransactionRules;
    return this;
  }

  public TransactionRulesResult addFailedTransactionRulesItem(TransactionEventViolation failedTransactionRulesItem) {
    if (this.failedTransactionRules == null) {
      this.failedTransactionRules = new ArrayList<>();
    }
    this.failedTransactionRules.add(failedTransactionRulesItem);
    return this;
  }

   /**
   * Array containing all the transaction rules that the transaction violated. This list is only sent when &#x60;allRulesPassed&#x60; is **false**.
   * @return failedTransactionRules
  **/
  @ApiModelProperty(value = "Array containing all the transaction rules that the transaction violated. This list is only sent when `allRulesPassed` is **false**.")
  @JsonProperty(JSON_PROPERTY_FAILED_TRANSACTION_RULES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<TransactionEventViolation> getFailedTransactionRules() {
    return failedTransactionRules;
  }


  @JsonProperty(JSON_PROPERTY_FAILED_TRANSACTION_RULES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setFailedTransactionRules(List<TransactionEventViolation> failedTransactionRules) {
    this.failedTransactionRules = failedTransactionRules;
  }


  public TransactionRulesResult score(Integer score) {
    this.score = score;
    return this;
  }

   /**
   * The score of the Risk analysis.
   * @return score
  **/
  @ApiModelProperty(value = "The score of the Risk analysis.")
  @JsonProperty(JSON_PROPERTY_SCORE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getScore() {
    return score;
  }


  @JsonProperty(JSON_PROPERTY_SCORE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setScore(Integer score) {
    this.score = score;
  }


  /**
   * Return true if this TransactionRulesResult object is equal to o.
   */
  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    TransactionRulesResult transactionRulesResult = (TransactionRulesResult) o;
    return Objects.equals(this.advice, transactionRulesResult.advice) &&
        Objects.equals(this.allRulesPassed, transactionRulesResult.allRulesPassed) &&
        Objects.equals(this.failedTransactionRules, transactionRulesResult.failedTransactionRules) &&
        Objects.equals(this.score, transactionRulesResult.score);
  }

  @Override
  public int hashCode() {
    return Objects.hash(advice, allRulesPassed, failedTransactionRules, score);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class TransactionRulesResult {\n");
    sb.append("    advice: ").append(toIndentedString(advice)).append("\n");
    sb.append("    allRulesPassed: ").append(toIndentedString(allRulesPassed)).append("\n");
    sb.append("    failedTransactionRules: ").append(toIndentedString(failedTransactionRules)).append("\n");
    sb.append("    score: ").append(toIndentedString(score)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

/**
   * Create an instance of TransactionRulesResult given an JSON string
   *
   * @param jsonString JSON string
   * @return An instance of TransactionRulesResult
   * @throws JsonProcessingException if the JSON string is invalid with respect to TransactionRulesResult
   */
  public static TransactionRulesResult fromJson(String jsonString) throws JsonProcessingException {
    return JSON.getMapper().readValue(jsonString, TransactionRulesResult.class);
  }
/**
  * Convert an instance of TransactionRulesResult to an JSON string
  *
  * @return JSON string
  */
  public String toJson() throws JsonProcessingException {
    return JSON.getMapper().writeValueAsString(this);
  }
}

