/*
 * Adyen Payment API
 * A set of API endpoints that allow you to initiate, settle, and modify payments on the Adyen payments platform. You can use the API to accept card payments (including One-Click and 3D Secure), bank transfers, ewallets, and many other payment methods.  To learn more about the API, visit [Classic integration](https://docs.adyen.com/classic-integration).  ## Authentication You need an [API credential](https://docs.adyen.com/development-resources/api-credentials) to authenticate to the API.  If using an API key, add an `X-API-Key` header with the API key as the value, for example:   ``` curl -H \"Content-Type: application/json\" \\ -H \"X-API-Key: YOUR_API_KEY\" \\ ... ```  Alternatively, you can use the username and password to connect to the API using basic authentication, for example:  ``` curl -U \"ws@Company.YOUR_COMPANY_ACCOUNT\":\"YOUR_BASIC_AUTHENTICATION_PASSWORD\" \\ -H \"Content-Type: application/json\" \\ ... ```  ## Versioning Payments API supports [versioning](https://docs.adyen.com/development-resources/versioning) using a version suffix in the endpoint URL. This suffix has the following format: \"vXX\", where XX is the version number.  For example: ``` https://pal-test.adyen.com/pal/servlet/Payment/v68/authorise ```  ## Going live  To authenticate to the live endpoints, you need an [API credential](https://docs.adyen.com/development-resources/api-credentials) from your live Customer Area.  The live endpoint URLs contain a prefix which is unique to your company account: ```  https://{PREFIX}-pal-live.adyenpayments.com/pal/servlet/Payment/v68/authorise ```  Get your `{PREFIX}` from your live Customer Area under **Developers** > **API URLs** > **Prefix**.
 *
 * The version of the OpenAPI document: 68
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package com.adyen.model.payment;

import java.util.Objects;
import java.util.Arrays;
import java.util.Map;
import java.util.HashMap;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.core.JsonProcessingException;


/**
 * ResponseAdditionalDataSepa
 */
@JsonPropertyOrder({
  ResponseAdditionalDataSepa.JSON_PROPERTY_SEPADIRECTDEBIT_DATE_OF_SIGNATURE,
  ResponseAdditionalDataSepa.JSON_PROPERTY_SEPADIRECTDEBIT_MANDATE_ID,
  ResponseAdditionalDataSepa.JSON_PROPERTY_SEPADIRECTDEBIT_SEQUENCE_TYPE
})

public class ResponseAdditionalDataSepa {
  public static final String JSON_PROPERTY_SEPADIRECTDEBIT_DATE_OF_SIGNATURE = "sepadirectdebit.dateOfSignature";
  private String sepadirectdebitDateOfSignature;

  public static final String JSON_PROPERTY_SEPADIRECTDEBIT_MANDATE_ID = "sepadirectdebit.mandateId";
  private String sepadirectdebitMandateId;

  public static final String JSON_PROPERTY_SEPADIRECTDEBIT_SEQUENCE_TYPE = "sepadirectdebit.sequenceType";
  private String sepadirectdebitSequenceType;

  public ResponseAdditionalDataSepa() { 
  }

  public ResponseAdditionalDataSepa sepadirectdebitDateOfSignature(String sepadirectdebitDateOfSignature) {
    this.sepadirectdebitDateOfSignature = sepadirectdebitDateOfSignature;
    return this;
  }

   /**
   * The transaction signature date.  Format: yyyy-MM-dd
   * @return sepadirectdebitDateOfSignature
  **/
  @ApiModelProperty(value = "The transaction signature date.  Format: yyyy-MM-dd")
  @JsonProperty(JSON_PROPERTY_SEPADIRECTDEBIT_DATE_OF_SIGNATURE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getSepadirectdebitDateOfSignature() {
    return sepadirectdebitDateOfSignature;
  }


  @JsonProperty(JSON_PROPERTY_SEPADIRECTDEBIT_DATE_OF_SIGNATURE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSepadirectdebitDateOfSignature(String sepadirectdebitDateOfSignature) {
    this.sepadirectdebitDateOfSignature = sepadirectdebitDateOfSignature;
  }


  public ResponseAdditionalDataSepa sepadirectdebitMandateId(String sepadirectdebitMandateId) {
    this.sepadirectdebitMandateId = sepadirectdebitMandateId;
    return this;
  }

   /**
   * Its value corresponds to the pspReference value of the transaction.
   * @return sepadirectdebitMandateId
  **/
  @ApiModelProperty(value = "Its value corresponds to the pspReference value of the transaction.")
  @JsonProperty(JSON_PROPERTY_SEPADIRECTDEBIT_MANDATE_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getSepadirectdebitMandateId() {
    return sepadirectdebitMandateId;
  }


  @JsonProperty(JSON_PROPERTY_SEPADIRECTDEBIT_MANDATE_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSepadirectdebitMandateId(String sepadirectdebitMandateId) {
    this.sepadirectdebitMandateId = sepadirectdebitMandateId;
  }


  public ResponseAdditionalDataSepa sepadirectdebitSequenceType(String sepadirectdebitSequenceType) {
    this.sepadirectdebitSequenceType = sepadirectdebitSequenceType;
    return this;
  }

   /**
   * This field can take one of the following values: * OneOff: (OOFF) Direct debit instruction to initiate exactly one direct debit transaction.  * First: (FRST) Initial/first collection in a series of direct debit instructions. * Recurring: (RCUR) Direct debit instruction to carry out regular direct debit transactions initiated by the creditor. * Final: (FNAL) Last/final collection in a series of direct debit instructions.  Example: OOFF
   * @return sepadirectdebitSequenceType
  **/
  @ApiModelProperty(value = "This field can take one of the following values: * OneOff: (OOFF) Direct debit instruction to initiate exactly one direct debit transaction.  * First: (FRST) Initial/first collection in a series of direct debit instructions. * Recurring: (RCUR) Direct debit instruction to carry out regular direct debit transactions initiated by the creditor. * Final: (FNAL) Last/final collection in a series of direct debit instructions.  Example: OOFF")
  @JsonProperty(JSON_PROPERTY_SEPADIRECTDEBIT_SEQUENCE_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getSepadirectdebitSequenceType() {
    return sepadirectdebitSequenceType;
  }


  @JsonProperty(JSON_PROPERTY_SEPADIRECTDEBIT_SEQUENCE_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSepadirectdebitSequenceType(String sepadirectdebitSequenceType) {
    this.sepadirectdebitSequenceType = sepadirectdebitSequenceType;
  }


  /**
   * Return true if this ResponseAdditionalDataSepa object is equal to o.
   */
  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    ResponseAdditionalDataSepa responseAdditionalDataSepa = (ResponseAdditionalDataSepa) o;
    return Objects.equals(this.sepadirectdebitDateOfSignature, responseAdditionalDataSepa.sepadirectdebitDateOfSignature) &&
        Objects.equals(this.sepadirectdebitMandateId, responseAdditionalDataSepa.sepadirectdebitMandateId) &&
        Objects.equals(this.sepadirectdebitSequenceType, responseAdditionalDataSepa.sepadirectdebitSequenceType);
  }

  @Override
  public int hashCode() {
    return Objects.hash(sepadirectdebitDateOfSignature, sepadirectdebitMandateId, sepadirectdebitSequenceType);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class ResponseAdditionalDataSepa {\n");
    sb.append("    sepadirectdebitDateOfSignature: ").append(toIndentedString(sepadirectdebitDateOfSignature)).append("\n");
    sb.append("    sepadirectdebitMandateId: ").append(toIndentedString(sepadirectdebitMandateId)).append("\n");
    sb.append("    sepadirectdebitSequenceType: ").append(toIndentedString(sepadirectdebitSequenceType)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

/**
   * Create an instance of ResponseAdditionalDataSepa given an JSON string
   *
   * @param jsonString JSON string
   * @return An instance of ResponseAdditionalDataSepa
   * @throws JsonProcessingException if the JSON string is invalid with respect to ResponseAdditionalDataSepa
   */
  public static ResponseAdditionalDataSepa fromJson(String jsonString) throws JsonProcessingException {
    return JSON.getMapper().readValue(jsonString, ResponseAdditionalDataSepa.class);
  }
/**
  * Convert an instance of ResponseAdditionalDataSepa to an JSON string
  *
  * @return JSON string
  */
  public String toJson() throws JsonProcessingException {
    return JSON.getMapper().writeValueAsString(this);
  }
}

