/*
 * Hosted onboarding API
 * This API is used for the classic integration. If you are just starting your implementation, refer to our [new integration guide](https://docs.adyen.com/marketplaces-and-platforms) instead.  The Hosted onboarding API provides endpoints that you can use to generate links to Adyen-hosted pages, such as an [onboarding page](https://docs.adyen.com/marketplaces-and-platforms/classic/hosted-onboarding-page) or a [PCI compliance questionnaire](https://docs.adyen.com/marketplaces-and-platforms/classic/platforms-for-partners). You can provide these links to your account holders so that they can complete their onboarding.  ## Authentication Your Adyen contact will provide your API credential and an API key. To connect to the API, add an `X-API-Key` header with the API key as the value, for example:   ``` curl -H \"Content-Type: application/json\" \\ -H \"X-API-Key: YOUR_API_KEY\" \\ ... ```  Alternatively, you can use the username and password to connect to the API using basic authentication. For example:  ``` curl -U \"ws@MarketPlace.YOUR_PLATFORM_ACCOUNT\":\"YOUR_WS_PASSWORD\" \\ -H \"Content-Type: application/json\" \\ ... ``` When going live, you need to generate new web service user credentials to access the [live endpoints](https://docs.adyen.com/development-resources/live-endpoints).  ## Versioning The Hosted onboarding API supports [versioning](https://docs.adyen.com/development-resources/versioning) using a version suffix in the endpoint URL. This suffix has the following format: \"vXX\", where XX is the version number.  For example: ``` https://cal-test.adyen.com/cal/services/Hop/v6/getOnboardingUrl ```
 *
 * The version of the OpenAPI document: 6
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package com.adyen.model.marketpayhop;

import java.util.Objects;
import java.util.Arrays;
import java.util.Map;
import java.util.HashMap;
import com.adyen.model.marketpayhop.CollectInformation;
import com.adyen.model.marketpayhop.ShowPages;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.core.JsonProcessingException;


/**
 * GetOnboardingUrlRequest
 */
@JsonPropertyOrder({
  GetOnboardingUrlRequest.JSON_PROPERTY_ACCOUNT_HOLDER_CODE,
  GetOnboardingUrlRequest.JSON_PROPERTY_COLLECT_INFORMATION,
  GetOnboardingUrlRequest.JSON_PROPERTY_EDIT_MODE,
  GetOnboardingUrlRequest.JSON_PROPERTY_MOBILE_O_AUTH_CALLBACK_URL,
  GetOnboardingUrlRequest.JSON_PROPERTY_PLATFORM_NAME,
  GetOnboardingUrlRequest.JSON_PROPERTY_RETURN_URL,
  GetOnboardingUrlRequest.JSON_PROPERTY_SHOPPER_LOCALE,
  GetOnboardingUrlRequest.JSON_PROPERTY_SHOW_PAGES
})

public class GetOnboardingUrlRequest {
  public static final String JSON_PROPERTY_ACCOUNT_HOLDER_CODE = "accountHolderCode";
  private String accountHolderCode;

  public static final String JSON_PROPERTY_COLLECT_INFORMATION = "collectInformation";
  private CollectInformation collectInformation;

  public static final String JSON_PROPERTY_EDIT_MODE = "editMode";
  private Boolean editMode;

  public static final String JSON_PROPERTY_MOBILE_O_AUTH_CALLBACK_URL = "mobileOAuthCallbackUrl";
  private String mobileOAuthCallbackUrl;

  public static final String JSON_PROPERTY_PLATFORM_NAME = "platformName";
  private String platformName;

  public static final String JSON_PROPERTY_RETURN_URL = "returnUrl";
  private String returnUrl;

  public static final String JSON_PROPERTY_SHOPPER_LOCALE = "shopperLocale";
  private String shopperLocale;

  public static final String JSON_PROPERTY_SHOW_PAGES = "showPages";
  private ShowPages showPages;

  public GetOnboardingUrlRequest() { 
  }

  public GetOnboardingUrlRequest accountHolderCode(String accountHolderCode) {
    this.accountHolderCode = accountHolderCode;
    return this;
  }

   /**
   * The account holder code you provided when you created the account holder.
   * @return accountHolderCode
  **/
  @ApiModelProperty(required = true, value = "The account holder code you provided when you created the account holder.")
  @JsonProperty(JSON_PROPERTY_ACCOUNT_HOLDER_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getAccountHolderCode() {
    return accountHolderCode;
  }


  @JsonProperty(JSON_PROPERTY_ACCOUNT_HOLDER_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAccountHolderCode(String accountHolderCode) {
    this.accountHolderCode = accountHolderCode;
  }


  public GetOnboardingUrlRequest collectInformation(CollectInformation collectInformation) {
    this.collectInformation = collectInformation;
    return this;
  }

   /**
   * Get collectInformation
   * @return collectInformation
  **/
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_COLLECT_INFORMATION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public CollectInformation getCollectInformation() {
    return collectInformation;
  }


  @JsonProperty(JSON_PROPERTY_COLLECT_INFORMATION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCollectInformation(CollectInformation collectInformation) {
    this.collectInformation = collectInformation;
  }


  public GetOnboardingUrlRequest editMode(Boolean editMode) {
    this.editMode = editMode;
    return this;
  }

   /**
   * Indicates if editing checks is allowed even if all the checks have passed.
   * @return editMode
  **/
  @ApiModelProperty(value = "Indicates if editing checks is allowed even if all the checks have passed.")
  @JsonProperty(JSON_PROPERTY_EDIT_MODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getEditMode() {
    return editMode;
  }


  @JsonProperty(JSON_PROPERTY_EDIT_MODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setEditMode(Boolean editMode) {
    this.editMode = editMode;
  }


  public GetOnboardingUrlRequest mobileOAuthCallbackUrl(String mobileOAuthCallbackUrl) {
    this.mobileOAuthCallbackUrl = mobileOAuthCallbackUrl;
    return this;
  }

   /**
   * The URL to which the account holder is redirected after completing an OAuth authentication with a bank through Trustly/PayMyBank.
   * @return mobileOAuthCallbackUrl
  **/
  @ApiModelProperty(value = "The URL to which the account holder is redirected after completing an OAuth authentication with a bank through Trustly/PayMyBank.")
  @JsonProperty(JSON_PROPERTY_MOBILE_O_AUTH_CALLBACK_URL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getMobileOAuthCallbackUrl() {
    return mobileOAuthCallbackUrl;
  }


  @JsonProperty(JSON_PROPERTY_MOBILE_O_AUTH_CALLBACK_URL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setMobileOAuthCallbackUrl(String mobileOAuthCallbackUrl) {
    this.mobileOAuthCallbackUrl = mobileOAuthCallbackUrl;
  }


  public GetOnboardingUrlRequest platformName(String platformName) {
    this.platformName = platformName;
    return this;
  }

   /**
   * The platform name which will show up in the welcome page.
   * @return platformName
  **/
  @ApiModelProperty(value = "The platform name which will show up in the welcome page.")
  @JsonProperty(JSON_PROPERTY_PLATFORM_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getPlatformName() {
    return platformName;
  }


  @JsonProperty(JSON_PROPERTY_PLATFORM_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPlatformName(String platformName) {
    this.platformName = platformName;
  }


  public GetOnboardingUrlRequest returnUrl(String returnUrl) {
    this.returnUrl = returnUrl;
    return this;
  }

   /**
   * The URL where the account holder will be redirected back to after they complete the onboarding, or if their session times out. Maximum length of 500 characters. If you don&#39;t provide this, the account holder will be redirected back to the default return URL configured in your platform account.
   * @return returnUrl
  **/
  @ApiModelProperty(value = "The URL where the account holder will be redirected back to after they complete the onboarding, or if their session times out. Maximum length of 500 characters. If you don't provide this, the account holder will be redirected back to the default return URL configured in your platform account.")
  @JsonProperty(JSON_PROPERTY_RETURN_URL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getReturnUrl() {
    return returnUrl;
  }


  @JsonProperty(JSON_PROPERTY_RETURN_URL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setReturnUrl(String returnUrl) {
    this.returnUrl = returnUrl;
  }


  public GetOnboardingUrlRequest shopperLocale(String shopperLocale) {
    this.shopperLocale = shopperLocale;
    return this;
  }

   /**
   * The language to be used in the page, specified by a combination of a language and country code. For example, **pt-BR**.   If not specified in the request or if the language is not supported, the page uses the browser language. If the browser language is not supported, the page uses **en-US** by default.  For a list of supported languages, refer to [Change the page language](https://docs.adyen.com/marketplaces-and-platforms/classic/hosted-onboarding-page/customize-experience#change-page-language).
   * @return shopperLocale
  **/
  @ApiModelProperty(value = "The language to be used in the page, specified by a combination of a language and country code. For example, **pt-BR**.   If not specified in the request or if the language is not supported, the page uses the browser language. If the browser language is not supported, the page uses **en-US** by default.  For a list of supported languages, refer to [Change the page language](https://docs.adyen.com/marketplaces-and-platforms/classic/hosted-onboarding-page/customize-experience#change-page-language).")
  @JsonProperty(JSON_PROPERTY_SHOPPER_LOCALE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getShopperLocale() {
    return shopperLocale;
  }


  @JsonProperty(JSON_PROPERTY_SHOPPER_LOCALE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setShopperLocale(String shopperLocale) {
    this.shopperLocale = shopperLocale;
  }


  public GetOnboardingUrlRequest showPages(ShowPages showPages) {
    this.showPages = showPages;
    return this;
  }

   /**
   * Get showPages
   * @return showPages
  **/
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_SHOW_PAGES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public ShowPages getShowPages() {
    return showPages;
  }


  @JsonProperty(JSON_PROPERTY_SHOW_PAGES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setShowPages(ShowPages showPages) {
    this.showPages = showPages;
  }


  /**
   * Return true if this GetOnboardingUrlRequest object is equal to o.
   */
  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    GetOnboardingUrlRequest getOnboardingUrlRequest = (GetOnboardingUrlRequest) o;
    return Objects.equals(this.accountHolderCode, getOnboardingUrlRequest.accountHolderCode) &&
        Objects.equals(this.collectInformation, getOnboardingUrlRequest.collectInformation) &&
        Objects.equals(this.editMode, getOnboardingUrlRequest.editMode) &&
        Objects.equals(this.mobileOAuthCallbackUrl, getOnboardingUrlRequest.mobileOAuthCallbackUrl) &&
        Objects.equals(this.platformName, getOnboardingUrlRequest.platformName) &&
        Objects.equals(this.returnUrl, getOnboardingUrlRequest.returnUrl) &&
        Objects.equals(this.shopperLocale, getOnboardingUrlRequest.shopperLocale) &&
        Objects.equals(this.showPages, getOnboardingUrlRequest.showPages);
  }

  @Override
  public int hashCode() {
    return Objects.hash(accountHolderCode, collectInformation, editMode, mobileOAuthCallbackUrl, platformName, returnUrl, shopperLocale, showPages);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class GetOnboardingUrlRequest {\n");
    sb.append("    accountHolderCode: ").append(toIndentedString(accountHolderCode)).append("\n");
    sb.append("    collectInformation: ").append(toIndentedString(collectInformation)).append("\n");
    sb.append("    editMode: ").append(toIndentedString(editMode)).append("\n");
    sb.append("    mobileOAuthCallbackUrl: ").append(toIndentedString(mobileOAuthCallbackUrl)).append("\n");
    sb.append("    platformName: ").append(toIndentedString(platformName)).append("\n");
    sb.append("    returnUrl: ").append(toIndentedString(returnUrl)).append("\n");
    sb.append("    shopperLocale: ").append(toIndentedString(shopperLocale)).append("\n");
    sb.append("    showPages: ").append(toIndentedString(showPages)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

/**
   * Create an instance of GetOnboardingUrlRequest given an JSON string
   *
   * @param jsonString JSON string
   * @return An instance of GetOnboardingUrlRequest
   * @throws JsonProcessingException if the JSON string is invalid with respect to GetOnboardingUrlRequest
   */
  public static GetOnboardingUrlRequest fromJson(String jsonString) throws JsonProcessingException {
    return JSON.getMapper().readValue(jsonString, GetOnboardingUrlRequest.class);
  }
/**
  * Convert an instance of GetOnboardingUrlRequest to an JSON string
  *
  * @return JSON string
  */
  public String toJson() throws JsonProcessingException {
    return JSON.getMapper().writeValueAsString(this);
  }
}

