/*
 * Management API
 *
 * The version of the OpenAPI document: 1
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package com.adyen.model.management;

import java.util.Objects;
import java.util.Arrays;
import java.util.Map;
import java.util.HashMap;
import com.adyen.model.management.AdditionalCommission;
import com.adyen.model.management.Commission;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.core.JsonProcessingException;


/**
 * SplitConfigurationLogic
 */
@JsonPropertyOrder({
  SplitConfigurationLogic.JSON_PROPERTY_ADDITIONAL_COMMISSION,
  SplitConfigurationLogic.JSON_PROPERTY_CHARGEBACK,
  SplitConfigurationLogic.JSON_PROPERTY_COMMISSION,
  SplitConfigurationLogic.JSON_PROPERTY_PAYMENT_FEE,
  SplitConfigurationLogic.JSON_PROPERTY_REMAINDER,
  SplitConfigurationLogic.JSON_PROPERTY_SPLIT_LOGIC_ID,
  SplitConfigurationLogic.JSON_PROPERTY_SURCHARGE,
  SplitConfigurationLogic.JSON_PROPERTY_TIP
})

public class SplitConfigurationLogic {
  public static final String JSON_PROPERTY_ADDITIONAL_COMMISSION = "additionalCommission";
  private AdditionalCommission additionalCommission;

  /**
   * Specifies the logic to apply when booking the chargeback amount.  Possible values: **deductFromLiableAccount**, **deductFromOneBalanceAccount**, **deductAccordingToSplitRatio**.
   */
  public enum ChargebackEnum {
    DEDUCTFROMLIABLEACCOUNT("deductFromLiableAccount"),
    
    DEDUCTFROMONEBALANCEACCOUNT("deductFromOneBalanceAccount"),
    
    DEDUCTACCORDINGTOSPLITRATIO("deductAccordingToSplitRatio");

    private String value;

    ChargebackEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static ChargebackEnum fromValue(String value) {
      for (ChargebackEnum b : ChargebackEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_CHARGEBACK = "chargeback";
  private ChargebackEnum chargeback;

  public static final String JSON_PROPERTY_COMMISSION = "commission";
  private Commission commission;

  /**
   * Specifies the logic to apply when booking the transaction fees.  Possible values: **deductFromLiableAccount**, **deductFromOneBalanceAccount**.
   */
  public enum PaymentFeeEnum {
    DEDUCTFROMLIABLEACCOUNT("deductFromLiableAccount"),
    
    DEDUCTFROMONEBALANCEACCOUNT("deductFromOneBalanceAccount");

    private String value;

    PaymentFeeEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static PaymentFeeEnum fromValue(String value) {
      for (PaymentFeeEnum b : PaymentFeeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_PAYMENT_FEE = "paymentFee";
  private PaymentFeeEnum paymentFee;

  /**
   * Specifies the logic to apply when booking the amount left over after currency conversion.  Possible values: **addToLiableAccount**, **addToOneBalanceAccount**.
   */
  public enum RemainderEnum {
    ADDTOLIABLEACCOUNT("addToLiableAccount"),
    
    ADDTOONEBALANCEACCOUNT("addToOneBalanceAccount");

    private String value;

    RemainderEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static RemainderEnum fromValue(String value) {
      for (RemainderEnum b : RemainderEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_REMAINDER = "remainder";
  private RemainderEnum remainder;

  public static final String JSON_PROPERTY_SPLIT_LOGIC_ID = "splitLogicId";
  private String splitLogicId;

  /**
   * Specifies the logic to apply when booking the surcharge amount.  Possible values: **addToLiableAccount**, **addToOneBalanceAccount**
   */
  public enum SurchargeEnum {
    ADDTOLIABLEACCOUNT("addToLiableAccount"),
    
    ADDTOONEBALANCEACCOUNT("addToOneBalanceAccount");

    private String value;

    SurchargeEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static SurchargeEnum fromValue(String value) {
      for (SurchargeEnum b : SurchargeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_SURCHARGE = "surcharge";
  private SurchargeEnum surcharge;

  /**
   * Specifies the logic to apply when booking tips (gratuity).  Possible values: **addToLiableAccount**, **addToOneBalanceAccount**.
   */
  public enum TipEnum {
    ADDTOLIABLEACCOUNT("addToLiableAccount"),
    
    ADDTOONEBALANCEACCOUNT("addToOneBalanceAccount");

    private String value;

    TipEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static TipEnum fromValue(String value) {
      for (TipEnum b : TipEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_TIP = "tip";
  private TipEnum tip;

  public SplitConfigurationLogic() { 
  }

  public SplitConfigurationLogic additionalCommission(AdditionalCommission additionalCommission) {
    this.additionalCommission = additionalCommission;
    return this;
  }

   /**
   * Get additionalCommission
   * @return additionalCommission
  **/
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_ADDITIONAL_COMMISSION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public AdditionalCommission getAdditionalCommission() {
    return additionalCommission;
  }


  @JsonProperty(JSON_PROPERTY_ADDITIONAL_COMMISSION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAdditionalCommission(AdditionalCommission additionalCommission) {
    this.additionalCommission = additionalCommission;
  }


  public SplitConfigurationLogic chargeback(ChargebackEnum chargeback) {
    this.chargeback = chargeback;
    return this;
  }

   /**
   * Specifies the logic to apply when booking the chargeback amount.  Possible values: **deductFromLiableAccount**, **deductFromOneBalanceAccount**, **deductAccordingToSplitRatio**.
   * @return chargeback
  **/
  @ApiModelProperty(value = "Specifies the logic to apply when booking the chargeback amount.  Possible values: **deductFromLiableAccount**, **deductFromOneBalanceAccount**, **deductAccordingToSplitRatio**.")
  @JsonProperty(JSON_PROPERTY_CHARGEBACK)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public ChargebackEnum getChargeback() {
    return chargeback;
  }


  @JsonProperty(JSON_PROPERTY_CHARGEBACK)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setChargeback(ChargebackEnum chargeback) {
    this.chargeback = chargeback;
  }


  public SplitConfigurationLogic commission(Commission commission) {
    this.commission = commission;
    return this;
  }

   /**
   * Get commission
   * @return commission
  **/
  @ApiModelProperty(required = true, value = "")
  @JsonProperty(JSON_PROPERTY_COMMISSION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Commission getCommission() {
    return commission;
  }


  @JsonProperty(JSON_PROPERTY_COMMISSION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCommission(Commission commission) {
    this.commission = commission;
  }


  public SplitConfigurationLogic paymentFee(PaymentFeeEnum paymentFee) {
    this.paymentFee = paymentFee;
    return this;
  }

   /**
   * Specifies the logic to apply when booking the transaction fees.  Possible values: **deductFromLiableAccount**, **deductFromOneBalanceAccount**.
   * @return paymentFee
  **/
  @ApiModelProperty(required = true, value = "Specifies the logic to apply when booking the transaction fees.  Possible values: **deductFromLiableAccount**, **deductFromOneBalanceAccount**.")
  @JsonProperty(JSON_PROPERTY_PAYMENT_FEE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public PaymentFeeEnum getPaymentFee() {
    return paymentFee;
  }


  @JsonProperty(JSON_PROPERTY_PAYMENT_FEE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPaymentFee(PaymentFeeEnum paymentFee) {
    this.paymentFee = paymentFee;
  }


  public SplitConfigurationLogic remainder(RemainderEnum remainder) {
    this.remainder = remainder;
    return this;
  }

   /**
   * Specifies the logic to apply when booking the amount left over after currency conversion.  Possible values: **addToLiableAccount**, **addToOneBalanceAccount**.
   * @return remainder
  **/
  @ApiModelProperty(value = "Specifies the logic to apply when booking the amount left over after currency conversion.  Possible values: **addToLiableAccount**, **addToOneBalanceAccount**.")
  @JsonProperty(JSON_PROPERTY_REMAINDER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public RemainderEnum getRemainder() {
    return remainder;
  }


  @JsonProperty(JSON_PROPERTY_REMAINDER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setRemainder(RemainderEnum remainder) {
    this.remainder = remainder;
  }


  public SplitConfigurationLogic splitLogicId(String splitLogicId) {
    this.splitLogicId = splitLogicId;
    return this;
  }

   /**
   * Unique identifier of the split logic that is applied when the split configuration conditions are met.
   * @return splitLogicId
  **/
  @ApiModelProperty(value = "Unique identifier of the split logic that is applied when the split configuration conditions are met.")
  @JsonProperty(JSON_PROPERTY_SPLIT_LOGIC_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getSplitLogicId() {
    return splitLogicId;
  }


  @JsonProperty(JSON_PROPERTY_SPLIT_LOGIC_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSplitLogicId(String splitLogicId) {
    this.splitLogicId = splitLogicId;
  }


  public SplitConfigurationLogic surcharge(SurchargeEnum surcharge) {
    this.surcharge = surcharge;
    return this;
  }

   /**
   * Specifies the logic to apply when booking the surcharge amount.  Possible values: **addToLiableAccount**, **addToOneBalanceAccount**
   * @return surcharge
  **/
  @ApiModelProperty(value = "Specifies the logic to apply when booking the surcharge amount.  Possible values: **addToLiableAccount**, **addToOneBalanceAccount**")
  @JsonProperty(JSON_PROPERTY_SURCHARGE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public SurchargeEnum getSurcharge() {
    return surcharge;
  }


  @JsonProperty(JSON_PROPERTY_SURCHARGE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSurcharge(SurchargeEnum surcharge) {
    this.surcharge = surcharge;
  }


  public SplitConfigurationLogic tip(TipEnum tip) {
    this.tip = tip;
    return this;
  }

   /**
   * Specifies the logic to apply when booking tips (gratuity).  Possible values: **addToLiableAccount**, **addToOneBalanceAccount**.
   * @return tip
  **/
  @ApiModelProperty(value = "Specifies the logic to apply when booking tips (gratuity).  Possible values: **addToLiableAccount**, **addToOneBalanceAccount**.")
  @JsonProperty(JSON_PROPERTY_TIP)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public TipEnum getTip() {
    return tip;
  }


  @JsonProperty(JSON_PROPERTY_TIP)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTip(TipEnum tip) {
    this.tip = tip;
  }


  /**
   * Return true if this SplitConfigurationLogic object is equal to o.
   */
  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    SplitConfigurationLogic splitConfigurationLogic = (SplitConfigurationLogic) o;
    return Objects.equals(this.additionalCommission, splitConfigurationLogic.additionalCommission) &&
        Objects.equals(this.chargeback, splitConfigurationLogic.chargeback) &&
        Objects.equals(this.commission, splitConfigurationLogic.commission) &&
        Objects.equals(this.paymentFee, splitConfigurationLogic.paymentFee) &&
        Objects.equals(this.remainder, splitConfigurationLogic.remainder) &&
        Objects.equals(this.splitLogicId, splitConfigurationLogic.splitLogicId) &&
        Objects.equals(this.surcharge, splitConfigurationLogic.surcharge) &&
        Objects.equals(this.tip, splitConfigurationLogic.tip);
  }

  @Override
  public int hashCode() {
    return Objects.hash(additionalCommission, chargeback, commission, paymentFee, remainder, splitLogicId, surcharge, tip);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class SplitConfigurationLogic {\n");
    sb.append("    additionalCommission: ").append(toIndentedString(additionalCommission)).append("\n");
    sb.append("    chargeback: ").append(toIndentedString(chargeback)).append("\n");
    sb.append("    commission: ").append(toIndentedString(commission)).append("\n");
    sb.append("    paymentFee: ").append(toIndentedString(paymentFee)).append("\n");
    sb.append("    remainder: ").append(toIndentedString(remainder)).append("\n");
    sb.append("    splitLogicId: ").append(toIndentedString(splitLogicId)).append("\n");
    sb.append("    surcharge: ").append(toIndentedString(surcharge)).append("\n");
    sb.append("    tip: ").append(toIndentedString(tip)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

/**
   * Create an instance of SplitConfigurationLogic given an JSON string
   *
   * @param jsonString JSON string
   * @return An instance of SplitConfigurationLogic
   * @throws JsonProcessingException if the JSON string is invalid with respect to SplitConfigurationLogic
   */
  public static SplitConfigurationLogic fromJson(String jsonString) throws JsonProcessingException {
    return JSON.getMapper().readValue(jsonString, SplitConfigurationLogic.class);
  }
/**
  * Convert an instance of SplitConfigurationLogic to an JSON string
  *
  * @return JSON string
  */
  public String toJson() throws JsonProcessingException {
    return JSON.getMapper().writeValueAsString(this);
  }
}

