/*
 * Disputes API
 * You can use the [Disputes API](https://docs.adyen.com/risk-management/disputes-api) to automate the dispute handling process so that you can respond to disputes and chargebacks as soon as they are initiated. The Disputes API lets you retrieve defense reasons, supply and delete defense documents, and accept or defend disputes.  ## Authentication Each request to the Disputes API must be signed with an API key. For this, obtain an API Key from your Customer Area, as described in [How to get the API key](https://docs.adyen.com/development-resources/api-credentials#generate-api-key). Then set this key to the `X-API-Key` header value, for example:  ``` curl -H \"Content-Type: application/json\" \\ -H \"X-API-Key: Your_API_key\" \\ ... ``` Note that when going live, you need to generate new web service user credentials to access the [live endpoints](https://docs.adyen.com/development-resources/live-endpoints).  ## Versioning Disputes API supports [versioning](https://docs.adyen.com/development-resources/versioning) using a version suffix in the endpoint URL. This suffix has the following format: \"vXX\", where XX is the version number.  For example: ``` https://ca-test.adyen.com/ca/services/DisputeService/v30/defendDispute ```
 *
 * The version of the OpenAPI document: 30
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package com.adyen.model.disputes;

import java.util.Objects;
import java.util.Arrays;
import java.util.Map;
import java.util.HashMap;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.core.JsonProcessingException;


/**
 * DefenseDocumentType
 */
@JsonPropertyOrder({
  DefenseDocumentType.JSON_PROPERTY_AVAILABLE,
  DefenseDocumentType.JSON_PROPERTY_DEFENSE_DOCUMENT_TYPE_CODE,
  DefenseDocumentType.JSON_PROPERTY_REQUIREMENT_LEVEL
})

public class DefenseDocumentType {
  public static final String JSON_PROPERTY_AVAILABLE = "available";
  private Boolean available;

  public static final String JSON_PROPERTY_DEFENSE_DOCUMENT_TYPE_CODE = "defenseDocumentTypeCode";
  private String defenseDocumentTypeCode;

  public static final String JSON_PROPERTY_REQUIREMENT_LEVEL = "requirementLevel";
  private String requirementLevel;

  public DefenseDocumentType() { 
  }

  public DefenseDocumentType available(Boolean available) {
    this.available = available;
    return this;
  }

   /**
   * When **true**, you&#39;ve successfully uploaded this type of defense document. When **false**, you haven&#39;t uploaded this defense document type.
   * @return available
  **/
  @ApiModelProperty(required = true, value = "When **true**, you've successfully uploaded this type of defense document. When **false**, you haven't uploaded this defense document type.")
  @JsonProperty(JSON_PROPERTY_AVAILABLE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getAvailable() {
    return available;
  }


  @JsonProperty(JSON_PROPERTY_AVAILABLE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAvailable(Boolean available) {
    this.available = available;
  }


  public DefenseDocumentType defenseDocumentTypeCode(String defenseDocumentTypeCode) {
    this.defenseDocumentTypeCode = defenseDocumentTypeCode;
    return this;
  }

   /**
   * The document type code of the defense document.
   * @return defenseDocumentTypeCode
  **/
  @ApiModelProperty(required = true, value = "The document type code of the defense document.")
  @JsonProperty(JSON_PROPERTY_DEFENSE_DOCUMENT_TYPE_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getDefenseDocumentTypeCode() {
    return defenseDocumentTypeCode;
  }


  @JsonProperty(JSON_PROPERTY_DEFENSE_DOCUMENT_TYPE_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDefenseDocumentTypeCode(String defenseDocumentTypeCode) {
    this.defenseDocumentTypeCode = defenseDocumentTypeCode;
  }


  public DefenseDocumentType requirementLevel(String requirementLevel) {
    this.requirementLevel = requirementLevel;
    return this;
  }

   /**
   * Indicates to what extent the defense document is required in the defense process.  Possible values:   * **Required**: You must supply the document.   * **OneOrMore**: You must supply at least one of the documents with this label.  * **Optional**: You can choose to supply the document.  * **AlternativeRequired**: You must supply a generic defense document. To enable this functionality, contact our Support Team. When enabled, you can supply a generic defense document for all schemes.
   * @return requirementLevel
  **/
  @ApiModelProperty(required = true, value = "Indicates to what extent the defense document is required in the defense process.  Possible values:   * **Required**: You must supply the document.   * **OneOrMore**: You must supply at least one of the documents with this label.  * **Optional**: You can choose to supply the document.  * **AlternativeRequired**: You must supply a generic defense document. To enable this functionality, contact our Support Team. When enabled, you can supply a generic defense document for all schemes.")
  @JsonProperty(JSON_PROPERTY_REQUIREMENT_LEVEL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getRequirementLevel() {
    return requirementLevel;
  }


  @JsonProperty(JSON_PROPERTY_REQUIREMENT_LEVEL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setRequirementLevel(String requirementLevel) {
    this.requirementLevel = requirementLevel;
  }


  /**
   * Return true if this DefenseDocumentType object is equal to o.
   */
  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    DefenseDocumentType defenseDocumentType = (DefenseDocumentType) o;
    return Objects.equals(this.available, defenseDocumentType.available) &&
        Objects.equals(this.defenseDocumentTypeCode, defenseDocumentType.defenseDocumentTypeCode) &&
        Objects.equals(this.requirementLevel, defenseDocumentType.requirementLevel);
  }

  @Override
  public int hashCode() {
    return Objects.hash(available, defenseDocumentTypeCode, requirementLevel);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class DefenseDocumentType {\n");
    sb.append("    available: ").append(toIndentedString(available)).append("\n");
    sb.append("    defenseDocumentTypeCode: ").append(toIndentedString(defenseDocumentTypeCode)).append("\n");
    sb.append("    requirementLevel: ").append(toIndentedString(requirementLevel)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

/**
   * Create an instance of DefenseDocumentType given an JSON string
   *
   * @param jsonString JSON string
   * @return An instance of DefenseDocumentType
   * @throws JsonProcessingException if the JSON string is invalid with respect to DefenseDocumentType
   */
  public static DefenseDocumentType fromJson(String jsonString) throws JsonProcessingException {
    return JSON.getMapper().readValue(jsonString, DefenseDocumentType.class);
  }
/**
  * Convert an instance of DefenseDocumentType to an JSON string
  *
  * @return JSON string
  */
  public String toJson() throws JsonProcessingException {
    return JSON.getMapper().writeValueAsString(this);
  }
}

