/*
 * Configuration API
 *
 * The version of the OpenAPI document: 2
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package com.adyen.model.balanceplatform;

import java.util.Objects;
import java.util.Arrays;
import java.util.Map;
import java.util.HashMap;
import com.adyen.model.balanceplatform.Amount;
import com.adyen.model.balanceplatform.Fee;
import com.adyen.model.balanceplatform.Repayment;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.core.JsonProcessingException;


/**
 * GrantOffer
 */
@JsonPropertyOrder({
  GrantOffer.JSON_PROPERTY_ACCOUNT_HOLDER_ID,
  GrantOffer.JSON_PROPERTY_AMOUNT,
  GrantOffer.JSON_PROPERTY_CONTRACT_TYPE,
  GrantOffer.JSON_PROPERTY_EXPIRES_AT,
  GrantOffer.JSON_PROPERTY_FEE,
  GrantOffer.JSON_PROPERTY_ID,
  GrantOffer.JSON_PROPERTY_REPAYMENT,
  GrantOffer.JSON_PROPERTY_STARTS_AT
})

public class GrantOffer {
  public static final String JSON_PROPERTY_ACCOUNT_HOLDER_ID = "accountHolderId";
  private String accountHolderId;

  public static final String JSON_PROPERTY_AMOUNT = "amount";
  private Amount amount;

  /**
   * The contract type of the grant offer. Possible value: **cashAdvance**, **loan**.
   */
  public enum ContractTypeEnum {
    CASHADVANCE("cashAdvance"),
    
    LOAN("loan");

    private String value;

    ContractTypeEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static ContractTypeEnum fromValue(String value) {
      for (ContractTypeEnum b : ContractTypeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_CONTRACT_TYPE = "contractType";
  private ContractTypeEnum contractType;

  public static final String JSON_PROPERTY_EXPIRES_AT = "expiresAt";
  private Object expiresAt;

  public static final String JSON_PROPERTY_FEE = "fee";
  private Fee fee;

  public static final String JSON_PROPERTY_ID = "id";
  private String id;

  public static final String JSON_PROPERTY_REPAYMENT = "repayment";
  private Repayment repayment;

  public static final String JSON_PROPERTY_STARTS_AT = "startsAt";
  private Object startsAt;

  public GrantOffer() { 
  }

  public GrantOffer accountHolderId(String accountHolderId) {
    this.accountHolderId = accountHolderId;
    return this;
  }

   /**
   * The identifier of the account holder to which the grant is offered.
   * @return accountHolderId
  **/
  @ApiModelProperty(required = true, value = "The identifier of the account holder to which the grant is offered.")
  @JsonProperty(JSON_PROPERTY_ACCOUNT_HOLDER_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getAccountHolderId() {
    return accountHolderId;
  }


  @JsonProperty(JSON_PROPERTY_ACCOUNT_HOLDER_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAccountHolderId(String accountHolderId) {
    this.accountHolderId = accountHolderId;
  }


  public GrantOffer amount(Amount amount) {
    this.amount = amount;
    return this;
  }

   /**
   * Get amount
   * @return amount
  **/
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Amount getAmount() {
    return amount;
  }


  @JsonProperty(JSON_PROPERTY_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAmount(Amount amount) {
    this.amount = amount;
  }


  public GrantOffer contractType(ContractTypeEnum contractType) {
    this.contractType = contractType;
    return this;
  }

   /**
   * The contract type of the grant offer. Possible value: **cashAdvance**, **loan**.
   * @return contractType
  **/
  @ApiModelProperty(value = "The contract type of the grant offer. Possible value: **cashAdvance**, **loan**.")
  @JsonProperty(JSON_PROPERTY_CONTRACT_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public ContractTypeEnum getContractType() {
    return contractType;
  }


  @JsonProperty(JSON_PROPERTY_CONTRACT_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setContractType(ContractTypeEnum contractType) {
    this.contractType = contractType;
  }


  public GrantOffer expiresAt(Object expiresAt) {
    this.expiresAt = expiresAt;
    return this;
  }

   /**
   * Get expiresAt
   * @return expiresAt
  **/
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_EXPIRES_AT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Object getExpiresAt() {
    return expiresAt;
  }


  @JsonProperty(JSON_PROPERTY_EXPIRES_AT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setExpiresAt(Object expiresAt) {
    this.expiresAt = expiresAt;
  }


  public GrantOffer fee(Fee fee) {
    this.fee = fee;
    return this;
  }

   /**
   * Get fee
   * @return fee
  **/
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_FEE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Fee getFee() {
    return fee;
  }


  @JsonProperty(JSON_PROPERTY_FEE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setFee(Fee fee) {
    this.fee = fee;
  }


  public GrantOffer id(String id) {
    this.id = id;
    return this;
  }

   /**
   * The unique identifier of the grant offer.
   * @return id
  **/
  @ApiModelProperty(value = "The unique identifier of the grant offer.")
  @JsonProperty(JSON_PROPERTY_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getId() {
    return id;
  }


  @JsonProperty(JSON_PROPERTY_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setId(String id) {
    this.id = id;
  }


  public GrantOffer repayment(Repayment repayment) {
    this.repayment = repayment;
    return this;
  }

   /**
   * Get repayment
   * @return repayment
  **/
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_REPAYMENT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Repayment getRepayment() {
    return repayment;
  }


  @JsonProperty(JSON_PROPERTY_REPAYMENT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setRepayment(Repayment repayment) {
    this.repayment = repayment;
  }


  public GrantOffer startsAt(Object startsAt) {
    this.startsAt = startsAt;
    return this;
  }

   /**
   * Get startsAt
   * @return startsAt
  **/
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_STARTS_AT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Object getStartsAt() {
    return startsAt;
  }


  @JsonProperty(JSON_PROPERTY_STARTS_AT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setStartsAt(Object startsAt) {
    this.startsAt = startsAt;
  }


  /**
   * Return true if this GrantOffer object is equal to o.
   */
  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    GrantOffer grantOffer = (GrantOffer) o;
    return Objects.equals(this.accountHolderId, grantOffer.accountHolderId) &&
        Objects.equals(this.amount, grantOffer.amount) &&
        Objects.equals(this.contractType, grantOffer.contractType) &&
        Objects.equals(this.expiresAt, grantOffer.expiresAt) &&
        Objects.equals(this.fee, grantOffer.fee) &&
        Objects.equals(this.id, grantOffer.id) &&
        Objects.equals(this.repayment, grantOffer.repayment) &&
        Objects.equals(this.startsAt, grantOffer.startsAt);
  }

  @Override
  public int hashCode() {
    return Objects.hash(accountHolderId, amount, contractType, expiresAt, fee, id, repayment, startsAt);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class GrantOffer {\n");
    sb.append("    accountHolderId: ").append(toIndentedString(accountHolderId)).append("\n");
    sb.append("    amount: ").append(toIndentedString(amount)).append("\n");
    sb.append("    contractType: ").append(toIndentedString(contractType)).append("\n");
    sb.append("    expiresAt: ").append(toIndentedString(expiresAt)).append("\n");
    sb.append("    fee: ").append(toIndentedString(fee)).append("\n");
    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    repayment: ").append(toIndentedString(repayment)).append("\n");
    sb.append("    startsAt: ").append(toIndentedString(startsAt)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

/**
   * Create an instance of GrantOffer given an JSON string
   *
   * @param jsonString JSON string
   * @return An instance of GrantOffer
   * @throws JsonProcessingException if the JSON string is invalid with respect to GrantOffer
   */
  public static GrantOffer fromJson(String jsonString) throws JsonProcessingException {
    return JSON.getMapper().readValue(jsonString, GrantOffer.class);
  }
/**
  * Convert an instance of GrantOffer to an JSON string
  *
  * @return JSON string
  */
  public String toJson() throws JsonProcessingException {
    return JSON.getMapper().writeValueAsString(this);
  }
}

