/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.configurationwebhooks;

import com.adyen.model.configurationwebhooks.Balance;
import com.adyen.model.configurationwebhooks.JSON;
import com.adyen.model.configurationwebhooks.PaymentInstrumentReference;
import com.adyen.model.configurationwebhooks.SweepConfiguration;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonProcessingException;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@JsonPropertyOrder(value={"accountHolderId", "balances", "defaultCurrencyCode", "description", "id", "metadata", "paymentInstruments", "reference", "status", "sweepConfigurations", "timeZone"})
public class BalanceAccount {
    public static final String JSON_PROPERTY_ACCOUNT_HOLDER_ID = "accountHolderId";
    private String accountHolderId;
    public static final String JSON_PROPERTY_BALANCES = "balances";
    private List<Balance> balances = null;
    public static final String JSON_PROPERTY_DEFAULT_CURRENCY_CODE = "defaultCurrencyCode";
    private String defaultCurrencyCode;
    public static final String JSON_PROPERTY_DESCRIPTION = "description";
    private String description;
    public static final String JSON_PROPERTY_ID = "id";
    private String id;
    public static final String JSON_PROPERTY_METADATA = "metadata";
    private Map<String, String> metadata = null;
    public static final String JSON_PROPERTY_PAYMENT_INSTRUMENTS = "paymentInstruments";
    private List<PaymentInstrumentReference> paymentInstruments = null;
    public static final String JSON_PROPERTY_REFERENCE = "reference";
    private String reference;
    public static final String JSON_PROPERTY_STATUS = "status";
    private StatusEnum status;
    public static final String JSON_PROPERTY_SWEEP_CONFIGURATIONS = "sweepConfigurations";
    private Map<String, SweepConfiguration> sweepConfigurations = null;
    public static final String JSON_PROPERTY_TIME_ZONE = "timeZone";
    private String timeZone;

    public BalanceAccount accountHolderId(String accountHolderId) {
        this.accountHolderId = accountHolderId;
        return this;
    }

    @ApiModelProperty(required=true, value="The unique identifier of the [account holder](https://docs.adyen.com/api-explorer/#/balanceplatform/latest/post/accountHolders__resParam_id) associated with the balance account.")
    @JsonProperty(value="accountHolderId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getAccountHolderId() {
        return this.accountHolderId;
    }

    @JsonProperty(value="accountHolderId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAccountHolderId(String accountHolderId) {
        this.accountHolderId = accountHolderId;
    }

    public BalanceAccount balances(List<Balance> balances) {
        this.balances = balances;
        return this;
    }

    public BalanceAccount addBalancesItem(Balance balancesItem) {
        if (this.balances == null) {
            this.balances = new ArrayList<Balance>();
        }
        this.balances.add(balancesItem);
        return this;
    }

    @ApiModelProperty(value="List of balances with the amount and currency.")
    @JsonProperty(value="balances")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<Balance> getBalances() {
        return this.balances;
    }

    @JsonProperty(value="balances")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setBalances(List<Balance> balances) {
        this.balances = balances;
    }

    public BalanceAccount defaultCurrencyCode(String defaultCurrencyCode) {
        this.defaultCurrencyCode = defaultCurrencyCode;
        return this;
    }

    @ApiModelProperty(value="The default three-character [ISO currency code](https://docs.adyen.com/development-resources/currency-codes) of the balance account. The default value is **EUR**.")
    @JsonProperty(value="defaultCurrencyCode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getDefaultCurrencyCode() {
        return this.defaultCurrencyCode;
    }

    @JsonProperty(value="defaultCurrencyCode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDefaultCurrencyCode(String defaultCurrencyCode) {
        this.defaultCurrencyCode = defaultCurrencyCode;
    }

    public BalanceAccount description(String description) {
        this.description = description;
        return this;
    }

    @ApiModelProperty(value="A human-readable description of the balance account, maximum 300 characters. You can use this parameter to distinguish between multiple balance accounts under an account holder.")
    @JsonProperty(value="description")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getDescription() {
        return this.description;
    }

    @JsonProperty(value="description")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDescription(String description) {
        this.description = description;
    }

    public BalanceAccount id(String id) {
        this.id = id;
        return this;
    }

    @ApiModelProperty(required=true, value="The unique identifier of the balance account.")
    @JsonProperty(value="id")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getId() {
        return this.id;
    }

    @JsonProperty(value="id")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setId(String id) {
        this.id = id;
    }

    public BalanceAccount metadata(Map<String, String> metadata) {
        this.metadata = metadata;
        return this;
    }

    public BalanceAccount putMetadataItem(String key, String metadataItem) {
        if (this.metadata == null) {
            this.metadata = new HashMap<String, String>();
        }
        this.metadata.put(key, metadataItem);
        return this;
    }

    @ApiModelProperty(value="A set of key and value pairs for general use by the merchant. The keys do not have specific names and may be used for storing miscellaneous data as desired. > Note that during an update of metadata, the omission of existing key-value pairs will result in the deletion of those key-value pairs.")
    @JsonProperty(value="metadata")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    @JsonProperty(value="metadata")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setMetadata(Map<String, String> metadata) {
        this.metadata = metadata;
    }

    public BalanceAccount paymentInstruments(List<PaymentInstrumentReference> paymentInstruments) {
        this.paymentInstruments = paymentInstruments;
        return this;
    }

    public BalanceAccount addPaymentInstrumentsItem(PaymentInstrumentReference paymentInstrumentsItem) {
        if (this.paymentInstruments == null) {
            this.paymentInstruments = new ArrayList<PaymentInstrumentReference>();
        }
        this.paymentInstruments.add(paymentInstrumentsItem);
        return this;
    }

    @ApiModelProperty(value="List of [payment instruments](https://docs.adyen.com/api-explorer/#/balanceplatform/latest/post/paymentInstruments) associated with the balance account.")
    @JsonProperty(value="paymentInstruments")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<PaymentInstrumentReference> getPaymentInstruments() {
        return this.paymentInstruments;
    }

    @JsonProperty(value="paymentInstruments")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPaymentInstruments(List<PaymentInstrumentReference> paymentInstruments) {
        this.paymentInstruments = paymentInstruments;
    }

    public BalanceAccount reference(String reference) {
        this.reference = reference;
        return this;
    }

    @ApiModelProperty(value="Your reference for the balance account, maximum 150 characters.")
    @JsonProperty(value="reference")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getReference() {
        return this.reference;
    }

    @JsonProperty(value="reference")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setReference(String reference) {
        this.reference = reference;
    }

    public BalanceAccount status(StatusEnum status) {
        this.status = status;
        return this;
    }

    @ApiModelProperty(value="The status of the balance account, set to **Active** by default.  ")
    @JsonProperty(value="status")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public StatusEnum getStatus() {
        return this.status;
    }

    @JsonProperty(value="status")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setStatus(StatusEnum status) {
        this.status = status;
    }

    public BalanceAccount sweepConfigurations(Map<String, SweepConfiguration> sweepConfigurations) {
        this.sweepConfigurations = sweepConfigurations;
        return this;
    }

    public BalanceAccount putSweepConfigurationsItem(String key, SweepConfiguration sweepConfigurationsItem) {
        if (this.sweepConfigurations == null) {
            this.sweepConfigurations = new HashMap<String, SweepConfiguration>();
        }
        this.sweepConfigurations.put(key, sweepConfigurationsItem);
        return this;
    }

    @ApiModelProperty(value="Contains key-value pairs that specify configurations for balance sweeps per currency code. A sweep pulls in or pushes out funds based on a defined schedule, amount, and a source (for pulling funds) or a destination (for pushing funds).  The key must be a three-character [ISO currency code](https://docs.adyen.com/development-resources/currency-codes) in uppercase. For example, **EUR**. The value must be an object containing the sweep configuration.")
    @JsonProperty(value="sweepConfigurations")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Map<String, SweepConfiguration> getSweepConfigurations() {
        return this.sweepConfigurations;
    }

    @JsonProperty(value="sweepConfigurations")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSweepConfigurations(Map<String, SweepConfiguration> sweepConfigurations) {
        this.sweepConfigurations = sweepConfigurations;
    }

    public BalanceAccount timeZone(String timeZone) {
        this.timeZone = timeZone;
        return this;
    }

    @ApiModelProperty(value="The time zone of the balance account. For example, **Europe/Amsterdam**. Defaults to the time zone of the account holder if no time zone is set. For possible values, see the [list of time zone codes](https://en.wikipedia.org/wiki/List_of_tz_database_time_zones).")
    @JsonProperty(value="timeZone")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getTimeZone() {
        return this.timeZone;
    }

    @JsonProperty(value="timeZone")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setTimeZone(String timeZone) {
        this.timeZone = timeZone;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BalanceAccount balanceAccount = (BalanceAccount)o;
        return Objects.equals(this.accountHolderId, balanceAccount.accountHolderId) && Objects.equals(this.balances, balanceAccount.balances) && Objects.equals(this.defaultCurrencyCode, balanceAccount.defaultCurrencyCode) && Objects.equals(this.description, balanceAccount.description) && Objects.equals(this.id, balanceAccount.id) && Objects.equals(this.metadata, balanceAccount.metadata) && Objects.equals(this.paymentInstruments, balanceAccount.paymentInstruments) && Objects.equals(this.reference, balanceAccount.reference) && Objects.equals((Object)this.status, (Object)balanceAccount.status) && Objects.equals(this.sweepConfigurations, balanceAccount.sweepConfigurations) && Objects.equals(this.timeZone, balanceAccount.timeZone);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.accountHolderId, this.balances, this.defaultCurrencyCode, this.description, this.id, this.metadata, this.paymentInstruments, this.reference, this.status, this.sweepConfigurations, this.timeZone});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class BalanceAccount {\n");
        sb.append("    accountHolderId: ").append(this.toIndentedString(this.accountHolderId)).append("\n");
        sb.append("    balances: ").append(this.toIndentedString(this.balances)).append("\n");
        sb.append("    defaultCurrencyCode: ").append(this.toIndentedString(this.defaultCurrencyCode)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    metadata: ").append(this.toIndentedString(this.metadata)).append("\n");
        sb.append("    paymentInstruments: ").append(this.toIndentedString(this.paymentInstruments)).append("\n");
        sb.append("    reference: ").append(this.toIndentedString(this.reference)).append("\n");
        sb.append("    status: ").append(this.toIndentedString((Object)this.status)).append("\n");
        sb.append("    sweepConfigurations: ").append(this.toIndentedString(this.sweepConfigurations)).append("\n");
        sb.append("    timeZone: ").append(this.toIndentedString(this.timeZone)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static BalanceAccount fromJson(String jsonString) throws JsonProcessingException {
        return (BalanceAccount)JSON.getMapper().readValue(jsonString, BalanceAccount.class);
    }

    public String toJson() throws JsonProcessingException {
        return JSON.getMapper().writeValueAsString((Object)this);
    }

    public static enum StatusEnum {
        ACTIVE("Active"),
        CLOSED("Closed"),
        INACTIVE("Inactive"),
        SUSPENDED("Suspended");

        private String value;

        private StatusEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static StatusEnum fromValue(String value) {
            for (StatusEnum b : StatusEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

