/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.service.balanceplatform;

import com.adyen.Client;
import com.adyen.Service;
import com.adyen.constants.ApiConstants;
import com.adyen.model.RequestOptions;
import com.adyen.model.balanceplatform.TransactionRule;
import com.adyen.model.balanceplatform.TransactionRuleInfo;
import com.adyen.model.balanceplatform.TransactionRuleResponse;
import com.adyen.service.exception.ApiException;
import com.adyen.service.resource.Resource;
import java.io.IOException;
import java.util.HashMap;

public class TransactionRulesApi
extends Service {
    protected String baseURL = this.createBaseURL("https://balanceplatform-api-test.adyen.com/bcl/v2");

    public TransactionRulesApi(Client client) {
        super(client);
    }

    public TransactionRule deleteTransactionRule(String transactionRuleId) throws ApiException, IOException {
        return this.deleteTransactionRule(transactionRuleId, null);
    }

    public TransactionRule deleteTransactionRule(String transactionRuleId, RequestOptions requestOptions) throws ApiException, IOException {
        HashMap<String, String> pathParams = new HashMap<String, String>();
        if (transactionRuleId == null) {
            throw new IllegalArgumentException("Please provide the transactionRuleId path parameter");
        }
        pathParams.put("transactionRuleId", transactionRuleId);
        String requestBody = null;
        Resource resource = new Resource(this, this.baseURL + "/transactionRules/{transactionRuleId}", null);
        String jsonResult = resource.request(requestBody, requestOptions, ApiConstants.HttpMethod.DELETE, pathParams);
        return TransactionRule.fromJson(jsonResult);
    }

    public TransactionRuleResponse getTransactionRule(String transactionRuleId) throws ApiException, IOException {
        return this.getTransactionRule(transactionRuleId, null);
    }

    public TransactionRuleResponse getTransactionRule(String transactionRuleId, RequestOptions requestOptions) throws ApiException, IOException {
        HashMap<String, String> pathParams = new HashMap<String, String>();
        if (transactionRuleId == null) {
            throw new IllegalArgumentException("Please provide the transactionRuleId path parameter");
        }
        pathParams.put("transactionRuleId", transactionRuleId);
        String requestBody = null;
        Resource resource = new Resource(this, this.baseURL + "/transactionRules/{transactionRuleId}", null);
        String jsonResult = resource.request(requestBody, requestOptions, ApiConstants.HttpMethod.GET, pathParams);
        return TransactionRuleResponse.fromJson(jsonResult);
    }

    public TransactionRule updateTransactionRule(String transactionRuleId, TransactionRuleInfo transactionRuleInfo) throws ApiException, IOException {
        return this.updateTransactionRule(transactionRuleId, transactionRuleInfo, null);
    }

    public TransactionRule updateTransactionRule(String transactionRuleId, TransactionRuleInfo transactionRuleInfo, RequestOptions requestOptions) throws ApiException, IOException {
        HashMap<String, String> pathParams = new HashMap<String, String>();
        if (transactionRuleId == null) {
            throw new IllegalArgumentException("Please provide the transactionRuleId path parameter");
        }
        pathParams.put("transactionRuleId", transactionRuleId);
        String requestBody = transactionRuleInfo.toJson();
        Resource resource = new Resource(this, this.baseURL + "/transactionRules/{transactionRuleId}", null);
        String jsonResult = resource.request(requestBody, requestOptions, ApiConstants.HttpMethod.PATCH, pathParams);
        return TransactionRule.fromJson(jsonResult);
    }

    public TransactionRule createTransactionRule(TransactionRuleInfo transactionRuleInfo) throws ApiException, IOException {
        return this.createTransactionRule(transactionRuleInfo, null);
    }

    public TransactionRule createTransactionRule(TransactionRuleInfo transactionRuleInfo, RequestOptions requestOptions) throws ApiException, IOException {
        String requestBody = transactionRuleInfo.toJson();
        Resource resource = new Resource(this, this.baseURL + "/transactionRules", null);
        String jsonResult = resource.request(requestBody, requestOptions, ApiConstants.HttpMethod.POST, null);
        return TransactionRule.fromJson(jsonResult);
    }
}

