/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.management;

import com.adyen.model.management.BillingEntity;
import com.adyen.model.management.JSON;
import com.adyen.model.management.OrderItem;
import com.adyen.model.management.ShippingLocation;
import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class TerminalOrder {
    public static final String SERIALIZED_NAME_BILLING_ENTITY = "billingEntity";
    @SerializedName(value="billingEntity")
    private BillingEntity billingEntity;
    public static final String SERIALIZED_NAME_CUSTOMER_ORDER_REFERENCE = "customerOrderReference";
    @SerializedName(value="customerOrderReference")
    private String customerOrderReference;
    public static final String SERIALIZED_NAME_ID = "id";
    @SerializedName(value="id")
    private String id;
    public static final String SERIALIZED_NAME_ITEMS = "items";
    @SerializedName(value="items")
    private List<OrderItem> items = null;
    public static final String SERIALIZED_NAME_ORDER_DATE = "orderDate";
    @SerializedName(value="orderDate")
    private String orderDate;
    public static final String SERIALIZED_NAME_SHIPPING_LOCATION = "shippingLocation";
    @SerializedName(value="shippingLocation")
    private ShippingLocation shippingLocation;
    public static final String SERIALIZED_NAME_STATUS = "status";
    @SerializedName(value="status")
    private String status;
    public static final String SERIALIZED_NAME_TRACKING_URL = "trackingUrl";
    @SerializedName(value="trackingUrl")
    private String trackingUrl;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;
    private static final Logger log;

    public TerminalOrder billingEntity(BillingEntity billingEntity) {
        this.billingEntity = billingEntity;
        return this;
    }

    @ApiModelProperty(value="")
    public BillingEntity getBillingEntity() {
        return this.billingEntity;
    }

    public void setBillingEntity(BillingEntity billingEntity) {
        this.billingEntity = billingEntity;
    }

    public TerminalOrder customerOrderReference(String customerOrderReference) {
        this.customerOrderReference = customerOrderReference;
        return this;
    }

    @ApiModelProperty(value="The merchant-defined purchase order number. This will be printed on the packing list.")
    public String getCustomerOrderReference() {
        return this.customerOrderReference;
    }

    public void setCustomerOrderReference(String customerOrderReference) {
        this.customerOrderReference = customerOrderReference;
    }

    public TerminalOrder id(String id) {
        this.id = id;
        return this;
    }

    @ApiModelProperty(value="The unique identifier of the order.")
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public TerminalOrder items(List<OrderItem> items) {
        this.items = items;
        return this;
    }

    public TerminalOrder addItemsItem(OrderItem itemsItem) {
        if (this.items == null) {
            this.items = new ArrayList<OrderItem>();
        }
        this.items.add(itemsItem);
        return this;
    }

    @ApiModelProperty(value="The products included in the order.")
    public List<OrderItem> getItems() {
        return this.items;
    }

    public void setItems(List<OrderItem> items) {
        this.items = items;
    }

    public TerminalOrder orderDate(String orderDate) {
        this.orderDate = orderDate;
        return this;
    }

    @ApiModelProperty(value="The date and time that the order was placed, in UTC ISO 8601 format. For example, \"2011-12-03T10:15:30Z\".")
    public String getOrderDate() {
        return this.orderDate;
    }

    public void setOrderDate(String orderDate) {
        this.orderDate = orderDate;
    }

    public TerminalOrder shippingLocation(ShippingLocation shippingLocation) {
        this.shippingLocation = shippingLocation;
        return this;
    }

    @ApiModelProperty(value="")
    public ShippingLocation getShippingLocation() {
        return this.shippingLocation;
    }

    public void setShippingLocation(ShippingLocation shippingLocation) {
        this.shippingLocation = shippingLocation;
    }

    public TerminalOrder status(String status) {
        this.status = status;
        return this;
    }

    @ApiModelProperty(value="The processing status of the order.")
    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public TerminalOrder trackingUrl(String trackingUrl) {
        this.trackingUrl = trackingUrl;
        return this;
    }

    @ApiModelProperty(value="The URL, provided by the carrier company, where the shipment can be tracked.")
    public String getTrackingUrl() {
        return this.trackingUrl;
    }

    public void setTrackingUrl(String trackingUrl) {
        this.trackingUrl = trackingUrl;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TerminalOrder terminalOrder = (TerminalOrder)o;
        return Objects.equals(this.billingEntity, terminalOrder.billingEntity) && Objects.equals(this.customerOrderReference, terminalOrder.customerOrderReference) && Objects.equals(this.id, terminalOrder.id) && Objects.equals(this.items, terminalOrder.items) && Objects.equals(this.orderDate, terminalOrder.orderDate) && Objects.equals(this.shippingLocation, terminalOrder.shippingLocation) && Objects.equals(this.status, terminalOrder.status) && Objects.equals(this.trackingUrl, terminalOrder.trackingUrl);
    }

    public int hashCode() {
        return Objects.hash(this.billingEntity, this.customerOrderReference, this.id, this.items, this.orderDate, this.shippingLocation, this.status, this.trackingUrl);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class TerminalOrder {\n");
        sb.append("    billingEntity: ").append(this.toIndentedString(this.billingEntity)).append("\n");
        sb.append("    customerOrderReference: ").append(this.toIndentedString(this.customerOrderReference)).append("\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    items: ").append(this.toIndentedString(this.items)).append("\n");
        sb.append("    orderDate: ").append(this.toIndentedString(this.orderDate)).append("\n");
        sb.append("    shippingLocation: ").append(this.toIndentedString(this.shippingLocation)).append("\n");
        sb.append("    status: ").append(this.toIndentedString(this.status)).append("\n");
        sb.append("    trackingUrl: ").append(this.toIndentedString(this.trackingUrl)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonObject(JsonObject jsonObj) throws IOException {
        JsonArray jsonArrayitems;
        if (jsonObj == null) {
            if (openapiRequiredFields.isEmpty()) {
                return;
            }
            throw new IllegalArgumentException(String.format("The required field(s) %s in TerminalOrder is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonObj.entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            log.log(Level.WARNING, String.format("The field `%s` in the JSON string is not defined in the `TerminalOrder` properties.", entry.getKey()));
        }
        if (jsonObj.getAsJsonObject(SERIALIZED_NAME_BILLING_ENTITY) != null) {
            BillingEntity.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_BILLING_ENTITY));
        }
        if (jsonObj.get(SERIALIZED_NAME_CUSTOMER_ORDER_REFERENCE) != null && !jsonObj.get(SERIALIZED_NAME_CUSTOMER_ORDER_REFERENCE).isJsonPrimitive()) {
            log.log(Level.WARNING, String.format("Expected the field `customerOrderReference` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_CUSTOMER_ORDER_REFERENCE).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_ID) != null && !jsonObj.get(SERIALIZED_NAME_ID).isJsonPrimitive()) {
            log.log(Level.WARNING, String.format("Expected the field `id` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_ID).toString()));
        }
        if ((jsonArrayitems = jsonObj.getAsJsonArray(SERIALIZED_NAME_ITEMS)) != null) {
            if (!jsonObj.get(SERIALIZED_NAME_ITEMS).isJsonArray()) {
                throw new IllegalArgumentException(String.format("Expected the field `items` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_ITEMS).toString()));
            }
            for (int i = 0; i < jsonArrayitems.size(); ++i) {
                OrderItem.validateJsonObject(jsonArrayitems.get(i).getAsJsonObject());
            }
        }
        if (jsonObj.get(SERIALIZED_NAME_ORDER_DATE) != null && !jsonObj.get(SERIALIZED_NAME_ORDER_DATE).isJsonPrimitive()) {
            log.log(Level.WARNING, String.format("Expected the field `orderDate` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_ORDER_DATE).toString()));
        }
        if (jsonObj.getAsJsonObject(SERIALIZED_NAME_SHIPPING_LOCATION) != null) {
            ShippingLocation.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_SHIPPING_LOCATION));
        }
        if (jsonObj.get(SERIALIZED_NAME_STATUS) != null && !jsonObj.get(SERIALIZED_NAME_STATUS).isJsonPrimitive()) {
            log.log(Level.WARNING, String.format("Expected the field `status` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_STATUS).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_TRACKING_URL) != null && !jsonObj.get(SERIALIZED_NAME_TRACKING_URL).isJsonPrimitive()) {
            log.log(Level.WARNING, String.format("Expected the field `trackingUrl` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_TRACKING_URL).toString()));
        }
    }

    public static TerminalOrder fromJson(String jsonString) throws IOException {
        return (TerminalOrder)JSON.getGson().fromJson(jsonString, TerminalOrder.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_BILLING_ENTITY);
        openapiFields.add(SERIALIZED_NAME_CUSTOMER_ORDER_REFERENCE);
        openapiFields.add(SERIALIZED_NAME_ID);
        openapiFields.add(SERIALIZED_NAME_ITEMS);
        openapiFields.add(SERIALIZED_NAME_ORDER_DATE);
        openapiFields.add(SERIALIZED_NAME_SHIPPING_LOCATION);
        openapiFields.add(SERIALIZED_NAME_STATUS);
        openapiFields.add(SERIALIZED_NAME_TRACKING_URL);
        openapiRequiredFields = new HashSet();
        log = Logger.getLogger(TerminalOrder.class.getName());
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!TerminalOrder.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(TerminalOrder.class));
            return new TypeAdapter<TerminalOrder>(){

                public void write(JsonWriter out, TerminalOrder value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public TerminalOrder read(JsonReader in) throws IOException {
                    JsonObject jsonObj = ((JsonElement)elementAdapter.read(in)).getAsJsonObject();
                    TerminalOrder.validateJsonObject(jsonObj);
                    return (TerminalOrder)thisAdapter.fromJsonTree((JsonElement)jsonObj);
                }
            }.nullSafe();
        }
    }
}

