/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.management;

import com.adyen.model.management.DataCenter;
import com.adyen.model.management.JSON;
import com.adyen.model.management.MerchantLinks;
import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Merchant {
    public static final String SERIALIZED_NAME_LINKS = "_links";
    @SerializedName(value="_links")
    private MerchantLinks links;
    public static final String SERIALIZED_NAME_CAPTURE_DELAY = "captureDelay";
    @SerializedName(value="captureDelay")
    private String captureDelay;
    public static final String SERIALIZED_NAME_COMPANY_ID = "companyId";
    @SerializedName(value="companyId")
    private String companyId;
    public static final String SERIALIZED_NAME_DATA_CENTERS = "dataCenters";
    @SerializedName(value="dataCenters")
    private List<DataCenter> dataCenters = null;
    public static final String SERIALIZED_NAME_DEFAULT_SHOPPER_INTERACTION = "defaultShopperInteraction";
    @SerializedName(value="defaultShopperInteraction")
    private String defaultShopperInteraction;
    public static final String SERIALIZED_NAME_DESCRIPTION = "description";
    @SerializedName(value="description")
    private String description;
    public static final String SERIALIZED_NAME_ID = "id";
    @SerializedName(value="id")
    private String id;
    public static final String SERIALIZED_NAME_MERCHANT_CITY = "merchantCity";
    @SerializedName(value="merchantCity")
    private String merchantCity;
    public static final String SERIALIZED_NAME_NAME = "name";
    @SerializedName(value="name")
    private String name;
    public static final String SERIALIZED_NAME_PRICING_PLAN = "pricingPlan";
    @SerializedName(value="pricingPlan")
    private String pricingPlan;
    public static final String SERIALIZED_NAME_PRIMARY_SETTLEMENT_CURRENCY = "primarySettlementCurrency";
    @SerializedName(value="primarySettlementCurrency")
    private String primarySettlementCurrency;
    public static final String SERIALIZED_NAME_REFERENCE = "reference";
    @SerializedName(value="reference")
    private String reference;
    public static final String SERIALIZED_NAME_SHOP_WEB_ADDRESS = "shopWebAddress";
    @SerializedName(value="shopWebAddress")
    private String shopWebAddress;
    public static final String SERIALIZED_NAME_STATUS = "status";
    @SerializedName(value="status")
    private String status;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;
    private static final Logger log;

    public Merchant links(MerchantLinks links) {
        this.links = links;
        return this;
    }

    @ApiModelProperty(value="")
    public MerchantLinks getLinks() {
        return this.links;
    }

    public void setLinks(MerchantLinks links) {
        this.links = links;
    }

    public Merchant captureDelay(String captureDelay) {
        this.captureDelay = captureDelay;
        return this;
    }

    @ApiModelProperty(value="The [capture delay](https://docs.adyen.com/online-payments/capture#capture-delay) set for the merchant account.  Possible values: * **Immediate** * **Manual** * Number of days from **1** to **29**")
    public String getCaptureDelay() {
        return this.captureDelay;
    }

    public void setCaptureDelay(String captureDelay) {
        this.captureDelay = captureDelay;
    }

    public Merchant companyId(String companyId) {
        this.companyId = companyId;
        return this;
    }

    @ApiModelProperty(value="The unique identifier of the company account this merchant belongs to")
    public String getCompanyId() {
        return this.companyId;
    }

    public void setCompanyId(String companyId) {
        this.companyId = companyId;
    }

    public Merchant dataCenters(List<DataCenter> dataCenters) {
        this.dataCenters = dataCenters;
        return this;
    }

    public Merchant addDataCentersItem(DataCenter dataCentersItem) {
        if (this.dataCenters == null) {
            this.dataCenters = new ArrayList<DataCenter>();
        }
        this.dataCenters.add(dataCentersItem);
        return this;
    }

    @ApiModelProperty(value="List of available data centers.  Adyen has several data centers around the world.In the URL that you use for making API requests, we recommend you use the live URL prefix from the data center closest to your shoppers.")
    public List<DataCenter> getDataCenters() {
        return this.dataCenters;
    }

    public void setDataCenters(List<DataCenter> dataCenters) {
        this.dataCenters = dataCenters;
    }

    public Merchant defaultShopperInteraction(String defaultShopperInteraction) {
        this.defaultShopperInteraction = defaultShopperInteraction;
        return this;
    }

    @ApiModelProperty(value="The default [`shopperInteraction`](https://docs.adyen.com/api-explorer/#/CheckoutService/v68/post/payments__reqParam_shopperInteraction) value used when processing payments through this merchant account.")
    public String getDefaultShopperInteraction() {
        return this.defaultShopperInteraction;
    }

    public void setDefaultShopperInteraction(String defaultShopperInteraction) {
        this.defaultShopperInteraction = defaultShopperInteraction;
    }

    public Merchant description(String description) {
        this.description = description;
        return this;
    }

    @ApiModelProperty(value="Your description for the merchant account, maximum 300 characters")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Merchant id(String id) {
        this.id = id;
        return this;
    }

    @ApiModelProperty(value="The unique identifier of the merchant account.")
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public Merchant merchantCity(String merchantCity) {
        this.merchantCity = merchantCity;
        return this;
    }

    @ApiModelProperty(value="The city where the legal entity of this merchant account is registered.")
    public String getMerchantCity() {
        return this.merchantCity;
    }

    public void setMerchantCity(String merchantCity) {
        this.merchantCity = merchantCity;
    }

    public Merchant name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(value="The name of the legal entity associated with the merchant account.")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Merchant pricingPlan(String pricingPlan) {
        this.pricingPlan = pricingPlan;
        return this;
    }

    @ApiModelProperty(value="Only applies to merchant accounts managed by Adyen's partners. The name of the pricing plan assigned to the merchant account.")
    public String getPricingPlan() {
        return this.pricingPlan;
    }

    public void setPricingPlan(String pricingPlan) {
        this.pricingPlan = pricingPlan;
    }

    public Merchant primarySettlementCurrency(String primarySettlementCurrency) {
        this.primarySettlementCurrency = primarySettlementCurrency;
        return this;
    }

    @ApiModelProperty(value="The currency of the country where the legal entity of this merchant account is registered. Format: [ISO currency code](https://docs.adyen.com/development-resources/currency-codes). For example, a legal entity based in the United States has USD as the primary settlement currency.")
    public String getPrimarySettlementCurrency() {
        return this.primarySettlementCurrency;
    }

    public void setPrimarySettlementCurrency(String primarySettlementCurrency) {
        this.primarySettlementCurrency = primarySettlementCurrency;
    }

    public Merchant reference(String reference) {
        this.reference = reference;
        return this;
    }

    @ApiModelProperty(value="Reference of the merchant account.")
    public String getReference() {
        return this.reference;
    }

    public void setReference(String reference) {
        this.reference = reference;
    }

    public Merchant shopWebAddress(String shopWebAddress) {
        this.shopWebAddress = shopWebAddress;
        return this;
    }

    @ApiModelProperty(value="The URL for the ecommerce website used with this merchant account.")
    public String getShopWebAddress() {
        return this.shopWebAddress;
    }

    public void setShopWebAddress(String shopWebAddress) {
        this.shopWebAddress = shopWebAddress;
    }

    public Merchant status(String status) {
        this.status = status;
        return this;
    }

    @ApiModelProperty(value="The status of the merchant account.  Possible values:  * **PreActive**: The merchant account has been created. Users cannot access the merchant account in the Customer Area. The account cannot process payments. * **Active**: Users can access the merchant account in the Customer Area. If the company account is also **Active**, then payment processing and payouts are enabled. * **InactiveWithModifications**: Users can access the merchant account in the Customer Area. You cannot process new payments but you can still modify payments, for example issue refunds. You can still receive payouts. * **Inactive**: Users can access the merchant account in the Customer Area. Payment processing and payouts are disabled. * **Closed**: The account is closed and this cannot be reversed. Users cannot log in. Payment processing and payouts are disabled.")
    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Merchant merchant = (Merchant)o;
        return Objects.equals(this.links, merchant.links) && Objects.equals(this.captureDelay, merchant.captureDelay) && Objects.equals(this.companyId, merchant.companyId) && Objects.equals(this.dataCenters, merchant.dataCenters) && Objects.equals(this.defaultShopperInteraction, merchant.defaultShopperInteraction) && Objects.equals(this.description, merchant.description) && Objects.equals(this.id, merchant.id) && Objects.equals(this.merchantCity, merchant.merchantCity) && Objects.equals(this.name, merchant.name) && Objects.equals(this.pricingPlan, merchant.pricingPlan) && Objects.equals(this.primarySettlementCurrency, merchant.primarySettlementCurrency) && Objects.equals(this.reference, merchant.reference) && Objects.equals(this.shopWebAddress, merchant.shopWebAddress) && Objects.equals(this.status, merchant.status);
    }

    public int hashCode() {
        return Objects.hash(this.links, this.captureDelay, this.companyId, this.dataCenters, this.defaultShopperInteraction, this.description, this.id, this.merchantCity, this.name, this.pricingPlan, this.primarySettlementCurrency, this.reference, this.shopWebAddress, this.status);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Merchant {\n");
        sb.append("    links: ").append(this.toIndentedString(this.links)).append("\n");
        sb.append("    captureDelay: ").append(this.toIndentedString(this.captureDelay)).append("\n");
        sb.append("    companyId: ").append(this.toIndentedString(this.companyId)).append("\n");
        sb.append("    dataCenters: ").append(this.toIndentedString(this.dataCenters)).append("\n");
        sb.append("    defaultShopperInteraction: ").append(this.toIndentedString(this.defaultShopperInteraction)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    merchantCity: ").append(this.toIndentedString(this.merchantCity)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    pricingPlan: ").append(this.toIndentedString(this.pricingPlan)).append("\n");
        sb.append("    primarySettlementCurrency: ").append(this.toIndentedString(this.primarySettlementCurrency)).append("\n");
        sb.append("    reference: ").append(this.toIndentedString(this.reference)).append("\n");
        sb.append("    shopWebAddress: ").append(this.toIndentedString(this.shopWebAddress)).append("\n");
        sb.append("    status: ").append(this.toIndentedString(this.status)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonObject(JsonObject jsonObj) throws IOException {
        JsonArray jsonArraydataCenters;
        if (jsonObj == null) {
            if (openapiRequiredFields.isEmpty()) {
                return;
            }
            throw new IllegalArgumentException(String.format("The required field(s) %s in Merchant is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonObj.entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            log.log(Level.WARNING, String.format("The field `%s` in the JSON string is not defined in the `Merchant` properties.", entry.getKey()));
        }
        if (jsonObj.getAsJsonObject(SERIALIZED_NAME_LINKS) != null) {
            MerchantLinks.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_LINKS));
        }
        if (jsonObj.get(SERIALIZED_NAME_CAPTURE_DELAY) != null && !jsonObj.get(SERIALIZED_NAME_CAPTURE_DELAY).isJsonPrimitive()) {
            log.log(Level.WARNING, String.format("Expected the field `captureDelay` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_CAPTURE_DELAY).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_COMPANY_ID) != null && !jsonObj.get(SERIALIZED_NAME_COMPANY_ID).isJsonPrimitive()) {
            log.log(Level.WARNING, String.format("Expected the field `companyId` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_COMPANY_ID).toString()));
        }
        if ((jsonArraydataCenters = jsonObj.getAsJsonArray(SERIALIZED_NAME_DATA_CENTERS)) != null) {
            if (!jsonObj.get(SERIALIZED_NAME_DATA_CENTERS).isJsonArray()) {
                throw new IllegalArgumentException(String.format("Expected the field `dataCenters` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_DATA_CENTERS).toString()));
            }
            for (int i = 0; i < jsonArraydataCenters.size(); ++i) {
                DataCenter.validateJsonObject(jsonArraydataCenters.get(i).getAsJsonObject());
            }
        }
        if (jsonObj.get(SERIALIZED_NAME_DEFAULT_SHOPPER_INTERACTION) != null && !jsonObj.get(SERIALIZED_NAME_DEFAULT_SHOPPER_INTERACTION).isJsonPrimitive()) {
            log.log(Level.WARNING, String.format("Expected the field `defaultShopperInteraction` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_DEFAULT_SHOPPER_INTERACTION).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_DESCRIPTION) != null && !jsonObj.get(SERIALIZED_NAME_DESCRIPTION).isJsonPrimitive()) {
            log.log(Level.WARNING, String.format("Expected the field `description` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_DESCRIPTION).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_ID) != null && !jsonObj.get(SERIALIZED_NAME_ID).isJsonPrimitive()) {
            log.log(Level.WARNING, String.format("Expected the field `id` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_ID).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_MERCHANT_CITY) != null && !jsonObj.get(SERIALIZED_NAME_MERCHANT_CITY).isJsonPrimitive()) {
            log.log(Level.WARNING, String.format("Expected the field `merchantCity` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_MERCHANT_CITY).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_NAME) != null && !jsonObj.get(SERIALIZED_NAME_NAME).isJsonPrimitive()) {
            log.log(Level.WARNING, String.format("Expected the field `name` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_NAME).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_PRICING_PLAN) != null && !jsonObj.get(SERIALIZED_NAME_PRICING_PLAN).isJsonPrimitive()) {
            log.log(Level.WARNING, String.format("Expected the field `pricingPlan` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_PRICING_PLAN).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_PRIMARY_SETTLEMENT_CURRENCY) != null && !jsonObj.get(SERIALIZED_NAME_PRIMARY_SETTLEMENT_CURRENCY).isJsonPrimitive()) {
            log.log(Level.WARNING, String.format("Expected the field `primarySettlementCurrency` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_PRIMARY_SETTLEMENT_CURRENCY).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_REFERENCE) != null && !jsonObj.get(SERIALIZED_NAME_REFERENCE).isJsonPrimitive()) {
            log.log(Level.WARNING, String.format("Expected the field `reference` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_REFERENCE).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_SHOP_WEB_ADDRESS) != null && !jsonObj.get(SERIALIZED_NAME_SHOP_WEB_ADDRESS).isJsonPrimitive()) {
            log.log(Level.WARNING, String.format("Expected the field `shopWebAddress` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_SHOP_WEB_ADDRESS).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_STATUS) != null && !jsonObj.get(SERIALIZED_NAME_STATUS).isJsonPrimitive()) {
            log.log(Level.WARNING, String.format("Expected the field `status` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_STATUS).toString()));
        }
    }

    public static Merchant fromJson(String jsonString) throws IOException {
        return (Merchant)JSON.getGson().fromJson(jsonString, Merchant.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_LINKS);
        openapiFields.add(SERIALIZED_NAME_CAPTURE_DELAY);
        openapiFields.add(SERIALIZED_NAME_COMPANY_ID);
        openapiFields.add(SERIALIZED_NAME_DATA_CENTERS);
        openapiFields.add(SERIALIZED_NAME_DEFAULT_SHOPPER_INTERACTION);
        openapiFields.add(SERIALIZED_NAME_DESCRIPTION);
        openapiFields.add(SERIALIZED_NAME_ID);
        openapiFields.add(SERIALIZED_NAME_MERCHANT_CITY);
        openapiFields.add(SERIALIZED_NAME_NAME);
        openapiFields.add(SERIALIZED_NAME_PRICING_PLAN);
        openapiFields.add(SERIALIZED_NAME_PRIMARY_SETTLEMENT_CURRENCY);
        openapiFields.add(SERIALIZED_NAME_REFERENCE);
        openapiFields.add(SERIALIZED_NAME_SHOP_WEB_ADDRESS);
        openapiFields.add(SERIALIZED_NAME_STATUS);
        openapiRequiredFields = new HashSet();
        log = Logger.getLogger(Merchant.class.getName());
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!Merchant.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(Merchant.class));
            return new TypeAdapter<Merchant>(){

                public void write(JsonWriter out, Merchant value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public Merchant read(JsonReader in) throws IOException {
                    JsonObject jsonObj = ((JsonElement)elementAdapter.read(in)).getAsJsonObject();
                    Merchant.validateJsonObject(jsonObj);
                    return (Merchant)thisAdapter.fromJsonTree((JsonElement)jsonObj);
                }
            }.nullSafe();
        }
    }
}

