/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.service.checkout;

import com.adyen.Client;
import com.adyen.Service;
import com.adyen.constants.ApiConstants;
import com.adyen.model.RequestOptions;
import com.adyen.model.checkout.CheckoutBalanceCheckRequest;
import com.adyen.model.checkout.CheckoutBalanceCheckResponse;
import com.adyen.model.checkout.CheckoutCancelOrderRequest;
import com.adyen.model.checkout.CheckoutCancelOrderResponse;
import com.adyen.model.checkout.CheckoutCreateOrderRequest;
import com.adyen.model.checkout.CheckoutCreateOrderResponse;
import com.adyen.service.exception.ApiException;
import com.adyen.service.resource.Resource;
import java.io.IOException;

public class OrdersApi
extends Service {
    private final String baseURL = this.createBaseURL("https://checkout-test.adyen.com/v70");

    public OrdersApi(Client client) {
        super(client);
    }

    public CheckoutCreateOrderResponse orders(CheckoutCreateOrderRequest checkoutCreateOrderRequest) throws ApiException, IOException {
        return this.orders(checkoutCreateOrderRequest, null);
    }

    public CheckoutCreateOrderResponse orders(CheckoutCreateOrderRequest checkoutCreateOrderRequest, RequestOptions requestOptions) throws ApiException, IOException {
        String requestBody = checkoutCreateOrderRequest.toJson();
        Resource resource = new Resource(this, this.baseURL + "/orders", null);
        String jsonResult = resource.request(requestBody, requestOptions, ApiConstants.HttpMethod.POST, null);
        return CheckoutCreateOrderResponse.fromJson(jsonResult);
    }

    public CheckoutCancelOrderResponse cancelOrder(CheckoutCancelOrderRequest checkoutCancelOrderRequest) throws ApiException, IOException {
        return this.cancelOrder(checkoutCancelOrderRequest, null);
    }

    public CheckoutCancelOrderResponse cancelOrder(CheckoutCancelOrderRequest checkoutCancelOrderRequest, RequestOptions requestOptions) throws ApiException, IOException {
        String requestBody = checkoutCancelOrderRequest.toJson();
        Resource resource = new Resource(this, this.baseURL + "/orders/cancel", null);
        String jsonResult = resource.request(requestBody, requestOptions, ApiConstants.HttpMethod.POST, null);
        return CheckoutCancelOrderResponse.fromJson(jsonResult);
    }

    public CheckoutBalanceCheckResponse getBalanceOfGiftCard(CheckoutBalanceCheckRequest checkoutBalanceCheckRequest) throws ApiException, IOException {
        return this.getBalanceOfGiftCard(checkoutBalanceCheckRequest, null);
    }

    public CheckoutBalanceCheckResponse getBalanceOfGiftCard(CheckoutBalanceCheckRequest checkoutBalanceCheckRequest, RequestOptions requestOptions) throws ApiException, IOException {
        String requestBody = checkoutBalanceCheckRequest.toJson();
        Resource resource = new Resource(this, this.baseURL + "/paymentMethods/balance", null);
        String jsonResult = resource.request(requestBody, requestOptions, ApiConstants.HttpMethod.POST, null);
        return CheckoutBalanceCheckResponse.fromJson(jsonResult);
    }
}

