/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.configurationwebhooks;

import com.adyen.model.configurationwebhooks.JSON;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class USLocalAccountIdentification {
    public static final String SERIALIZED_NAME_ACCOUNT_NUMBER = "accountNumber";
    @SerializedName(value="accountNumber")
    private String accountNumber;
    public static final String SERIALIZED_NAME_ACCOUNT_TYPE = "accountType";
    @SerializedName(value="accountType")
    private AccountTypeEnum accountType = AccountTypeEnum.CHECKING;
    public static final String SERIALIZED_NAME_ROUTING_NUMBER = "routingNumber";
    @SerializedName(value="routingNumber")
    private String routingNumber;
    public static final String SERIALIZED_NAME_TYPE = "type";
    @SerializedName(value="type")
    private TypeEnum type = TypeEnum.USLOCAL;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;
    private static final Logger log;

    public USLocalAccountIdentification accountNumber(String accountNumber) {
        this.accountNumber = accountNumber;
        return this;
    }

    @ApiModelProperty(required=true, value="The bank account number, without separators or whitespace.")
    public String getAccountNumber() {
        return this.accountNumber;
    }

    public void setAccountNumber(String accountNumber) {
        this.accountNumber = accountNumber;
    }

    public USLocalAccountIdentification accountType(AccountTypeEnum accountType) {
        this.accountType = accountType;
        return this;
    }

    @ApiModelProperty(value="The bank account type.  Possible values: **checking** or **savings**. Defaults to **checking**.")
    public AccountTypeEnum getAccountType() {
        return this.accountType;
    }

    public void setAccountType(AccountTypeEnum accountType) {
        this.accountType = accountType;
    }

    public USLocalAccountIdentification routingNumber(String routingNumber) {
        this.routingNumber = routingNumber;
        return this;
    }

    @ApiModelProperty(required=true, value="The 9-digit [routing number](https://en.wikipedia.org/wiki/ABA_routing_transit_number), without separators or whitespace.")
    public String getRoutingNumber() {
        return this.routingNumber;
    }

    public void setRoutingNumber(String routingNumber) {
        this.routingNumber = routingNumber;
    }

    public USLocalAccountIdentification type(TypeEnum type) {
        this.type = type;
        return this;
    }

    @ApiModelProperty(required=true, value="**usLocal**")
    public TypeEnum getType() {
        return this.type;
    }

    public void setType(TypeEnum type) {
        this.type = type;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        USLocalAccountIdentification usLocalAccountIdentification = (USLocalAccountIdentification)o;
        return Objects.equals(this.accountNumber, usLocalAccountIdentification.accountNumber) && Objects.equals((Object)this.accountType, (Object)usLocalAccountIdentification.accountType) && Objects.equals(this.routingNumber, usLocalAccountIdentification.routingNumber) && Objects.equals((Object)this.type, (Object)usLocalAccountIdentification.type);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.accountNumber, this.accountType, this.routingNumber, this.type});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class USLocalAccountIdentification {\n");
        sb.append("    accountNumber: ").append(this.toIndentedString(this.accountNumber)).append("\n");
        sb.append("    accountType: ").append(this.toIndentedString((Object)this.accountType)).append("\n");
        sb.append("    routingNumber: ").append(this.toIndentedString(this.routingNumber)).append("\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonObject(JsonObject jsonObj) throws IOException {
        if (jsonObj == null) {
            if (openapiRequiredFields.isEmpty()) {
                return;
            }
            throw new IllegalArgumentException(String.format("The required field(s) %s in USLocalAccountIdentification is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonObj.entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            log.log(Level.WARNING, String.format("The field `%s` in the JSON string is not defined in the `USLocalAccountIdentification` properties.", entry.getKey()));
        }
        for (String requiredField : openapiRequiredFields) {
            if (jsonObj.get(requiredField) != null) continue;
            throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonObj.toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_ACCOUNT_NUMBER) != null && !jsonObj.get(SERIALIZED_NAME_ACCOUNT_NUMBER).isJsonPrimitive()) {
            log.log(Level.WARNING, String.format("Expected the field `accountNumber` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_ACCOUNT_NUMBER).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_ACCOUNT_TYPE) != null) {
            if (!jsonObj.get(SERIALIZED_NAME_ACCOUNT_TYPE).isJsonPrimitive()) {
                throw new IllegalArgumentException(String.format("Expected the field `accountType` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_ACCOUNT_TYPE).toString()));
            }
            AccountTypeEnum.fromValue(jsonObj.get(SERIALIZED_NAME_ACCOUNT_TYPE).getAsString());
        }
        if (jsonObj.get(SERIALIZED_NAME_ROUTING_NUMBER) != null && !jsonObj.get(SERIALIZED_NAME_ROUTING_NUMBER).isJsonPrimitive()) {
            log.log(Level.WARNING, String.format("Expected the field `routingNumber` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_ROUTING_NUMBER).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_TYPE) != null) {
            if (!jsonObj.get(SERIALIZED_NAME_TYPE).isJsonPrimitive()) {
                throw new IllegalArgumentException(String.format("Expected the field `type` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_TYPE).toString()));
            }
            TypeEnum.fromValue(jsonObj.get(SERIALIZED_NAME_TYPE).getAsString());
        }
    }

    public static USLocalAccountIdentification fromJson(String jsonString) throws IOException {
        return (USLocalAccountIdentification)JSON.getGson().fromJson(jsonString, USLocalAccountIdentification.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_ACCOUNT_NUMBER);
        openapiFields.add(SERIALIZED_NAME_ACCOUNT_TYPE);
        openapiFields.add(SERIALIZED_NAME_ROUTING_NUMBER);
        openapiFields.add(SERIALIZED_NAME_TYPE);
        openapiRequiredFields = new HashSet();
        openapiRequiredFields.add(SERIALIZED_NAME_ACCOUNT_NUMBER);
        openapiRequiredFields.add(SERIALIZED_NAME_ROUTING_NUMBER);
        openapiRequiredFields.add(SERIALIZED_NAME_TYPE);
        log = Logger.getLogger(USLocalAccountIdentification.class.getName());
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!USLocalAccountIdentification.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(USLocalAccountIdentification.class));
            return new TypeAdapter<USLocalAccountIdentification>(){

                public void write(JsonWriter out, USLocalAccountIdentification value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public USLocalAccountIdentification read(JsonReader in) throws IOException {
                    JsonObject jsonObj = ((JsonElement)elementAdapter.read(in)).getAsJsonObject();
                    USLocalAccountIdentification.validateJsonObject(jsonObj);
                    return (USLocalAccountIdentification)thisAdapter.fromJsonTree((JsonElement)jsonObj);
                }
            }.nullSafe();
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum TypeEnum {
        USLOCAL("usLocal");

        private String value;

        private TypeEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static TypeEnum fromValue(String value) {
            for (TypeEnum b : TypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public static class Adapter
        extends TypeAdapter<TypeEnum> {
            public void write(JsonWriter jsonWriter, TypeEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public TypeEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return TypeEnum.fromValue(value);
            }
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum AccountTypeEnum {
        CHECKING("checking"),
        SAVINGS("savings");

        private String value;

        private AccountTypeEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static AccountTypeEnum fromValue(String value) {
            for (AccountTypeEnum b : AccountTypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public static class Adapter
        extends TypeAdapter<AccountTypeEnum> {
            public void write(JsonWriter jsonWriter, AccountTypeEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public AccountTypeEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return AccountTypeEnum.fromValue(value);
            }
        }
    }
}

