/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.payment;

import com.adyen.model.payment.JSON;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class DeviceRenderOptions {
    public static final String SERIALIZED_NAME_SDK_INTERFACE = "sdkInterface";
    @SerializedName(value="sdkInterface")
    private SdkInterfaceEnum sdkInterface = SdkInterfaceEnum.BOTH;
    public static final String SERIALIZED_NAME_SDK_UI_TYPE = "sdkUiType";
    @SerializedName(value="sdkUiType")
    private List<SdkUiTypeEnum> sdkUiType = null;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;
    private static final Logger log;

    public DeviceRenderOptions sdkInterface(SdkInterfaceEnum sdkInterface) {
        this.sdkInterface = sdkInterface;
        return this;
    }

    @ApiModelProperty(value="Supported SDK interface types. Allowed values: * native * html * both")
    public SdkInterfaceEnum getSdkInterface() {
        return this.sdkInterface;
    }

    public void setSdkInterface(SdkInterfaceEnum sdkInterface) {
        this.sdkInterface = sdkInterface;
    }

    public DeviceRenderOptions sdkUiType(List<SdkUiTypeEnum> sdkUiType) {
        this.sdkUiType = sdkUiType;
        return this;
    }

    public DeviceRenderOptions addSdkUiTypeItem(SdkUiTypeEnum sdkUiTypeItem) {
        if (this.sdkUiType == null) {
            this.sdkUiType = new ArrayList<SdkUiTypeEnum>();
        }
        this.sdkUiType.add(sdkUiTypeItem);
        return this;
    }

    @ApiModelProperty(value="UI types supported for displaying specific challenges. Allowed values: * text * singleSelect * outOfBand * otherHtml * multiSelect")
    public List<SdkUiTypeEnum> getSdkUiType() {
        return this.sdkUiType;
    }

    public void setSdkUiType(List<SdkUiTypeEnum> sdkUiType) {
        this.sdkUiType = sdkUiType;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DeviceRenderOptions deviceRenderOptions = (DeviceRenderOptions)o;
        return Objects.equals((Object)this.sdkInterface, (Object)deviceRenderOptions.sdkInterface) && Objects.equals(this.sdkUiType, deviceRenderOptions.sdkUiType);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.sdkInterface, this.sdkUiType});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class DeviceRenderOptions {\n");
        sb.append("    sdkInterface: ").append(this.toIndentedString((Object)this.sdkInterface)).append("\n");
        sb.append("    sdkUiType: ").append(this.toIndentedString(this.sdkUiType)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonObject(JsonObject jsonObj) throws IOException {
        if (jsonObj == null) {
            if (openapiRequiredFields.isEmpty()) {
                return;
            }
            throw new IllegalArgumentException(String.format("The required field(s) %s in DeviceRenderOptions is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonObj.entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            log.log(Level.WARNING, String.format("The field `%s` in the JSON string is not defined in the `DeviceRenderOptions` properties.", entry.getKey()));
        }
        if (jsonObj.get(SERIALIZED_NAME_SDK_INTERFACE) != null) {
            if (!jsonObj.get(SERIALIZED_NAME_SDK_INTERFACE).isJsonPrimitive()) {
                throw new IllegalArgumentException(String.format("Expected the field `sdkInterface` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_SDK_INTERFACE).toString()));
            }
            SdkInterfaceEnum.fromValue(jsonObj.get(SERIALIZED_NAME_SDK_INTERFACE).getAsString());
        }
        if (jsonObj.get(SERIALIZED_NAME_SDK_UI_TYPE) != null && !jsonObj.get(SERIALIZED_NAME_SDK_UI_TYPE).isJsonArray()) {
            log.log(Level.WARNING, String.format("Expected the field `sdkUiType` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_SDK_UI_TYPE).toString()));
        }
    }

    public static DeviceRenderOptions fromJson(String jsonString) throws IOException {
        return (DeviceRenderOptions)JSON.getGson().fromJson(jsonString, DeviceRenderOptions.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_SDK_INTERFACE);
        openapiFields.add(SERIALIZED_NAME_SDK_UI_TYPE);
        openapiRequiredFields = new HashSet();
        log = Logger.getLogger(DeviceRenderOptions.class.getName());
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!DeviceRenderOptions.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(DeviceRenderOptions.class));
            return new TypeAdapter<DeviceRenderOptions>(){

                public void write(JsonWriter out, DeviceRenderOptions value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public DeviceRenderOptions read(JsonReader in) throws IOException {
                    JsonObject jsonObj = ((JsonElement)elementAdapter.read(in)).getAsJsonObject();
                    DeviceRenderOptions.validateJsonObject(jsonObj);
                    return (DeviceRenderOptions)thisAdapter.fromJsonTree((JsonElement)jsonObj);
                }
            }.nullSafe();
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum SdkUiTypeEnum {
        MULTISELECT("multiSelect"),
        OTHERHTML("otherHtml"),
        OUTOFBAND("outOfBand"),
        SINGLESELECT("singleSelect"),
        TEXT("text");

        private String value;

        private SdkUiTypeEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static SdkUiTypeEnum fromValue(String value) {
            for (SdkUiTypeEnum b : SdkUiTypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public static class Adapter
        extends TypeAdapter<SdkUiTypeEnum> {
            public void write(JsonWriter jsonWriter, SdkUiTypeEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public SdkUiTypeEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return SdkUiTypeEnum.fromValue(value);
            }
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum SdkInterfaceEnum {
        NATIVE("native"),
        HTML("html"),
        BOTH("both");

        private String value;

        private SdkInterfaceEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static SdkInterfaceEnum fromValue(String value) {
            for (SdkInterfaceEnum b : SdkInterfaceEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public static class Adapter
        extends TypeAdapter<SdkInterfaceEnum> {
            public void write(JsonWriter jsonWriter, SdkInterfaceEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public SdkInterfaceEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return SdkInterfaceEnum.fromValue(value);
            }
        }
    }
}

