/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.payment;

import com.adyen.model.payment.JSON;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class BrowserInfo {
    public static final String SERIALIZED_NAME_ACCEPT_HEADER = "acceptHeader";
    @SerializedName(value="acceptHeader")
    private String acceptHeader;
    public static final String SERIALIZED_NAME_COLOR_DEPTH = "colorDepth";
    @SerializedName(value="colorDepth")
    private Integer colorDepth;
    public static final String SERIALIZED_NAME_JAVA_ENABLED = "javaEnabled";
    @SerializedName(value="javaEnabled")
    private Boolean javaEnabled;
    public static final String SERIALIZED_NAME_JAVA_SCRIPT_ENABLED = "javaScriptEnabled";
    @SerializedName(value="javaScriptEnabled")
    private Boolean javaScriptEnabled = true;
    public static final String SERIALIZED_NAME_LANGUAGE = "language";
    @SerializedName(value="language")
    private String language;
    public static final String SERIALIZED_NAME_SCREEN_HEIGHT = "screenHeight";
    @SerializedName(value="screenHeight")
    private Integer screenHeight;
    public static final String SERIALIZED_NAME_SCREEN_WIDTH = "screenWidth";
    @SerializedName(value="screenWidth")
    private Integer screenWidth;
    public static final String SERIALIZED_NAME_TIME_ZONE_OFFSET = "timeZoneOffset";
    @SerializedName(value="timeZoneOffset")
    private Integer timeZoneOffset;
    public static final String SERIALIZED_NAME_USER_AGENT = "userAgent";
    @SerializedName(value="userAgent")
    private String userAgent;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;
    private static final Logger log;

    public BrowserInfo acceptHeader(String acceptHeader) {
        this.acceptHeader = acceptHeader;
        return this;
    }

    @ApiModelProperty(required=true, value="The accept header value of the shopper's browser.")
    public String getAcceptHeader() {
        return this.acceptHeader;
    }

    public void setAcceptHeader(String acceptHeader) {
        this.acceptHeader = acceptHeader;
    }

    public BrowserInfo colorDepth(Integer colorDepth) {
        this.colorDepth = colorDepth;
        return this;
    }

    @ApiModelProperty(required=true, value="The color depth of the shopper's browser in bits per pixel. This should be obtained by using the browser's `screen.colorDepth` property. Accepted values: 1, 4, 8, 15, 16, 24, 30, 32 or 48 bit color depth.")
    public Integer getColorDepth() {
        return this.colorDepth;
    }

    public void setColorDepth(Integer colorDepth) {
        this.colorDepth = colorDepth;
    }

    public BrowserInfo javaEnabled(Boolean javaEnabled) {
        this.javaEnabled = javaEnabled;
        return this;
    }

    @ApiModelProperty(required=true, value="Boolean value indicating if the shopper's browser is able to execute Java.")
    public Boolean getJavaEnabled() {
        return this.javaEnabled;
    }

    public void setJavaEnabled(Boolean javaEnabled) {
        this.javaEnabled = javaEnabled;
    }

    public BrowserInfo javaScriptEnabled(Boolean javaScriptEnabled) {
        this.javaScriptEnabled = javaScriptEnabled;
        return this;
    }

    @ApiModelProperty(value="Boolean value indicating if the shopper's browser is able to execute JavaScript. A default 'true' value is assumed if the field is not present.")
    public Boolean getJavaScriptEnabled() {
        return this.javaScriptEnabled;
    }

    public void setJavaScriptEnabled(Boolean javaScriptEnabled) {
        this.javaScriptEnabled = javaScriptEnabled;
    }

    public BrowserInfo language(String language) {
        this.language = language;
        return this;
    }

    @ApiModelProperty(required=true, value="The `navigator.language` value of the shopper's browser (as defined in IETF BCP 47).")
    public String getLanguage() {
        return this.language;
    }

    public void setLanguage(String language) {
        this.language = language;
    }

    public BrowserInfo screenHeight(Integer screenHeight) {
        this.screenHeight = screenHeight;
        return this;
    }

    @ApiModelProperty(required=true, value="The total height of the shopper's device screen in pixels.")
    public Integer getScreenHeight() {
        return this.screenHeight;
    }

    public void setScreenHeight(Integer screenHeight) {
        this.screenHeight = screenHeight;
    }

    public BrowserInfo screenWidth(Integer screenWidth) {
        this.screenWidth = screenWidth;
        return this;
    }

    @ApiModelProperty(required=true, value="The total width of the shopper's device screen in pixels.")
    public Integer getScreenWidth() {
        return this.screenWidth;
    }

    public void setScreenWidth(Integer screenWidth) {
        this.screenWidth = screenWidth;
    }

    public BrowserInfo timeZoneOffset(Integer timeZoneOffset) {
        this.timeZoneOffset = timeZoneOffset;
        return this;
    }

    @ApiModelProperty(required=true, value="Time difference between UTC time and the shopper's browser local time, in minutes.")
    public Integer getTimeZoneOffset() {
        return this.timeZoneOffset;
    }

    public void setTimeZoneOffset(Integer timeZoneOffset) {
        this.timeZoneOffset = timeZoneOffset;
    }

    public BrowserInfo userAgent(String userAgent) {
        this.userAgent = userAgent;
        return this;
    }

    @ApiModelProperty(required=true, value="The user agent value of the shopper's browser.")
    public String getUserAgent() {
        return this.userAgent;
    }

    public void setUserAgent(String userAgent) {
        this.userAgent = userAgent;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BrowserInfo browserInfo = (BrowserInfo)o;
        return Objects.equals(this.acceptHeader, browserInfo.acceptHeader) && Objects.equals(this.colorDepth, browserInfo.colorDepth) && Objects.equals(this.javaEnabled, browserInfo.javaEnabled) && Objects.equals(this.javaScriptEnabled, browserInfo.javaScriptEnabled) && Objects.equals(this.language, browserInfo.language) && Objects.equals(this.screenHeight, browserInfo.screenHeight) && Objects.equals(this.screenWidth, browserInfo.screenWidth) && Objects.equals(this.timeZoneOffset, browserInfo.timeZoneOffset) && Objects.equals(this.userAgent, browserInfo.userAgent);
    }

    public int hashCode() {
        return Objects.hash(this.acceptHeader, this.colorDepth, this.javaEnabled, this.javaScriptEnabled, this.language, this.screenHeight, this.screenWidth, this.timeZoneOffset, this.userAgent);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class BrowserInfo {\n");
        sb.append("    acceptHeader: ").append(this.toIndentedString(this.acceptHeader)).append("\n");
        sb.append("    colorDepth: ").append(this.toIndentedString(this.colorDepth)).append("\n");
        sb.append("    javaEnabled: ").append(this.toIndentedString(this.javaEnabled)).append("\n");
        sb.append("    javaScriptEnabled: ").append(this.toIndentedString(this.javaScriptEnabled)).append("\n");
        sb.append("    language: ").append(this.toIndentedString(this.language)).append("\n");
        sb.append("    screenHeight: ").append(this.toIndentedString(this.screenHeight)).append("\n");
        sb.append("    screenWidth: ").append(this.toIndentedString(this.screenWidth)).append("\n");
        sb.append("    timeZoneOffset: ").append(this.toIndentedString(this.timeZoneOffset)).append("\n");
        sb.append("    userAgent: ").append(this.toIndentedString(this.userAgent)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonObject(JsonObject jsonObj) throws IOException {
        if (jsonObj == null) {
            if (openapiRequiredFields.isEmpty()) {
                return;
            }
            throw new IllegalArgumentException(String.format("The required field(s) %s in BrowserInfo is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonObj.entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            log.log(Level.WARNING, String.format("The field `%s` in the JSON string is not defined in the `BrowserInfo` properties.", entry.getKey()));
        }
        for (String requiredField : openapiRequiredFields) {
            if (jsonObj.get(requiredField) != null) continue;
            throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonObj.toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_ACCEPT_HEADER) != null && !jsonObj.get(SERIALIZED_NAME_ACCEPT_HEADER).isJsonPrimitive()) {
            log.log(Level.WARNING, String.format("Expected the field `acceptHeader` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_ACCEPT_HEADER).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_LANGUAGE) != null && !jsonObj.get(SERIALIZED_NAME_LANGUAGE).isJsonPrimitive()) {
            log.log(Level.WARNING, String.format("Expected the field `language` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_LANGUAGE).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_USER_AGENT) != null && !jsonObj.get(SERIALIZED_NAME_USER_AGENT).isJsonPrimitive()) {
            log.log(Level.WARNING, String.format("Expected the field `userAgent` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_USER_AGENT).toString()));
        }
    }

    public static BrowserInfo fromJson(String jsonString) throws IOException {
        return (BrowserInfo)JSON.getGson().fromJson(jsonString, BrowserInfo.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_ACCEPT_HEADER);
        openapiFields.add(SERIALIZED_NAME_COLOR_DEPTH);
        openapiFields.add(SERIALIZED_NAME_JAVA_ENABLED);
        openapiFields.add(SERIALIZED_NAME_JAVA_SCRIPT_ENABLED);
        openapiFields.add(SERIALIZED_NAME_LANGUAGE);
        openapiFields.add(SERIALIZED_NAME_SCREEN_HEIGHT);
        openapiFields.add(SERIALIZED_NAME_SCREEN_WIDTH);
        openapiFields.add(SERIALIZED_NAME_TIME_ZONE_OFFSET);
        openapiFields.add(SERIALIZED_NAME_USER_AGENT);
        openapiRequiredFields = new HashSet();
        openapiRequiredFields.add(SERIALIZED_NAME_ACCEPT_HEADER);
        openapiRequiredFields.add(SERIALIZED_NAME_COLOR_DEPTH);
        openapiRequiredFields.add(SERIALIZED_NAME_JAVA_ENABLED);
        openapiRequiredFields.add(SERIALIZED_NAME_LANGUAGE);
        openapiRequiredFields.add(SERIALIZED_NAME_SCREEN_HEIGHT);
        openapiRequiredFields.add(SERIALIZED_NAME_SCREEN_WIDTH);
        openapiRequiredFields.add(SERIALIZED_NAME_TIME_ZONE_OFFSET);
        openapiRequiredFields.add(SERIALIZED_NAME_USER_AGENT);
        log = Logger.getLogger(BrowserInfo.class.getName());
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!BrowserInfo.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(BrowserInfo.class));
            return new TypeAdapter<BrowserInfo>(){

                public void write(JsonWriter out, BrowserInfo value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public BrowserInfo read(JsonReader in) throws IOException {
                    JsonObject jsonObj = ((JsonElement)elementAdapter.read(in)).getAsJsonObject();
                    BrowserInfo.validateJsonObject(jsonObj);
                    return (BrowserInfo)thisAdapter.fromJsonTree((JsonElement)jsonObj);
                }
            }.nullSafe();
        }
    }
}

