/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.management;

import com.adyen.model.management.AdditionalSettingsResponse;
import com.adyen.model.management.JSON;
import com.adyen.model.management.WebhookLinks;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Webhook {
    public static final String SERIALIZED_NAME_LINKS = "_links";
    @SerializedName(value="_links")
    private WebhookLinks links;
    public static final String SERIALIZED_NAME_ACCEPTS_EXPIRED_CERTIFICATE = "acceptsExpiredCertificate";
    @SerializedName(value="acceptsExpiredCertificate")
    private Boolean acceptsExpiredCertificate;
    public static final String SERIALIZED_NAME_ACCEPTS_SELF_SIGNED_CERTIFICATE = "acceptsSelfSignedCertificate";
    @SerializedName(value="acceptsSelfSignedCertificate")
    private Boolean acceptsSelfSignedCertificate;
    public static final String SERIALIZED_NAME_ACCEPTS_UNTRUSTED_ROOT_CERTIFICATE = "acceptsUntrustedRootCertificate";
    @SerializedName(value="acceptsUntrustedRootCertificate")
    private Boolean acceptsUntrustedRootCertificate;
    public static final String SERIALIZED_NAME_ACCOUNT_REFERENCE = "accountReference";
    @SerializedName(value="accountReference")
    private String accountReference;
    public static final String SERIALIZED_NAME_ACTIVE = "active";
    @SerializedName(value="active")
    private Boolean active;
    public static final String SERIALIZED_NAME_ADDITIONAL_SETTINGS = "additionalSettings";
    @SerializedName(value="additionalSettings")
    private AdditionalSettingsResponse additionalSettings;
    public static final String SERIALIZED_NAME_CERTIFICATE_ALIAS = "certificateAlias";
    @SerializedName(value="certificateAlias")
    private String certificateAlias;
    public static final String SERIALIZED_NAME_COMMUNICATION_FORMAT = "communicationFormat";
    @SerializedName(value="communicationFormat")
    private CommunicationFormatEnum communicationFormat;
    public static final String SERIALIZED_NAME_DESCRIPTION = "description";
    @SerializedName(value="description")
    private String description;
    public static final String SERIALIZED_NAME_FILTER_MERCHANT_ACCOUNT_TYPE = "filterMerchantAccountType";
    @SerializedName(value="filterMerchantAccountType")
    private FilterMerchantAccountTypeEnum filterMerchantAccountType;
    public static final String SERIALIZED_NAME_FILTER_MERCHANT_ACCOUNTS = "filterMerchantAccounts";
    @SerializedName(value="filterMerchantAccounts")
    private List<String> filterMerchantAccounts = null;
    public static final String SERIALIZED_NAME_HAS_ERROR = "hasError";
    @SerializedName(value="hasError")
    private Boolean hasError;
    public static final String SERIALIZED_NAME_HAS_PASSWORD = "hasPassword";
    @SerializedName(value="hasPassword")
    private Boolean hasPassword;
    public static final String SERIALIZED_NAME_HMAC_KEY_CHECK_VALUE = "hmacKeyCheckValue";
    @SerializedName(value="hmacKeyCheckValue")
    private String hmacKeyCheckValue;
    public static final String SERIALIZED_NAME_ID = "id";
    @SerializedName(value="id")
    private String id;
    public static final String SERIALIZED_NAME_NETWORK_TYPE = "networkType";
    @SerializedName(value="networkType")
    private NetworkTypeEnum networkType;
    public static final String SERIALIZED_NAME_POPULATE_SOAP_ACTION_HEADER = "populateSoapActionHeader";
    @SerializedName(value="populateSoapActionHeader")
    private Boolean populateSoapActionHeader;
    public static final String SERIALIZED_NAME_SSL_VERSION = "sslVersion";
    @SerializedName(value="sslVersion")
    private SslVersionEnum sslVersion;
    public static final String SERIALIZED_NAME_TYPE = "type";
    @SerializedName(value="type")
    private String type;
    public static final String SERIALIZED_NAME_URL = "url";
    @SerializedName(value="url")
    private String url;
    public static final String SERIALIZED_NAME_USERNAME = "username";
    @SerializedName(value="username")
    private String username;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;
    private static final Logger log;

    public Webhook links(WebhookLinks links) {
        this.links = links;
        return this;
    }

    @ApiModelProperty(value="")
    public WebhookLinks getLinks() {
        return this.links;
    }

    public void setLinks(WebhookLinks links) {
        this.links = links;
    }

    public Webhook acceptsExpiredCertificate(Boolean acceptsExpiredCertificate) {
        this.acceptsExpiredCertificate = acceptsExpiredCertificate;
        return this;
    }

    @ApiModelProperty(value="Indicates if expired SSL certificates are accepted. Default value: **false**.")
    public Boolean getAcceptsExpiredCertificate() {
        return this.acceptsExpiredCertificate;
    }

    public void setAcceptsExpiredCertificate(Boolean acceptsExpiredCertificate) {
        this.acceptsExpiredCertificate = acceptsExpiredCertificate;
    }

    public Webhook acceptsSelfSignedCertificate(Boolean acceptsSelfSignedCertificate) {
        this.acceptsSelfSignedCertificate = acceptsSelfSignedCertificate;
        return this;
    }

    @ApiModelProperty(value="Indicates if self-signed SSL certificates are accepted. Default value: **false**.")
    public Boolean getAcceptsSelfSignedCertificate() {
        return this.acceptsSelfSignedCertificate;
    }

    public void setAcceptsSelfSignedCertificate(Boolean acceptsSelfSignedCertificate) {
        this.acceptsSelfSignedCertificate = acceptsSelfSignedCertificate;
    }

    public Webhook acceptsUntrustedRootCertificate(Boolean acceptsUntrustedRootCertificate) {
        this.acceptsUntrustedRootCertificate = acceptsUntrustedRootCertificate;
        return this;
    }

    @ApiModelProperty(value="Indicates if untrusted SSL certificates are accepted. Default value: **false**.")
    public Boolean getAcceptsUntrustedRootCertificate() {
        return this.acceptsUntrustedRootCertificate;
    }

    public void setAcceptsUntrustedRootCertificate(Boolean acceptsUntrustedRootCertificate) {
        this.acceptsUntrustedRootCertificate = acceptsUntrustedRootCertificate;
    }

    public Webhook accountReference(String accountReference) {
        this.accountReference = accountReference;
        return this;
    }

    @ApiModelProperty(value="Reference to the account the webook is set on.")
    public String getAccountReference() {
        return this.accountReference;
    }

    public void setAccountReference(String accountReference) {
        this.accountReference = accountReference;
    }

    public Webhook active(Boolean active) {
        this.active = active;
        return this;
    }

    @ApiModelProperty(required=true, value="Indicates if the webhook configuration is active. The field must be **true** for you to receive webhooks about events related an account.")
    public Boolean getActive() {
        return this.active;
    }

    public void setActive(Boolean active) {
        this.active = active;
    }

    public Webhook additionalSettings(AdditionalSettingsResponse additionalSettings) {
        this.additionalSettings = additionalSettings;
        return this;
    }

    @ApiModelProperty(value="")
    public AdditionalSettingsResponse getAdditionalSettings() {
        return this.additionalSettings;
    }

    public void setAdditionalSettings(AdditionalSettingsResponse additionalSettings) {
        this.additionalSettings = additionalSettings;
    }

    public Webhook certificateAlias(String certificateAlias) {
        this.certificateAlias = certificateAlias;
        return this;
    }

    @ApiModelProperty(value="The alias of our SSL certificate. When you receive a notification from us, the alias from the HMAC signature will match this alias.")
    public String getCertificateAlias() {
        return this.certificateAlias;
    }

    public void setCertificateAlias(String certificateAlias) {
        this.certificateAlias = certificateAlias;
    }

    public Webhook communicationFormat(CommunicationFormatEnum communicationFormat) {
        this.communicationFormat = communicationFormat;
        return this;
    }

    @ApiModelProperty(example="soap", required=true, value="Format or protocol for receiving webhooks. Possible values: * **soap** * **http** * **json** ")
    public CommunicationFormatEnum getCommunicationFormat() {
        return this.communicationFormat;
    }

    public void setCommunicationFormat(CommunicationFormatEnum communicationFormat) {
        this.communicationFormat = communicationFormat;
    }

    public Webhook description(String description) {
        this.description = description;
        return this;
    }

    @ApiModelProperty(value="Your description for this webhook configuration.")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Webhook filterMerchantAccountType(FilterMerchantAccountTypeEnum filterMerchantAccountType) {
        this.filterMerchantAccountType = filterMerchantAccountType;
        return this;
    }

    @ApiModelProperty(value="Shows how merchant accounts are included in company-level webhooks. Possible values: * **includeAccounts** * **excludeAccounts** * **allAccounts**: Includes all merchant accounts, and does not require specifying `filterMerchantAccounts`.")
    public FilterMerchantAccountTypeEnum getFilterMerchantAccountType() {
        return this.filterMerchantAccountType;
    }

    public void setFilterMerchantAccountType(FilterMerchantAccountTypeEnum filterMerchantAccountType) {
        this.filterMerchantAccountType = filterMerchantAccountType;
    }

    public Webhook filterMerchantAccounts(List<String> filterMerchantAccounts) {
        this.filterMerchantAccounts = filterMerchantAccounts;
        return this;
    }

    public Webhook addFilterMerchantAccountsItem(String filterMerchantAccountsItem) {
        if (this.filterMerchantAccounts == null) {
            this.filterMerchantAccounts = new ArrayList<String>();
        }
        this.filterMerchantAccounts.add(filterMerchantAccountsItem);
        return this;
    }

    @ApiModelProperty(value="A list of merchant account names that are included or excluded from receiving the webhook. Inclusion or exclusion is based on the value defined for `filterMerchantAccountType`.  Required if `filterMerchantAccountType` is either: * **includeAccounts** * **excludeAccounts**  Not needed for `filterMerchantAccountType`: **allAccounts**.")
    public List<String> getFilterMerchantAccounts() {
        return this.filterMerchantAccounts;
    }

    public void setFilterMerchantAccounts(List<String> filterMerchantAccounts) {
        this.filterMerchantAccounts = filterMerchantAccounts;
    }

    public Webhook hasError(Boolean hasError) {
        this.hasError = hasError;
        return this;
    }

    @ApiModelProperty(value="Indicates if the webhook configuration has errors that need troubleshooting. If the value is **true**, troubleshoot the configuration using the [testing endpoint](https://docs.adyen.com/api-explorer/#/ManagementService/v1/post/companies/{companyId}/webhooks/{webhookid}/test).")
    public Boolean getHasError() {
        return this.hasError;
    }

    public void setHasError(Boolean hasError) {
        this.hasError = hasError;
    }

    public Webhook hasPassword(Boolean hasPassword) {
        this.hasPassword = hasPassword;
        return this;
    }

    @ApiModelProperty(value="Indicates if the webhook is password protected.")
    public Boolean getHasPassword() {
        return this.hasPassword;
    }

    public void setHasPassword(Boolean hasPassword) {
        this.hasPassword = hasPassword;
    }

    public Webhook hmacKeyCheckValue(String hmacKeyCheckValue) {
        this.hmacKeyCheckValue = hmacKeyCheckValue;
        return this;
    }

    @ApiModelProperty(value="The [checksum](https://en.wikipedia.org/wiki/Key_checksum_value) of the HMAC key generated for this webhook. You can use this value to uniquely identify the HMAC key configured for this webhook.")
    public String getHmacKeyCheckValue() {
        return this.hmacKeyCheckValue;
    }

    public void setHmacKeyCheckValue(String hmacKeyCheckValue) {
        this.hmacKeyCheckValue = hmacKeyCheckValue;
    }

    public Webhook id(String id) {
        this.id = id;
        return this;
    }

    @ApiModelProperty(value="Unique identifier for this webhook.")
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public Webhook networkType(NetworkTypeEnum networkType) {
        this.networkType = networkType;
        return this;
    }

    @ApiModelProperty(value="Network type for Terminal API details webhooks.")
    public NetworkTypeEnum getNetworkType() {
        return this.networkType;
    }

    public void setNetworkType(NetworkTypeEnum networkType) {
        this.networkType = networkType;
    }

    public Webhook populateSoapActionHeader(Boolean populateSoapActionHeader) {
        this.populateSoapActionHeader = populateSoapActionHeader;
        return this;
    }

    @ApiModelProperty(value="Indicates if the SOAP action header needs to be populated. Default value: **false**.  Only applies if `communicationFormat`: **soap**.")
    public Boolean getPopulateSoapActionHeader() {
        return this.populateSoapActionHeader;
    }

    public void setPopulateSoapActionHeader(Boolean populateSoapActionHeader) {
        this.populateSoapActionHeader = populateSoapActionHeader;
    }

    public Webhook sslVersion(SslVersionEnum sslVersion) {
        this.sslVersion = sslVersion;
        return this;
    }

    @ApiModelProperty(example="TLSv1.2", value="SSL version to access the public webhook URL specified in the `url` field. Possible values: * **TLSv1.3** * **TLSv1.2** * **HTTP** - Only allowed on Test environment.  If not specified, the webhook will use `sslVersion`: **TLSv1.2**.")
    public SslVersionEnum getSslVersion() {
        return this.sslVersion;
    }

    public void setSslVersion(SslVersionEnum sslVersion) {
        this.sslVersion = sslVersion;
    }

    public Webhook type(String type) {
        this.type = type;
        return this;
    }

    @ApiModelProperty(required=true, value="The type of webhook. Possible values are:  - **standard** - **account-settings-notification** - **banktransfer-notification** - **boletobancario-notification** - **directdebit-notification** - **pending-notification** - **ideal-notification** - **ideal-pending-notification** - **report-notification** - **terminal-api-notification**  Find out more about [standard notification webhooks](https://docs.adyen.com/development-resources/webhooks/understand-notifications#event-codes) and [other types of notifications](https://docs.adyen.com/development-resources/webhooks/understand-notifications#other-notifications).")
    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public Webhook url(String url) {
        this.url = url;
        return this;
    }

    @ApiModelProperty(example="http://www.adyen.com", required=true, value="Public URL where webhooks will be sent, for example **https://www.domain.com/webhook-endpoint**.")
    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public Webhook username(String username) {
        this.username = username;
        return this;
    }

    @ApiModelProperty(value="Username to access the webhook URL.")
    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Webhook webhook = (Webhook)o;
        return Objects.equals(this.links, webhook.links) && Objects.equals(this.acceptsExpiredCertificate, webhook.acceptsExpiredCertificate) && Objects.equals(this.acceptsSelfSignedCertificate, webhook.acceptsSelfSignedCertificate) && Objects.equals(this.acceptsUntrustedRootCertificate, webhook.acceptsUntrustedRootCertificate) && Objects.equals(this.accountReference, webhook.accountReference) && Objects.equals(this.active, webhook.active) && Objects.equals(this.additionalSettings, webhook.additionalSettings) && Objects.equals(this.certificateAlias, webhook.certificateAlias) && Objects.equals((Object)this.communicationFormat, (Object)webhook.communicationFormat) && Objects.equals(this.description, webhook.description) && Objects.equals((Object)this.filterMerchantAccountType, (Object)webhook.filterMerchantAccountType) && Objects.equals(this.filterMerchantAccounts, webhook.filterMerchantAccounts) && Objects.equals(this.hasError, webhook.hasError) && Objects.equals(this.hasPassword, webhook.hasPassword) && Objects.equals(this.hmacKeyCheckValue, webhook.hmacKeyCheckValue) && Objects.equals(this.id, webhook.id) && Objects.equals((Object)this.networkType, (Object)webhook.networkType) && Objects.equals(this.populateSoapActionHeader, webhook.populateSoapActionHeader) && Objects.equals((Object)this.sslVersion, (Object)webhook.sslVersion) && Objects.equals(this.type, webhook.type) && Objects.equals(this.url, webhook.url) && Objects.equals(this.username, webhook.username);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.links, this.acceptsExpiredCertificate, this.acceptsSelfSignedCertificate, this.acceptsUntrustedRootCertificate, this.accountReference, this.active, this.additionalSettings, this.certificateAlias, this.communicationFormat, this.description, this.filterMerchantAccountType, this.filterMerchantAccounts, this.hasError, this.hasPassword, this.hmacKeyCheckValue, this.id, this.networkType, this.populateSoapActionHeader, this.sslVersion, this.type, this.url, this.username});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Webhook {\n");
        sb.append("    links: ").append(this.toIndentedString(this.links)).append("\n");
        sb.append("    acceptsExpiredCertificate: ").append(this.toIndentedString(this.acceptsExpiredCertificate)).append("\n");
        sb.append("    acceptsSelfSignedCertificate: ").append(this.toIndentedString(this.acceptsSelfSignedCertificate)).append("\n");
        sb.append("    acceptsUntrustedRootCertificate: ").append(this.toIndentedString(this.acceptsUntrustedRootCertificate)).append("\n");
        sb.append("    accountReference: ").append(this.toIndentedString(this.accountReference)).append("\n");
        sb.append("    active: ").append(this.toIndentedString(this.active)).append("\n");
        sb.append("    additionalSettings: ").append(this.toIndentedString(this.additionalSettings)).append("\n");
        sb.append("    certificateAlias: ").append(this.toIndentedString(this.certificateAlias)).append("\n");
        sb.append("    communicationFormat: ").append(this.toIndentedString((Object)this.communicationFormat)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    filterMerchantAccountType: ").append(this.toIndentedString((Object)this.filterMerchantAccountType)).append("\n");
        sb.append("    filterMerchantAccounts: ").append(this.toIndentedString(this.filterMerchantAccounts)).append("\n");
        sb.append("    hasError: ").append(this.toIndentedString(this.hasError)).append("\n");
        sb.append("    hasPassword: ").append(this.toIndentedString(this.hasPassword)).append("\n");
        sb.append("    hmacKeyCheckValue: ").append(this.toIndentedString(this.hmacKeyCheckValue)).append("\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    networkType: ").append(this.toIndentedString((Object)this.networkType)).append("\n");
        sb.append("    populateSoapActionHeader: ").append(this.toIndentedString(this.populateSoapActionHeader)).append("\n");
        sb.append("    sslVersion: ").append(this.toIndentedString((Object)this.sslVersion)).append("\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("    url: ").append(this.toIndentedString(this.url)).append("\n");
        sb.append("    username: ").append(this.toIndentedString(this.username)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonObject(JsonObject jsonObj) throws IOException {
        if (jsonObj == null) {
            if (openapiRequiredFields.isEmpty()) {
                return;
            }
            throw new IllegalArgumentException(String.format("The required field(s) %s in Webhook is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonObj.entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            log.log(Level.WARNING, String.format("The field `%s` in the JSON string is not defined in the `Webhook` properties.", entry.getKey()));
        }
        for (String requiredField : openapiRequiredFields) {
            if (jsonObj.get(requiredField) != null) continue;
            throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonObj.toString()));
        }
        if (jsonObj.getAsJsonObject(SERIALIZED_NAME_LINKS) != null) {
            WebhookLinks.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_LINKS));
        }
        if (jsonObj.get(SERIALIZED_NAME_ACCOUNT_REFERENCE) != null && !jsonObj.get(SERIALIZED_NAME_ACCOUNT_REFERENCE).isJsonPrimitive()) {
            log.log(Level.WARNING, String.format("Expected the field `accountReference` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_ACCOUNT_REFERENCE).toString()));
        }
        if (jsonObj.getAsJsonObject(SERIALIZED_NAME_ADDITIONAL_SETTINGS) != null) {
            AdditionalSettingsResponse.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_ADDITIONAL_SETTINGS));
        }
        if (jsonObj.get(SERIALIZED_NAME_CERTIFICATE_ALIAS) != null && !jsonObj.get(SERIALIZED_NAME_CERTIFICATE_ALIAS).isJsonPrimitive()) {
            log.log(Level.WARNING, String.format("Expected the field `certificateAlias` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_CERTIFICATE_ALIAS).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_COMMUNICATION_FORMAT) != null) {
            if (!jsonObj.get(SERIALIZED_NAME_COMMUNICATION_FORMAT).isJsonPrimitive()) {
                throw new IllegalArgumentException(String.format("Expected the field `communicationFormat` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_COMMUNICATION_FORMAT).toString()));
            }
            CommunicationFormatEnum.fromValue(jsonObj.get(SERIALIZED_NAME_COMMUNICATION_FORMAT).getAsString());
        }
        if (jsonObj.get(SERIALIZED_NAME_DESCRIPTION) != null && !jsonObj.get(SERIALIZED_NAME_DESCRIPTION).isJsonPrimitive()) {
            log.log(Level.WARNING, String.format("Expected the field `description` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_DESCRIPTION).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_FILTER_MERCHANT_ACCOUNT_TYPE) != null) {
            if (!jsonObj.get(SERIALIZED_NAME_FILTER_MERCHANT_ACCOUNT_TYPE).isJsonPrimitive()) {
                throw new IllegalArgumentException(String.format("Expected the field `filterMerchantAccountType` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_FILTER_MERCHANT_ACCOUNT_TYPE).toString()));
            }
            FilterMerchantAccountTypeEnum.fromValue(jsonObj.get(SERIALIZED_NAME_FILTER_MERCHANT_ACCOUNT_TYPE).getAsString());
        }
        if (jsonObj.get(SERIALIZED_NAME_FILTER_MERCHANT_ACCOUNTS) != null && !jsonObj.get(SERIALIZED_NAME_FILTER_MERCHANT_ACCOUNTS).isJsonArray()) {
            log.log(Level.WARNING, String.format("Expected the field `filterMerchantAccounts` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_FILTER_MERCHANT_ACCOUNTS).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_HMAC_KEY_CHECK_VALUE) != null && !jsonObj.get(SERIALIZED_NAME_HMAC_KEY_CHECK_VALUE).isJsonPrimitive()) {
            log.log(Level.WARNING, String.format("Expected the field `hmacKeyCheckValue` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_HMAC_KEY_CHECK_VALUE).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_ID) != null && !jsonObj.get(SERIALIZED_NAME_ID).isJsonPrimitive()) {
            log.log(Level.WARNING, String.format("Expected the field `id` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_ID).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_NETWORK_TYPE) != null) {
            if (!jsonObj.get(SERIALIZED_NAME_NETWORK_TYPE).isJsonPrimitive()) {
                throw new IllegalArgumentException(String.format("Expected the field `networkType` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_NETWORK_TYPE).toString()));
            }
            NetworkTypeEnum.fromValue(jsonObj.get(SERIALIZED_NAME_NETWORK_TYPE).getAsString());
        }
        if (jsonObj.get(SERIALIZED_NAME_SSL_VERSION) != null) {
            if (!jsonObj.get(SERIALIZED_NAME_SSL_VERSION).isJsonPrimitive()) {
                throw new IllegalArgumentException(String.format("Expected the field `sslVersion` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_SSL_VERSION).toString()));
            }
            SslVersionEnum.fromValue(jsonObj.get(SERIALIZED_NAME_SSL_VERSION).getAsString());
        }
        if (jsonObj.get(SERIALIZED_NAME_TYPE) != null && !jsonObj.get(SERIALIZED_NAME_TYPE).isJsonPrimitive()) {
            log.log(Level.WARNING, String.format("Expected the field `type` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_TYPE).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_URL) != null && !jsonObj.get(SERIALIZED_NAME_URL).isJsonPrimitive()) {
            log.log(Level.WARNING, String.format("Expected the field `url` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_URL).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_USERNAME) != null && !jsonObj.get(SERIALIZED_NAME_USERNAME).isJsonPrimitive()) {
            log.log(Level.WARNING, String.format("Expected the field `username` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_USERNAME).toString()));
        }
    }

    public static Webhook fromJson(String jsonString) throws IOException {
        return (Webhook)JSON.getGson().fromJson(jsonString, Webhook.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_LINKS);
        openapiFields.add(SERIALIZED_NAME_ACCEPTS_EXPIRED_CERTIFICATE);
        openapiFields.add(SERIALIZED_NAME_ACCEPTS_SELF_SIGNED_CERTIFICATE);
        openapiFields.add(SERIALIZED_NAME_ACCEPTS_UNTRUSTED_ROOT_CERTIFICATE);
        openapiFields.add(SERIALIZED_NAME_ACCOUNT_REFERENCE);
        openapiFields.add(SERIALIZED_NAME_ACTIVE);
        openapiFields.add(SERIALIZED_NAME_ADDITIONAL_SETTINGS);
        openapiFields.add(SERIALIZED_NAME_CERTIFICATE_ALIAS);
        openapiFields.add(SERIALIZED_NAME_COMMUNICATION_FORMAT);
        openapiFields.add(SERIALIZED_NAME_DESCRIPTION);
        openapiFields.add(SERIALIZED_NAME_FILTER_MERCHANT_ACCOUNT_TYPE);
        openapiFields.add(SERIALIZED_NAME_FILTER_MERCHANT_ACCOUNTS);
        openapiFields.add(SERIALIZED_NAME_HAS_ERROR);
        openapiFields.add(SERIALIZED_NAME_HAS_PASSWORD);
        openapiFields.add(SERIALIZED_NAME_HMAC_KEY_CHECK_VALUE);
        openapiFields.add(SERIALIZED_NAME_ID);
        openapiFields.add(SERIALIZED_NAME_NETWORK_TYPE);
        openapiFields.add(SERIALIZED_NAME_POPULATE_SOAP_ACTION_HEADER);
        openapiFields.add(SERIALIZED_NAME_SSL_VERSION);
        openapiFields.add(SERIALIZED_NAME_TYPE);
        openapiFields.add(SERIALIZED_NAME_URL);
        openapiFields.add(SERIALIZED_NAME_USERNAME);
        openapiRequiredFields = new HashSet();
        openapiRequiredFields.add(SERIALIZED_NAME_ACTIVE);
        openapiRequiredFields.add(SERIALIZED_NAME_COMMUNICATION_FORMAT);
        openapiRequiredFields.add(SERIALIZED_NAME_TYPE);
        openapiRequiredFields.add(SERIALIZED_NAME_URL);
        log = Logger.getLogger(Webhook.class.getName());
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!Webhook.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(Webhook.class));
            return new TypeAdapter<Webhook>(){

                public void write(JsonWriter out, Webhook value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public Webhook read(JsonReader in) throws IOException {
                    JsonObject jsonObj = ((JsonElement)elementAdapter.read(in)).getAsJsonObject();
                    Webhook.validateJsonObject(jsonObj);
                    return (Webhook)thisAdapter.fromJsonTree((JsonElement)jsonObj);
                }
            }.nullSafe();
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum SslVersionEnum {
        HTTP("HTTP"),
        SSL("SSL"),
        SSLV3("SSLv3"),
        TLS("TLS"),
        TLSV1("TLSv1"),
        TLSV1_1("TLSv1.1"),
        TLSV1_2("TLSv1.2"),
        TLSV1_3("TLSv1.3");

        private String value;

        private SslVersionEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static SslVersionEnum fromValue(String value) {
            for (SslVersionEnum b : SslVersionEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public static class Adapter
        extends TypeAdapter<SslVersionEnum> {
            public void write(JsonWriter jsonWriter, SslVersionEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public SslVersionEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return SslVersionEnum.fromValue(value);
            }
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum NetworkTypeEnum {
        LOCAL("LOCAL"),
        PUBLIC("PUBLIC");

        private String value;

        private NetworkTypeEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static NetworkTypeEnum fromValue(String value) {
            for (NetworkTypeEnum b : NetworkTypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public static class Adapter
        extends TypeAdapter<NetworkTypeEnum> {
            public void write(JsonWriter jsonWriter, NetworkTypeEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public NetworkTypeEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return NetworkTypeEnum.fromValue(value);
            }
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum FilterMerchantAccountTypeEnum {
        ALLACCOUNTS("allAccounts"),
        EXCLUDEACCOUNTS("excludeAccounts"),
        INCLUDEACCOUNTS("includeAccounts");

        private String value;

        private FilterMerchantAccountTypeEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static FilterMerchantAccountTypeEnum fromValue(String value) {
            for (FilterMerchantAccountTypeEnum b : FilterMerchantAccountTypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public static class Adapter
        extends TypeAdapter<FilterMerchantAccountTypeEnum> {
            public void write(JsonWriter jsonWriter, FilterMerchantAccountTypeEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public FilterMerchantAccountTypeEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return FilterMerchantAccountTypeEnum.fromValue(value);
            }
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum CommunicationFormatEnum {
        HTTP("http"),
        JSON("json"),
        SOAP("soap");

        private String value;

        private CommunicationFormatEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static CommunicationFormatEnum fromValue(String value) {
            for (CommunicationFormatEnum b : CommunicationFormatEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public static class Adapter
        extends TypeAdapter<CommunicationFormatEnum> {
            public void write(JsonWriter jsonWriter, CommunicationFormatEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public CommunicationFormatEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return CommunicationFormatEnum.fromValue(value);
            }
        }
    }
}

