/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.management;

import com.adyen.model.management.JSON;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class StoreSplitConfiguration {
    public static final String SERIALIZED_NAME_BALANCE_ACCOUNT_ID = "balanceAccountId";
    @SerializedName(value="balanceAccountId")
    private String balanceAccountId;
    public static final String SERIALIZED_NAME_SPLIT_CONFIGURATION_ID = "splitConfigurationId";
    @SerializedName(value="splitConfigurationId")
    private String splitConfigurationId;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;
    private static final Logger log;

    public StoreSplitConfiguration balanceAccountId(String balanceAccountId) {
        this.balanceAccountId = balanceAccountId;
        return this;
    }

    @ApiModelProperty(value="The [balance account](https://docs.adyen.com/api-explorer/#/balanceplatform/latest/get/balanceAccounts/{id}__queryParam_id) linked to the account holder.")
    public String getBalanceAccountId() {
        return this.balanceAccountId;
    }

    public void setBalanceAccountId(String balanceAccountId) {
        this.balanceAccountId = balanceAccountId;
    }

    public StoreSplitConfiguration splitConfigurationId(String splitConfigurationId) {
        this.splitConfigurationId = splitConfigurationId;
        return this;
    }

    @ApiModelProperty(value="The UUID of the [split configuration](https://docs.adyen.com/marketplaces-and-platforms/classic/split-configuration-for-stores) from the Customer Area.")
    public String getSplitConfigurationId() {
        return this.splitConfigurationId;
    }

    public void setSplitConfigurationId(String splitConfigurationId) {
        this.splitConfigurationId = splitConfigurationId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StoreSplitConfiguration storeSplitConfiguration = (StoreSplitConfiguration)o;
        return Objects.equals(this.balanceAccountId, storeSplitConfiguration.balanceAccountId) && Objects.equals(this.splitConfigurationId, storeSplitConfiguration.splitConfigurationId);
    }

    public int hashCode() {
        return Objects.hash(this.balanceAccountId, this.splitConfigurationId);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class StoreSplitConfiguration {\n");
        sb.append("    balanceAccountId: ").append(this.toIndentedString(this.balanceAccountId)).append("\n");
        sb.append("    splitConfigurationId: ").append(this.toIndentedString(this.splitConfigurationId)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonObject(JsonObject jsonObj) throws IOException {
        if (jsonObj == null) {
            if (openapiRequiredFields.isEmpty()) {
                return;
            }
            throw new IllegalArgumentException(String.format("The required field(s) %s in StoreSplitConfiguration is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonObj.entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            log.log(Level.WARNING, String.format("The field `%s` in the JSON string is not defined in the `StoreSplitConfiguration` properties.", entry.getKey()));
        }
        if (jsonObj.get(SERIALIZED_NAME_BALANCE_ACCOUNT_ID) != null && !jsonObj.get(SERIALIZED_NAME_BALANCE_ACCOUNT_ID).isJsonPrimitive()) {
            log.log(Level.WARNING, String.format("Expected the field `balanceAccountId` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_BALANCE_ACCOUNT_ID).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_SPLIT_CONFIGURATION_ID) != null && !jsonObj.get(SERIALIZED_NAME_SPLIT_CONFIGURATION_ID).isJsonPrimitive()) {
            log.log(Level.WARNING, String.format("Expected the field `splitConfigurationId` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_SPLIT_CONFIGURATION_ID).toString()));
        }
    }

    public static StoreSplitConfiguration fromJson(String jsonString) throws IOException {
        return (StoreSplitConfiguration)JSON.getGson().fromJson(jsonString, StoreSplitConfiguration.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_BALANCE_ACCOUNT_ID);
        openapiFields.add(SERIALIZED_NAME_SPLIT_CONFIGURATION_ID);
        openapiRequiredFields = new HashSet();
        log = Logger.getLogger(StoreSplitConfiguration.class.getName());
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!StoreSplitConfiguration.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(StoreSplitConfiguration.class));
            return new TypeAdapter<StoreSplitConfiguration>(){

                public void write(JsonWriter out, StoreSplitConfiguration value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public StoreSplitConfiguration read(JsonReader in) throws IOException {
                    JsonObject jsonObj = ((JsonElement)elementAdapter.read(in)).getAsJsonObject();
                    StoreSplitConfiguration.validateJsonObject(jsonObj);
                    return (StoreSplitConfiguration)thisAdapter.fromJsonTree((JsonElement)jsonObj);
                }
            }.nullSafe();
        }
    }
}

