/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.management;

import com.adyen.model.management.JSON;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class PayPalInfo {
    public static final String SERIALIZED_NAME_DIRECT_CAPTURE = "directCapture";
    @SerializedName(value="directCapture")
    private Boolean directCapture;
    public static final String SERIALIZED_NAME_PAYER_ID = "payerId";
    @SerializedName(value="payerId")
    private String payerId;
    public static final String SERIALIZED_NAME_SUBJECT = "subject";
    @SerializedName(value="subject")
    private String subject;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;
    private static final Logger log;

    public PayPalInfo directCapture(Boolean directCapture) {
        this.directCapture = directCapture;
        return this;
    }

    @ApiModelProperty(value="Indicates if direct (immediate) capture for PayPal is enabled. If set to **true**, this setting overrides the [capture](https://docs.adyen.com/online-payments/capture) settings of your merchant account. Default value: **true**.")
    public Boolean getDirectCapture() {
        return this.directCapture;
    }

    public void setDirectCapture(Boolean directCapture) {
        this.directCapture = directCapture;
    }

    public PayPalInfo payerId(String payerId) {
        this.payerId = payerId;
        return this;
    }

    @ApiModelProperty(required=true, value="PayPal Merchant ID. Character length and limitations: 13 single-byte alphanumeric characters.")
    public String getPayerId() {
        return this.payerId;
    }

    public void setPayerId(String payerId) {
        this.payerId = payerId;
    }

    public PayPalInfo subject(String subject) {
        this.subject = subject;
        return this;
    }

    @ApiModelProperty(required=true, value="Your business email address.")
    public String getSubject() {
        return this.subject;
    }

    public void setSubject(String subject) {
        this.subject = subject;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PayPalInfo payPalInfo = (PayPalInfo)o;
        return Objects.equals(this.directCapture, payPalInfo.directCapture) && Objects.equals(this.payerId, payPalInfo.payerId) && Objects.equals(this.subject, payPalInfo.subject);
    }

    public int hashCode() {
        return Objects.hash(this.directCapture, this.payerId, this.subject);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PayPalInfo {\n");
        sb.append("    directCapture: ").append(this.toIndentedString(this.directCapture)).append("\n");
        sb.append("    payerId: ").append(this.toIndentedString(this.payerId)).append("\n");
        sb.append("    subject: ").append(this.toIndentedString(this.subject)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonObject(JsonObject jsonObj) throws IOException {
        if (jsonObj == null) {
            if (openapiRequiredFields.isEmpty()) {
                return;
            }
            throw new IllegalArgumentException(String.format("The required field(s) %s in PayPalInfo is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonObj.entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            log.log(Level.WARNING, String.format("The field `%s` in the JSON string is not defined in the `PayPalInfo` properties.", entry.getKey()));
        }
        for (String requiredField : openapiRequiredFields) {
            if (jsonObj.get(requiredField) != null) continue;
            throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonObj.toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_PAYER_ID) != null && !jsonObj.get(SERIALIZED_NAME_PAYER_ID).isJsonPrimitive()) {
            log.log(Level.WARNING, String.format("Expected the field `payerId` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_PAYER_ID).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_SUBJECT) != null && !jsonObj.get(SERIALIZED_NAME_SUBJECT).isJsonPrimitive()) {
            log.log(Level.WARNING, String.format("Expected the field `subject` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_SUBJECT).toString()));
        }
    }

    public static PayPalInfo fromJson(String jsonString) throws IOException {
        return (PayPalInfo)JSON.getGson().fromJson(jsonString, PayPalInfo.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_DIRECT_CAPTURE);
        openapiFields.add(SERIALIZED_NAME_PAYER_ID);
        openapiFields.add(SERIALIZED_NAME_SUBJECT);
        openapiRequiredFields = new HashSet();
        openapiRequiredFields.add(SERIALIZED_NAME_PAYER_ID);
        openapiRequiredFields.add(SERIALIZED_NAME_SUBJECT);
        log = Logger.getLogger(PayPalInfo.class.getName());
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!PayPalInfo.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(PayPalInfo.class));
            return new TypeAdapter<PayPalInfo>(){

                public void write(JsonWriter out, PayPalInfo value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public PayPalInfo read(JsonReader in) throws IOException {
                    JsonObject jsonObj = ((JsonElement)elementAdapter.read(in)).getAsJsonObject();
                    PayPalInfo.validateJsonObject(jsonObj);
                    return (PayPalInfo)thisAdapter.fromJsonTree((JsonElement)jsonObj);
                }
            }.nullSafe();
        }
    }
}

