/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.management;

import com.adyen.model.management.CompanyUser;
import com.adyen.model.management.JSON;
import com.adyen.model.management.PaginationLinks;
import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ListCompanyUsersResponse {
    public static final String SERIALIZED_NAME_LINKS = "_links";
    @SerializedName(value="_links")
    private PaginationLinks links;
    public static final String SERIALIZED_NAME_DATA = "data";
    @SerializedName(value="data")
    private List<CompanyUser> data = null;
    public static final String SERIALIZED_NAME_ITEMS_TOTAL = "itemsTotal";
    @SerializedName(value="itemsTotal")
    private Integer itemsTotal;
    public static final String SERIALIZED_NAME_PAGES_TOTAL = "pagesTotal";
    @SerializedName(value="pagesTotal")
    private Integer pagesTotal;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;
    private static final Logger log;

    public ListCompanyUsersResponse links(PaginationLinks links) {
        this.links = links;
        return this;
    }

    @ApiModelProperty(value="")
    public PaginationLinks getLinks() {
        return this.links;
    }

    public void setLinks(PaginationLinks links) {
        this.links = links;
    }

    public ListCompanyUsersResponse data(List<CompanyUser> data) {
        this.data = data;
        return this;
    }

    public ListCompanyUsersResponse addDataItem(CompanyUser dataItem) {
        if (this.data == null) {
            this.data = new ArrayList<CompanyUser>();
        }
        this.data.add(dataItem);
        return this;
    }

    @ApiModelProperty(value="The list of users.")
    public List<CompanyUser> getData() {
        return this.data;
    }

    public void setData(List<CompanyUser> data) {
        this.data = data;
    }

    public ListCompanyUsersResponse itemsTotal(Integer itemsTotal) {
        this.itemsTotal = itemsTotal;
        return this;
    }

    @ApiModelProperty(required=true, value="Total number of items.")
    public Integer getItemsTotal() {
        return this.itemsTotal;
    }

    public void setItemsTotal(Integer itemsTotal) {
        this.itemsTotal = itemsTotal;
    }

    public ListCompanyUsersResponse pagesTotal(Integer pagesTotal) {
        this.pagesTotal = pagesTotal;
        return this;
    }

    @ApiModelProperty(required=true, value="Total number of pages.")
    public Integer getPagesTotal() {
        return this.pagesTotal;
    }

    public void setPagesTotal(Integer pagesTotal) {
        this.pagesTotal = pagesTotal;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ListCompanyUsersResponse listCompanyUsersResponse = (ListCompanyUsersResponse)o;
        return Objects.equals(this.links, listCompanyUsersResponse.links) && Objects.equals(this.data, listCompanyUsersResponse.data) && Objects.equals(this.itemsTotal, listCompanyUsersResponse.itemsTotal) && Objects.equals(this.pagesTotal, listCompanyUsersResponse.pagesTotal);
    }

    public int hashCode() {
        return Objects.hash(this.links, this.data, this.itemsTotal, this.pagesTotal);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ListCompanyUsersResponse {\n");
        sb.append("    links: ").append(this.toIndentedString(this.links)).append("\n");
        sb.append("    data: ").append(this.toIndentedString(this.data)).append("\n");
        sb.append("    itemsTotal: ").append(this.toIndentedString(this.itemsTotal)).append("\n");
        sb.append("    pagesTotal: ").append(this.toIndentedString(this.pagesTotal)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonObject(JsonObject jsonObj) throws IOException {
        JsonArray jsonArraydata;
        if (jsonObj == null) {
            if (openapiRequiredFields.isEmpty()) {
                return;
            }
            throw new IllegalArgumentException(String.format("The required field(s) %s in ListCompanyUsersResponse is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonObj.entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            log.log(Level.WARNING, String.format("The field `%s` in the JSON string is not defined in the `ListCompanyUsersResponse` properties.", entry.getKey()));
        }
        for (String requiredField : openapiRequiredFields) {
            if (jsonObj.get(requiredField) != null) continue;
            throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonObj.toString()));
        }
        if (jsonObj.getAsJsonObject(SERIALIZED_NAME_LINKS) != null) {
            PaginationLinks.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_LINKS));
        }
        if ((jsonArraydata = jsonObj.getAsJsonArray(SERIALIZED_NAME_DATA)) != null) {
            if (!jsonObj.get(SERIALIZED_NAME_DATA).isJsonArray()) {
                throw new IllegalArgumentException(String.format("Expected the field `data` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_DATA).toString()));
            }
            for (int i = 0; i < jsonArraydata.size(); ++i) {
                CompanyUser.validateJsonObject(jsonArraydata.get(i).getAsJsonObject());
            }
        }
    }

    public static ListCompanyUsersResponse fromJson(String jsonString) throws IOException {
        return (ListCompanyUsersResponse)JSON.getGson().fromJson(jsonString, ListCompanyUsersResponse.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_LINKS);
        openapiFields.add(SERIALIZED_NAME_DATA);
        openapiFields.add(SERIALIZED_NAME_ITEMS_TOTAL);
        openapiFields.add(SERIALIZED_NAME_PAGES_TOTAL);
        openapiRequiredFields = new HashSet();
        openapiRequiredFields.add(SERIALIZED_NAME_ITEMS_TOTAL);
        openapiRequiredFields.add(SERIALIZED_NAME_PAGES_TOTAL);
        log = Logger.getLogger(ListCompanyUsersResponse.class.getName());
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!ListCompanyUsersResponse.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(ListCompanyUsersResponse.class));
            return new TypeAdapter<ListCompanyUsersResponse>(){

                public void write(JsonWriter out, ListCompanyUsersResponse value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public ListCompanyUsersResponse read(JsonReader in) throws IOException {
                    JsonObject jsonObj = ((JsonElement)elementAdapter.read(in)).getAsJsonObject();
                    ListCompanyUsersResponse.validateJsonObject(jsonObj);
                    return (ListCompanyUsersResponse)thisAdapter.fromJsonTree((JsonElement)jsonObj);
                }
            }.nullSafe();
        }
    }
}

