/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.management;

import com.adyen.model.management.JSON;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Connectivity {
    public static final String SERIALIZED_NAME_SIMCARD_STATUS = "simcardStatus";
    @SerializedName(value="simcardStatus")
    private SimcardStatusEnum simcardStatus;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;
    private static final Logger log;

    public Connectivity simcardStatus(SimcardStatusEnum simcardStatus) {
        this.simcardStatus = simcardStatus;
        return this;
    }

    @ApiModelProperty(value="Indicates the status of the SIM card in the payment terminal. Can be updated and received only at terminal level, and only for models that support cellular connectivity.  Possible values: * **ACTIVATED**: the SIM card is activated. Cellular connectivity may still need to be enabled on the terminal itself, in the **Network** settings. * **INVENTORY**: the SIM card is not activated. The terminal can't use cellular connectivity.")
    public SimcardStatusEnum getSimcardStatus() {
        return this.simcardStatus;
    }

    public void setSimcardStatus(SimcardStatusEnum simcardStatus) {
        this.simcardStatus = simcardStatus;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Connectivity connectivity = (Connectivity)o;
        return Objects.equals((Object)this.simcardStatus, (Object)connectivity.simcardStatus);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.simcardStatus});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Connectivity {\n");
        sb.append("    simcardStatus: ").append(this.toIndentedString((Object)this.simcardStatus)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonObject(JsonObject jsonObj) throws IOException {
        if (jsonObj == null) {
            if (openapiRequiredFields.isEmpty()) {
                return;
            }
            throw new IllegalArgumentException(String.format("The required field(s) %s in Connectivity is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonObj.entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            log.log(Level.WARNING, String.format("The field `%s` in the JSON string is not defined in the `Connectivity` properties.", entry.getKey()));
        }
        if (jsonObj.get(SERIALIZED_NAME_SIMCARD_STATUS) != null) {
            if (!jsonObj.get(SERIALIZED_NAME_SIMCARD_STATUS).isJsonPrimitive()) {
                throw new IllegalArgumentException(String.format("Expected the field `simcardStatus` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_SIMCARD_STATUS).toString()));
            }
            SimcardStatusEnum.fromValue(jsonObj.get(SERIALIZED_NAME_SIMCARD_STATUS).getAsString());
        }
    }

    public static Connectivity fromJson(String jsonString) throws IOException {
        return (Connectivity)JSON.getGson().fromJson(jsonString, Connectivity.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_SIMCARD_STATUS);
        openapiRequiredFields = new HashSet();
        log = Logger.getLogger(Connectivity.class.getName());
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!Connectivity.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(Connectivity.class));
            return new TypeAdapter<Connectivity>(){

                public void write(JsonWriter out, Connectivity value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public Connectivity read(JsonReader in) throws IOException {
                    JsonObject jsonObj = ((JsonElement)elementAdapter.read(in)).getAsJsonObject();
                    Connectivity.validateJsonObject(jsonObj);
                    return (Connectivity)thisAdapter.fromJsonTree((JsonElement)jsonObj);
                }
            }.nullSafe();
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum SimcardStatusEnum {
        ACTIVATED("ACTIVATED"),
        INVENTORY("INVENTORY");

        private String value;

        private SimcardStatusEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static SimcardStatusEnum fromValue(String value) {
            for (SimcardStatusEnum b : SimcardStatusEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public static class Adapter
        extends TypeAdapter<SimcardStatusEnum> {
            public void write(JsonWriter jsonWriter, SimcardStatusEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public SimcardStatusEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return SimcardStatusEnum.fromValue(value);
            }
        }
    }
}

